/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.parser;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.BitSet;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.asterix.builders.IARecordBuilder;
import org.apache.asterix.builders.IAsterixListBuilder;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.api.IExternalDataRuntimeContext;
import org.apache.asterix.external.input.filter.embedder.IExternalFilterValueEmbedder;
import org.apache.asterix.external.parser.AbstractNestedDataParser;
import org.apache.asterix.external.parser.ParseException;
import org.apache.asterix.external.parser.jackson.ADMToken;
import org.apache.asterix.external.parser.jackson.GeometryCoParser;
import org.apache.asterix.external.parser.jackson.ParserContext;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.base.AUnorderedList;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.RecordUtil;
import org.apache.asterix.runtime.exceptions.UnsupportedTypeException;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.util.ExceptionUtils;
import org.apache.hyracks.data.std.api.IMutableValueStorage;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.util.LogRedactionUtil;
import org.apache.hyracks.util.ParseUtil;

public abstract class AbstractJsonDataParser
extends AbstractNestedDataParser<ADMToken> {
    protected final ParserContext parserContext;
    protected final JsonFactory jsonFactory;
    protected final ARecordType rootType;
    protected final GeometryCoParser geometryCoParser;
    protected final Supplier<String> dataSourceName;
    protected final LongSupplier lineNumber;
    protected final IExternalFilterValueEmbedder valueEmbedder;
    protected JsonParser jsonParser;

    public AbstractJsonDataParser(ARecordType recordType, JsonFactory jsonFactory, IExternalDataRuntimeContext context) {
        this.rootType = recordType != null ? recordType : RecordUtil.FULLY_OPEN_RECORD_TYPE;
        this.jsonFactory = jsonFactory;
        this.geometryCoParser = new GeometryCoParser(this.jsonParser);
        this.parserContext = new ParserContext();
        this.dataSourceName = context.getDatasourceNameSupplier();
        this.lineNumber = context.getLineNumberSupplier();
        this.valueEmbedder = context.getValueEmbedder();
    }

    public boolean parseAnyValue(DataOutput out) throws HyracksDataException {
        try {
            if (this.nextToken() == ADMToken.EOF) {
                return false;
            }
            this.parseValue((IAType)BuiltinType.ANY, out);
            return true;
        }
        catch (IOException e) {
            throw this.createException(e);
        }
    }

    @Override
    protected final ADMToken advanceToNextToken() throws IOException {
        ADMToken token;
        JsonToken jsonToken = this.jsonParser.nextToken();
        if (jsonToken == null) {
            return ADMToken.EOF;
        }
        switch (jsonToken) {
            case VALUE_FALSE: {
                token = ADMToken.FALSE;
                break;
            }
            case VALUE_TRUE: {
                token = ADMToken.TRUE;
                break;
            }
            case VALUE_STRING: {
                token = ADMToken.STRING;
                break;
            }
            case VALUE_NULL: {
                token = ADMToken.NULL;
                break;
            }
            case VALUE_NUMBER_FLOAT: {
                token = ADMToken.DOUBLE;
                break;
            }
            case VALUE_NUMBER_INT: {
                token = ADMToken.INT;
                break;
            }
            case START_OBJECT: {
                token = ADMToken.OBJECT_START;
                break;
            }
            case END_OBJECT: {
                token = ADMToken.OBJECT_END;
                break;
            }
            case START_ARRAY: {
                token = ADMToken.ARRAY_START;
                break;
            }
            case END_ARRAY: {
                token = ADMToken.ARRAY_END;
                break;
            }
            case FIELD_NAME: {
                token = ADMToken.FIELD_NAME;
                break;
            }
            default: {
                throw new RuntimeDataException(org.apache.asterix.common.exceptions.ErrorCode.TYPE_UNSUPPORTED, new Serializable[]{this.jsonParser.currentToken().toString()});
            }
        }
        return token;
    }

    @Override
    protected boolean isConvertable(ATypeTag parsedTypeTag, ATypeTag definedTypeTag) {
        if (parsedTypeTag == ATypeTag.OBJECT && (definedTypeTag == ATypeTag.POINT || definedTypeTag == ATypeTag.LINE || definedTypeTag == ATypeTag.POLYGON)) {
            return true;
        }
        return super.isConvertable(parsedTypeTag, definedTypeTag);
    }

    @Override
    protected final void parseObject(ARecordType recordType, DataOutput out) throws IOException {
        IMutableValueStorage valueBuffer = this.parserContext.enterObject();
        IARecordBuilder objectBuilder = this.parserContext.getObjectBuilder(recordType);
        BitSet nullBitMap = this.parserContext.getNullBitmap(recordType.getFieldTypes().length);
        this.valueEmbedder.enterObject();
        while (this.nextToken() != ADMToken.OBJECT_END) {
            String fieldName = this.jsonParser.getCurrentName();
            int fieldIndex = recordType.getFieldIndex(fieldName);
            if (!recordType.isOpen() && fieldIndex < 0) {
                throw new RuntimeDataException(org.apache.asterix.common.exceptions.ErrorCode.PARSER_ADM_DATA_PARSER_EXTRA_FIELD_IN_CLOSED_RECORD, new Serializable[]{LogRedactionUtil.userData((String)fieldName)});
            }
            valueBuffer.reset();
            this.nextToken();
            if (fieldIndex < 0) {
                IMutableValueStorage fieldValue;
                if (this.valueEmbedder.shouldEmbed(fieldName, ((ADMToken)((Object)this.currentToken())).getTypeTag())) {
                    fieldValue = this.valueEmbedder.getEmbeddedValue();
                    this.jsonParser.skipChildren();
                } else {
                    fieldValue = valueBuffer;
                    this.parseValue((IAType)BuiltinType.ANY, valueBuffer.getDataOutput());
                }
                objectBuilder.addField((IValueReference)this.parserContext.getSerializedFieldName(fieldName), (IValueReference)fieldValue);
                continue;
            }
            IAType fieldType = recordType.getFieldType(fieldName);
            if (this.currentToken() == ADMToken.NULL && !this.isNullableType(fieldType)) {
                throw new RuntimeDataException(org.apache.asterix.common.exceptions.ErrorCode.PARSER_EXT_DATA_PARSER_CLOSED_FIELD_NULL, new Serializable[]{LogRedactionUtil.userData((String)fieldName)});
            }
            nullBitMap.set(fieldIndex);
            this.parseValue(fieldType, valueBuffer.getDataOutput());
            objectBuilder.addField(fieldIndex, (IValueReference)valueBuffer);
        }
        if (nullBitMap != null) {
            this.checkOptionalConstraints(recordType, nullBitMap);
        }
        if (this.valueEmbedder.isMissingEmbeddedValues()) {
            String[] embeddedFieldNames = this.valueEmbedder.getEmbeddedFieldNames();
            for (int i = 0; i < embeddedFieldNames.length; ++i) {
                String embeddedFieldName = embeddedFieldNames[i];
                if (!this.valueEmbedder.isMissing(embeddedFieldName)) continue;
                IValueReference embeddedValue = this.valueEmbedder.getEmbeddedValue();
                objectBuilder.addField((IValueReference)this.parserContext.getSerializedFieldName(embeddedFieldName), embeddedValue);
            }
        }
        this.valueEmbedder.exitObject();
        this.parserContext.exitObject(valueBuffer, nullBitMap, objectBuilder);
        objectBuilder.write(out, true);
    }

    private void parseGeometry(ATypeTag typeTag, DataOutput out) throws IOException {
        this.geometryCoParser.starGeometry();
        while (this.nextToken() != ADMToken.OBJECT_END) {
            if (this.currentToken() == ADMToken.FIELD_NAME) {
                this.geometryCoParser.checkFieldName(this.jsonParser.getCurrentName());
                continue;
            }
            if (this.geometryCoParser.checkValue((ADMToken)((Object)this.currentToken()))) continue;
            throw new IOException(this.geometryCoParser.getErrorMessage());
        }
        this.geometryCoParser.serialize(typeTag, out);
    }

    @Override
    protected final void parseArray(AOrderedListType listType, DataOutput out) throws IOException {
        this.parseCollection((AbstractCollectionType)listType, ADMToken.ARRAY_END, out);
    }

    @Override
    protected void parseMultiset(AUnorderedList listType, DataOutput out) throws IOException {
        throw new UnsupportedTypeException("JSON parser", ATypeTag.SERIALIZED_UNORDEREDLIST_TYPE_TAG);
    }

    protected final void parseCollection(AbstractCollectionType collectionType, ADMToken endToken, DataOutput out) throws IOException {
        boolean isOpen;
        IMutableValueStorage valueBuffer = this.parserContext.enterCollection();
        IAsterixListBuilder arrayBuilder = this.parserContext.getCollectionBuilder(collectionType);
        boolean bl = isOpen = collectionType.getItemType().getTypeTag() == ATypeTag.ANY;
        while (this.nextToken() != endToken) {
            valueBuffer.reset();
            if (isOpen) {
                this.parseValue((IAType)BuiltinType.ANY, valueBuffer.getDataOutput());
            } else {
                if (this.currentToken() == ADMToken.NULL) {
                    throw new RuntimeDataException(org.apache.asterix.common.exceptions.ErrorCode.PARSER_COLLECTION_ITEM_CANNOT_BE_NULL, new Serializable[0]);
                }
                this.parseValue(collectionType.getItemType(), valueBuffer.getDataOutput());
            }
            arrayBuilder.addItem((IValueReference)valueBuffer);
        }
        this.parserContext.exitCollection(valueBuffer, arrayBuilder);
        arrayBuilder.write(out, true);
    }

    protected void parseObject(IAType actualType, DataOutput out) throws IOException {
        if (actualType.getTypeTag() == ATypeTag.OBJECT) {
            this.parseObject((ARecordType)actualType, out);
        } else {
            this.parseGeometry(actualType.getTypeTag(), out);
        }
    }

    protected void parseValue(IAType definedType, DataOutput out) throws IOException {
        ATypeTag currentTypeTag = ((ADMToken)((Object)this.currentToken())).getTypeTag();
        IAType actualType = this.checkAndGetType(definedType, currentTypeTag);
        switch ((ADMToken)((Object)this.currentToken())) {
            case NULL: {
                this.nullSerde.serialize((Object)ANull.NULL, out);
                break;
            }
            case FALSE: {
                this.booleanSerde.serialize((Object)ABoolean.FALSE, out);
                break;
            }
            case TRUE: {
                this.booleanSerde.serialize((Object)ABoolean.TRUE, out);
                break;
            }
            case INT: 
            case DOUBLE: {
                this.serializeNumeric(actualType.getTypeTag(), out);
                break;
            }
            case STRING: {
                this.serializeString(actualType.getTypeTag(), out);
                break;
            }
            case OBJECT_START: {
                this.parseObject(actualType, out);
                break;
            }
            case ARRAY_START: {
                this.parseArray((AOrderedListType)actualType, out);
                break;
            }
            default: {
                throw new RuntimeDataException(org.apache.asterix.common.exceptions.ErrorCode.PARSE_ERROR, new Serializable[]{this.jsonParser.currentToken().toString()});
            }
        }
    }

    protected void serializeNumeric(ATypeTag numericType, DataOutput out) throws IOException {
        ATypeTag typeToUse = numericType == ATypeTag.ANY ? ((ADMToken)((Object)this.currentToken())).getTypeTag() : numericType;
        switch (typeToUse) {
            case BIGINT: {
                this.aInt64.setValue(this.jsonParser.getLongValue());
                this.int64Serde.serialize((Object)this.aInt64, out);
                break;
            }
            case INTEGER: {
                this.aInt32.setValue(this.jsonParser.getIntValue());
                this.int32Serde.serialize((Object)this.aInt32, out);
                break;
            }
            case SMALLINT: {
                this.aInt16.setValue(this.jsonParser.getShortValue());
                this.int16Serde.serialize((Object)this.aInt16, out);
                break;
            }
            case TINYINT: {
                this.aInt8.setValue(this.jsonParser.getByteValue());
                this.int8Serde.serialize((Object)this.aInt8, out);
                break;
            }
            case DOUBLE: {
                this.aDouble.setValue(this.jsonParser.getDoubleValue());
                this.doubleSerde.serialize((Object)this.aDouble, out);
                break;
            }
            case FLOAT: {
                this.aFloat.setValue(this.jsonParser.getFloatValue());
                this.floatSerde.serialize((Object)this.aFloat, out);
                break;
            }
            default: {
                throw new RuntimeDataException(org.apache.asterix.common.exceptions.ErrorCode.TYPE_UNSUPPORTED, new Serializable[]{this.jsonParser.currentToken().toString()});
            }
        }
    }

    protected void serializeString(ATypeTag stringVariantType, DataOutput out) throws IOException {
        char[] buffer = this.jsonParser.getTextCharacters();
        int begin = this.jsonParser.getTextOffset();
        int len = this.jsonParser.getTextLength();
        ATypeTag typeToUse = stringVariantType == ATypeTag.ANY ? ((ADMToken)((Object)this.currentToken())).getTypeTag() : stringVariantType;
        switch (typeToUse) {
            case STRING: {
                this.parseString(buffer, begin, len, out);
                break;
            }
            case DATE: {
                this.parseDate(buffer, begin, len, out);
                break;
            }
            case DATETIME: {
                this.parseDateTime(buffer, begin, len, out);
                break;
            }
            case TIME: {
                this.parseTime(buffer, begin, len, out);
                break;
            }
            case YEARMONTHDURATION: {
                this.parseYearMonthDuration(buffer, begin, len, out);
                break;
            }
            case DAYTIMEDURATION: {
                this.parseDateTimeDuration(buffer, begin, len, out);
                break;
            }
            case DURATION: {
                this.parseDuration(buffer, begin, len, out);
                break;
            }
            case UUID: {
                this.parseUUID(buffer, begin, len, out);
                break;
            }
            default: {
                throw new RuntimeDataException(org.apache.asterix.common.exceptions.ErrorCode.TYPE_UNSUPPORTED, new Serializable[]{this.jsonParser.currentToken().toString()});
            }
        }
    }

    protected HyracksDataException createException(Exception e) {
        if (this.jsonParser != null) {
            Throwable rootCause;
            String msg = e instanceof JsonParseException ? ((JsonParseException)e).getOriginalMessage() : ((rootCause = ExceptionUtils.getRootCause((Throwable)e)) instanceof ParseException ? ((ParseException)((Object)rootCause)).getOriginalMessage() : ExceptionUtils.getRootCause((Throwable)e).getMessage());
            if (msg == null) {
                msg = org.apache.asterix.common.exceptions.ErrorCode.RECORD_READER_MALFORMED_INPUT_STREAM.errorMessage();
            }
            long lineNum = this.lineNumber.getAsLong() + (long)this.jsonParser.getCurrentLocation().getLineNr() - 1L;
            String fieldName = null;
            for (JsonStreamContext parsingContext = this.jsonParser.getParsingContext(); parsingContext != null && fieldName == null; parsingContext = parsingContext.getParent()) {
                fieldName = parsingContext.getCurrentName();
            }
            String locationDetails = ParseUtil.asLocationDetailString((String)this.dataSourceName.get(), (long)lineNum, (Object)fieldName);
            return HyracksDataException.create((ErrorCode)ErrorCode.PARSING_ERROR, (Serializable[])new Serializable[]{locationDetails, msg});
        }
        return new RuntimeDataException(org.apache.asterix.common.exceptions.ErrorCode.RECORD_READER_MALFORMED_INPUT_STREAM, (Throwable)e, new Serializable[0]);
    }
}

