/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.library;

import java.io.Serializable;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.common.metadata.Namespace;
import org.apache.asterix.external.api.IExternalScalarFunction;
import org.apache.asterix.external.api.IFunctionFactory;
import org.apache.asterix.external.library.ExternalScalarFunctionEvaluator;
import org.apache.asterix.external.library.JavaFunctionHelper;
import org.apache.asterix.external.library.JavaLibrary;
import org.apache.asterix.om.functions.IExternalFunctionInfo;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IDataOutputProvider;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class ExternalScalarJavaFunctionEvaluator
extends ExternalScalarFunctionEvaluator {
    private final IExternalScalarFunction externalFunctionInstance;
    private final IPointable inputVal = VoidPointable.FACTORY.createPointable();
    private final ArrayBackedValueStorage resultBuffer = new ArrayBackedValueStorage();
    protected final JavaFunctionHelper functionHelper;

    ExternalScalarJavaFunctionEvaluator(IExternalFunctionInfo finfo, IScalarEvaluatorFactory[] args, IAType[] argTypes, IEvaluatorContext context) throws HyracksDataException {
        super(finfo, args, argTypes, context);
        Namespace libraryNamespace = finfo.getLibraryNamespace();
        String libraryName = finfo.getLibraryName();
        JavaLibrary library = (JavaLibrary)this.libraryManager.getLibrary(libraryNamespace, libraryName);
        String classname = (String)finfo.getExternalIdentifier().get(0);
        try {
            Class<?> clazz = Class.forName(classname, false, library.getClassLoader());
            if (!IFunctionFactory.class.isAssignableFrom(clazz)) {
                throw new ClassCastException("Specified class does not implement IFunctionFactory");
            }
            IFunctionFactory externalFunctionFactory = (IFunctionFactory)clazz.newInstance();
            this.externalFunctionInstance = (IExternalScalarFunction)externalFunctionFactory.getExternalFunction();
        }
        catch (Exception e) {
            throw new RuntimeDataException(ErrorCode.LIBRARY_EXTERNAL_FUNCTION_UNABLE_TO_LOAD_CLASS, (Throwable)e, new Serializable[]{classname});
        }
        this.functionHelper = new JavaFunctionHelper(finfo, argTypes, (IDataOutputProvider)this.resultBuffer);
        try {
            this.externalFunctionInstance.initialize(this.functionHelper);
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        try {
            boolean nullCall = this.finfo.getNullCall();
            boolean hasNullArg = false;
            for (int i = 0; i < this.argEvals.length; ++i) {
                this.argEvals[i].evaluate(tuple, this.inputVal);
                if (!nullCall) {
                    int inputValStartOffset;
                    byte[] inputValBytes = this.inputVal.getByteArray();
                    ATypeTag typeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(inputValBytes[inputValStartOffset = this.inputVal.getStartOffset()]);
                    if (typeTag == ATypeTag.MISSING) {
                        PointableHelper.setMissing((IPointable)result);
                        return;
                    }
                    if (typeTag == ATypeTag.NULL) {
                        hasNullArg = true;
                    }
                }
                this.functionHelper.setArgument(i, (IValueReference)this.inputVal);
            }
            if (!nullCall && hasNullArg) {
                PointableHelper.setNull((IPointable)result);
            } else {
                this.resultBuffer.reset();
                this.externalFunctionInstance.evaluate(this.functionHelper);
                if (!this.functionHelper.isValidResult()) {
                    throw new RuntimeDataException(ErrorCode.EXTERNAL_UDF_RESULT_TYPE_ERROR, new Serializable[0]);
                }
                result.set(this.resultBuffer.getByteArray(), this.resultBuffer.getStartOffset(), this.resultBuffer.getLength());
                this.functionHelper.reset();
            }
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }
}

