/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.hdfs.parquet.converter;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.TimeZone;
import org.apache.asterix.dataflow.data.nontagged.serde.AStringSerializerDeserializer;
import org.apache.asterix.external.input.filter.NoOpFilterValueEmbedder;
import org.apache.asterix.external.input.filter.embedder.IExternalFilterValueEmbedder;
import org.apache.asterix.external.input.stream.StandardUTF8ToModifiedUTF8OutputStream;
import org.apache.asterix.external.parser.jackson.ParserContext;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ABinary;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.ADate;
import org.apache.asterix.om.base.ADateTime;
import org.apache.asterix.om.base.ADouble;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AMutableDate;
import org.apache.asterix.om.base.AMutableDateTime;
import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.base.AMutableTime;
import org.apache.asterix.om.base.ATime;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.Warning;
import org.apache.hyracks.data.std.api.IMutableValueStorage;
import org.apache.hyracks.util.encoding.VarLenIntEncoderDecoder;
import org.apache.hyracks.util.string.UTF8StringReader;
import org.apache.hyracks.util.string.UTF8StringWriter;
import org.apache.parquet.io.api.Binary;

public class ParquetConverterContext
extends ParserContext {
    private final ISerializerDeserializer<ABoolean> booleanSerDer = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ABOOLEAN);
    private final ISerializerDeserializer<AInt64> int64SerDer = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
    private final ISerializerDeserializer<ADouble> doubleSerDer = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADOUBLE);
    private final ISerializerDeserializer<ABinary> binarySerDer = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ABINARY);
    private final ISerializerDeserializer<ADate> dateSerDer = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADATE);
    private final ISerializerDeserializer<ATime> timeSerDer = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ATIME);
    private final ISerializerDeserializer<ADateTime> datetimeSerDer = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADATETIME);
    private final List<Warning> warnings;
    private final StandardUTF8ToModifiedUTF8OutputStream modifiedUTF8DataOutput;
    private byte[] lengthBytes;
    private final AMutableInt64 mutableInt64 = new AMutableInt64(0L);
    private final AMutableDouble mutableDouble = new AMutableDouble(0.0);
    private final AMutableDate mutableDate = new AMutableDate(0);
    private final AMutableTime mutableTime = new AMutableTime(0);
    private final AMutableDateTime mutableDateTime = new AMutableDateTime(0L);
    private final boolean parseJson;
    private final boolean decimalToDouble;
    private final String timeZoneId;
    private final int timeZoneOffset;
    private final IExternalFilterValueEmbedder valueEmbedder;

    public ParquetConverterContext(Configuration configuration, List<Warning> warnings) {
        this(configuration, NoOpFilterValueEmbedder.INSTANCE, warnings);
    }

    public ParquetConverterContext(Configuration configuration, IExternalFilterValueEmbedder valueEmbedder, List<Warning> warnings) {
        this.warnings = warnings;
        this.valueEmbedder = valueEmbedder;
        this.modifiedUTF8DataOutput = new StandardUTF8ToModifiedUTF8OutputStream(new AStringSerializerDeserializer(new UTF8StringWriter(), new UTF8StringReader()));
        this.parseJson = configuration.getBoolean("org.apache.asterix.parse-json-string", false);
        this.decimalToDouble = configuration.getBoolean("org.apache.asterix.decimal-to-double", false);
        String configuredTimeZoneId = configuration.get("org.apache.asterix.timezone");
        if (!configuredTimeZoneId.isEmpty()) {
            this.timeZoneId = configuredTimeZoneId;
            this.timeZoneOffset = TimeZone.getTimeZone(this.timeZoneId).getRawOffset();
        } else {
            this.timeZoneId = "";
            this.timeZoneOffset = 0;
        }
    }

    public IExternalFilterValueEmbedder getValueEmbedder() {
        return this.valueEmbedder;
    }

    public List<Warning> getWarnings() {
        return this.warnings;
    }

    public boolean isParseJsonEnabled() {
        return this.parseJson;
    }

    public boolean isDecimalToDoubleEnabled() {
        return this.decimalToDouble;
    }

    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public int getTimeZoneOffset() {
        return this.timeZoneOffset;
    }

    @Override
    public IMutableValueStorage getSerializedFieldName(String fieldName) throws IOException {
        if (fieldName == null) {
            return null;
        }
        return super.getSerializedFieldName(fieldName);
    }

    public void serializeBoolean(boolean value, DataOutput output) {
        try {
            this.booleanSerDer.serialize((Object)(value ? ABoolean.TRUE : ABoolean.FALSE), output);
        }
        catch (HyracksDataException e) {
            throw new IllegalStateException(e);
        }
    }

    public void serializeInt64(long value, DataOutput output) {
        try {
            this.mutableInt64.setValue(value);
            this.int64SerDer.serialize((Object)this.mutableInt64, output);
        }
        catch (HyracksDataException e) {
            throw new IllegalStateException(e);
        }
    }

    public void serializeDouble(double value, DataOutput output) {
        try {
            this.mutableDouble.setValue(value);
            this.doubleSerDer.serialize((Object)this.mutableDouble, output);
        }
        catch (HyracksDataException e) {
            throw new IllegalStateException(e);
        }
    }

    public void serializeString(Binary value, DataOutput output) {
        this.modifiedUTF8DataOutput.setDataOutput(output);
        try {
            output.writeByte(ATypeTag.STRING.serialize());
            value.writeTo((OutputStream)this.modifiedUTF8DataOutput);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void serializeUUID(Binary value, DataOutput output) {
        try {
            output.writeByte(ATypeTag.UUID.serialize());
            value.writeTo(output);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void serializeBinary(Binary value, DataOutput output) {
        try {
            output.writeByte(ATypeTag.BINARY.serialize());
            this.writeLength(value.length(), output);
            value.writeTo(output);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void serializeDate(int value, DataOutput output) {
        try {
            this.mutableDate.setValue(value);
            this.dateSerDer.serialize((Object)this.mutableDate, output);
        }
        catch (HyracksDataException e) {
            throw new IllegalStateException(e);
        }
    }

    public void serializeTime(int value, DataOutput output) {
        try {
            this.mutableTime.setValue(value);
            this.timeSerDer.serialize((Object)this.mutableTime, output);
        }
        catch (HyracksDataException e) {
            throw new IllegalStateException(e);
        }
    }

    public void serializeDateTime(long timestamp, DataOutput output) {
        try {
            this.mutableDateTime.setValue(timestamp);
            this.datetimeSerDer.serialize((Object)this.mutableDateTime, output);
        }
        catch (HyracksDataException e) {
            throw new IllegalStateException(e);
        }
    }

    private void writeLength(int length, DataOutput out) throws IOException {
        int requiredLength = VarLenIntEncoderDecoder.getBytesRequired((int)length);
        if (this.lengthBytes == null || requiredLength > this.lengthBytes.length) {
            this.lengthBytes = new byte[requiredLength];
        }
        VarLenIntEncoderDecoder.encode((int)length, (byte[])this.lengthBytes, (int)0);
        out.write(this.lengthBytes, 0, requiredLength);
    }
}

