/*
 * Decompiled with CFR 0.152.
 */
package tech.allegro.schema.json2avro.converter.types;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import tech.allegro.schema.json2avro.converter.types.AbstractIntDateTimeConverter;
import tech.allegro.schema.json2avro.converter.types.AvroTypeConverter;

public class IntTimeMillisConverter
extends AbstractIntDateTimeConverter {
    public static final AvroTypeConverter INSTANCE = new IntTimeMillisConverter(DateTimeFormatter.ISO_TIME);
    private final DateTimeFormatter dateTimeFormatter;

    public IntTimeMillisConverter(DateTimeFormatter dateTimeFormatter) {
        this.dateTimeFormatter = dateTimeFormatter;
    }

    @Override
    protected Object convertDateTimeString(String dateTimeString) {
        long nanoOfDay = this.parseLocalTime(dateTimeString).toNanoOfDay();
        return TimeUnit.NANOSECONDS.toMillis(nanoOfDay);
    }

    protected LocalTime parseLocalTime(String dateTimeString) {
        return LocalTime.from(this.dateTimeFormatter.parse(dateTimeString));
    }

    @Override
    protected LogicalType getLogicalType() {
        return LogicalTypes.timeMillis();
    }

    @Override
    protected String getValidStringFormat() {
        return "time";
    }

    @Override
    protected String getValidNumberFormat() {
        return "millis";
    }
}

