/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import org.apache.asterix.om.typecomputer.base.AbstractResultTypeComputer;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;

public class NumericAddSubMulDivTypeComputer
extends AbstractResultTypeComputer {
    public static final NumericAddSubMulDivTypeComputer INSTANCE_MUL_POW = new NumericAddSubMulDivTypeComputer(false, false, false);
    public static final NumericAddSubMulDivTypeComputer INSTANCE_DIV_MOD = new NumericAddSubMulDivTypeComputer(true, false, false);
    public static final NumericAddSubMulDivTypeComputer INSTANCE_ADD = new NumericAddSubMulDivTypeComputer(false, true, false);
    public static final NumericAddSubMulDivTypeComputer INSTANCE_SUB = new NumericAddSubMulDivTypeComputer(false, true, true);
    private final boolean nullable;
    private final boolean isMixedTemporalAllowed;
    private final boolean isSameTemporalAllowed;

    private NumericAddSubMulDivTypeComputer(boolean nullable, boolean isMixedTemporalAllowed, boolean isSameTemporalAllowed) {
        this.nullable = nullable;
        this.isMixedTemporalAllowed = isMixedTemporalAllowed;
        this.isSameTemporalAllowed = isSameTemporalAllowed;
    }

    @Override
    protected IAType getResultType(ILogicalExpression expr, IAType ... strippedInputTypes) throws AlgebricksException {
        IAType type;
        IAType t1 = strippedInputTypes[0];
        IAType t2 = strippedInputTypes[1];
        ATypeTag tag1 = t1.getTypeTag();
        ATypeTag tag2 = t2.getTypeTag();
        block0 : switch (tag1) {
            case DOUBLE: {
                switch (tag2) {
                    case TINYINT: 
                    case SMALLINT: 
                    case INTEGER: 
                    case BIGINT: 
                    case FLOAT: 
                    case DOUBLE: {
                        type = BuiltinType.ADOUBLE;
                        break block0;
                    }
                    case ANY: {
                        type = BuiltinType.ANY;
                        break block0;
                    }
                }
                return BuiltinType.ANULL;
            }
            case FLOAT: {
                switch (tag2) {
                    case TINYINT: 
                    case SMALLINT: 
                    case INTEGER: 
                    case BIGINT: 
                    case FLOAT: {
                        type = BuiltinType.AFLOAT;
                        break block0;
                    }
                    case DOUBLE: {
                        type = BuiltinType.ADOUBLE;
                        break block0;
                    }
                    case ANY: {
                        type = BuiltinType.ANY;
                        break block0;
                    }
                }
                return BuiltinType.ANULL;
            }
            case BIGINT: {
                switch (tag2) {
                    case TINYINT: 
                    case SMALLINT: 
                    case INTEGER: 
                    case BIGINT: {
                        type = BuiltinType.AINT64;
                        break block0;
                    }
                    case FLOAT: {
                        type = BuiltinType.AFLOAT;
                        break block0;
                    }
                    case DOUBLE: {
                        type = BuiltinType.ADOUBLE;
                        break block0;
                    }
                    case ANY: {
                        type = BuiltinType.ANY;
                        break block0;
                    }
                }
                return BuiltinType.ANULL;
            }
            case INTEGER: {
                switch (tag2) {
                    case TINYINT: 
                    case SMALLINT: 
                    case INTEGER: {
                        type = BuiltinType.AINT32;
                        break block0;
                    }
                    case BIGINT: {
                        type = BuiltinType.AINT64;
                        break block0;
                    }
                    case FLOAT: {
                        type = BuiltinType.AFLOAT;
                        break block0;
                    }
                    case DOUBLE: {
                        type = BuiltinType.ADOUBLE;
                        break block0;
                    }
                    case ANY: {
                        type = BuiltinType.ANY;
                        break block0;
                    }
                }
                return BuiltinType.ANULL;
            }
            case SMALLINT: {
                switch (tag2) {
                    case TINYINT: 
                    case SMALLINT: {
                        type = BuiltinType.AINT16;
                        break block0;
                    }
                    case INTEGER: {
                        type = BuiltinType.AINT32;
                        break block0;
                    }
                    case BIGINT: {
                        type = BuiltinType.AINT64;
                        break block0;
                    }
                    case FLOAT: {
                        type = BuiltinType.AFLOAT;
                        break block0;
                    }
                    case DOUBLE: {
                        type = BuiltinType.ADOUBLE;
                        break block0;
                    }
                    case ANY: {
                        type = BuiltinType.ANY;
                        break block0;
                    }
                }
                return BuiltinType.ANULL;
            }
            case TINYINT: {
                switch (tag2) {
                    case TINYINT: {
                        type = BuiltinType.AINT8;
                        break block0;
                    }
                    case SMALLINT: {
                        type = BuiltinType.AINT16;
                        break block0;
                    }
                    case INTEGER: {
                        type = BuiltinType.AINT32;
                        break block0;
                    }
                    case BIGINT: {
                        type = BuiltinType.AINT64;
                        break block0;
                    }
                    case FLOAT: {
                        type = BuiltinType.AFLOAT;
                        break block0;
                    }
                    case DOUBLE: {
                        type = BuiltinType.ADOUBLE;
                        break block0;
                    }
                    case ANY: {
                        type = BuiltinType.ANY;
                        break block0;
                    }
                }
                return BuiltinType.ANULL;
            }
            case ANY: {
                switch (tag2) {
                    case TINYINT: 
                    case SMALLINT: 
                    case INTEGER: 
                    case BIGINT: 
                    case FLOAT: 
                    case DOUBLE: 
                    case ANY: 
                    case DATE: 
                    case TIME: 
                    case DATETIME: 
                    case DURATION: 
                    case YEARMONTHDURATION: 
                    case DAYTIMEDURATION: {
                        type = BuiltinType.ANY;
                        break block0;
                    }
                }
                return BuiltinType.ANULL;
            }
            case DATE: {
                switch (tag2) {
                    case DATE: {
                        if (!this.isSameTemporalAllowed) {
                            return BuiltinType.ANULL;
                        }
                        type = BuiltinType.ADURATION;
                        break block0;
                    }
                    case DURATION: 
                    case YEARMONTHDURATION: 
                    case DAYTIMEDURATION: {
                        if (!this.isMixedTemporalAllowed) {
                            return BuiltinType.ANULL;
                        }
                        type = BuiltinType.ADATE;
                        break block0;
                    }
                    case ANY: {
                        type = BuiltinType.ANY;
                        break block0;
                    }
                }
                return BuiltinType.ANULL;
            }
            case TIME: {
                switch (tag2) {
                    case TIME: {
                        if (!this.isSameTemporalAllowed) {
                            return BuiltinType.ANULL;
                        }
                        type = BuiltinType.ADURATION;
                        break block0;
                    }
                    case YEARMONTHDURATION: {
                        return BuiltinType.ANULL;
                    }
                    case DURATION: 
                    case DAYTIMEDURATION: {
                        if (!this.isMixedTemporalAllowed) {
                            return BuiltinType.ANULL;
                        }
                        type = BuiltinType.ATIME;
                        break block0;
                    }
                    case ANY: {
                        type = BuiltinType.ANY;
                        break block0;
                    }
                }
                return BuiltinType.ANULL;
            }
            case DATETIME: {
                switch (tag2) {
                    case DATETIME: {
                        if (!this.isSameTemporalAllowed) {
                            return BuiltinType.ANULL;
                        }
                        type = BuiltinType.ADURATION;
                        break block0;
                    }
                    case DURATION: 
                    case YEARMONTHDURATION: 
                    case DAYTIMEDURATION: {
                        if (!this.isMixedTemporalAllowed) {
                            return BuiltinType.ANULL;
                        }
                        type = BuiltinType.ADATETIME;
                        break block0;
                    }
                    case ANY: {
                        type = BuiltinType.ANY;
                        break block0;
                    }
                }
                return BuiltinType.ANULL;
            }
            case DURATION: {
                switch (tag2) {
                    case DATE: {
                        if (!this.isMixedTemporalAllowed) {
                            return BuiltinType.ANULL;
                        }
                        type = BuiltinType.ADATE;
                        break block0;
                    }
                    case TIME: {
                        if (!this.isMixedTemporalAllowed) {
                            return BuiltinType.ANULL;
                        }
                        type = AUnionType.createNullableType(BuiltinType.ATIME);
                        break block0;
                    }
                    case DATETIME: {
                        if (!this.isMixedTemporalAllowed) {
                            return BuiltinType.ANULL;
                        }
                        type = BuiltinType.ADATETIME;
                        break block0;
                    }
                    case ANY: {
                        type = BuiltinType.ANY;
                        break block0;
                    }
                }
                return BuiltinType.ANULL;
            }
            case YEARMONTHDURATION: {
                switch (tag2) {
                    case DATE: {
                        if (!this.isMixedTemporalAllowed) {
                            return BuiltinType.ANULL;
                        }
                        type = BuiltinType.ADATE;
                        break block0;
                    }
                    case TIME: {
                        return BuiltinType.ANULL;
                    }
                    case DATETIME: {
                        if (!this.isMixedTemporalAllowed) {
                            return BuiltinType.ANULL;
                        }
                        type = BuiltinType.ADATETIME;
                        break block0;
                    }
                    case YEARMONTHDURATION: {
                        if (!this.isSameTemporalAllowed) {
                            return BuiltinType.ANULL;
                        }
                        type = BuiltinType.AYEARMONTHDURATION;
                        break block0;
                    }
                    case ANY: {
                        type = BuiltinType.ANY;
                        break block0;
                    }
                }
                return BuiltinType.ANULL;
            }
            case DAYTIMEDURATION: {
                switch (tag2) {
                    case DATE: {
                        if (!this.isMixedTemporalAllowed) {
                            return BuiltinType.ANULL;
                        }
                        type = BuiltinType.ADATE;
                        break block0;
                    }
                    case TIME: {
                        if (!this.isMixedTemporalAllowed) {
                            return BuiltinType.ANULL;
                        }
                        type = BuiltinType.ATIME;
                        break block0;
                    }
                    case DATETIME: {
                        if (!this.isMixedTemporalAllowed) {
                            return BuiltinType.ANULL;
                        }
                        type = BuiltinType.ADATETIME;
                        break block0;
                    }
                    case DAYTIMEDURATION: {
                        if (!this.isSameTemporalAllowed) {
                            return BuiltinType.ANULL;
                        }
                        type = BuiltinType.ADAYTIMEDURATION;
                        break block0;
                    }
                    case ANY: {
                        type = BuiltinType.ANY;
                        break block0;
                    }
                }
                return BuiltinType.ANULL;
            }
            default: {
                return BuiltinType.ANULL;
            }
        }
        if (this.nullable && type.getTypeTag() != ATypeTag.ANY) {
            type = AUnionType.createNullableType(type);
        }
        return type;
    }
}

