/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.values.writer;

import java.io.IOException;
import org.apache.asterix.column.util.RunLengthIntArray;
import org.apache.asterix.column.values.IColumnValuesReader;
import org.apache.asterix.column.values.writer.AbstractColumnValuesWriter;
import org.apache.asterix.column.values.writer.filters.AbstractColumnFilterWriter;
import org.apache.asterix.column.values.writer.filters.NoOpColumnFilterWriter;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.parquet.bytes.BytesInput;

public class NullMissingColumnValuesWriter
extends AbstractColumnValuesWriter {
    private static final BytesInput EMPTY = BytesInput.empty();
    private final RunLengthIntArray defLevelsIntArray = new RunLengthIntArray();

    NullMissingColumnValuesWriter(int columnIndex, int level, boolean collection, boolean filtered) {
        super(columnIndex, level, collection, filtered);
    }

    @Override
    protected void addLevel(int level) throws HyracksDataException {
        this.defLevelsIntArray.add(level);
        super.addLevel(level);
    }

    @Override
    public void writeLevels(int level, int count) throws HyracksDataException {
        this.defLevelsIntArray.add(level, count);
        super.writeLevels(level, count);
    }

    @Override
    protected ATypeTag getTypeTag() {
        return ATypeTag.NULL;
    }

    @Override
    protected void addValue(ATypeTag tag, IValueReference value) throws IOException {
        throw new IllegalStateException("Null writer should not add value");
    }

    @Override
    protected void addValue(IColumnValuesReader reader) throws IOException {
        throw new IllegalStateException("Null writer should not add value");
    }

    @Override
    protected BytesInput getBytes() throws IOException {
        return EMPTY;
    }

    @Override
    protected int getValuesEstimatedSize() {
        return 0;
    }

    @Override
    protected int calculateEstimatedSize(int length) {
        return 0;
    }

    @Override
    protected int getValuesAllocatedSize() {
        return 0;
    }

    @Override
    protected AbstractColumnFilterWriter createFilter() {
        return NoOpColumnFilterWriter.INSTANCE;
    }

    @Override
    protected void resetValues() throws HyracksDataException {
        this.defLevelsIntArray.reset();
    }

    @Override
    protected void closeValues() {
        this.defLevelsIntArray.reset();
    }

    @Override
    public RunLengthIntArray getDefinitionLevelsIntArray() {
        return this.defLevelsIntArray;
    }
}

