/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.values.reader;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.apache.asterix.column.values.IColumnKeyValueReader;
import org.apache.asterix.column.values.IColumnValuesWriter;
import org.apache.asterix.column.values.reader.AbstractColumnValuesReader;
import org.apache.asterix.column.values.reader.value.AbstractValueReader;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.storage.am.lsm.btree.column.error.ColumnarValueException;

public final class PrimitiveColumnValuesReader
extends AbstractColumnValuesReader
implements IColumnKeyValueReader {
    private final boolean primaryKey;

    public PrimitiveColumnValuesReader(AbstractValueReader reader, int columnIndex, int maxLevel, boolean primaryKey) {
        super(reader, columnIndex, maxLevel, primaryKey);
        this.primaryKey = primaryKey;
    }

    @Override
    public void resetValues() {
    }

    @Override
    public boolean next() throws HyracksDataException {
        if (this.valueIndex == this.valueCount) {
            return false;
        }
        this.nextLevel();
        if (this.primaryKey || this.level == this.maxLevel) {
            this.valueReader.nextValue();
        }
        return true;
    }

    @Override
    public boolean isRepeated() {
        return false;
    }

    @Override
    public boolean isDelimiter() {
        return false;
    }

    @Override
    public boolean isLastDelimiter() {
        return false;
    }

    @Override
    public boolean isRepeatedValue() {
        return false;
    }

    @Override
    public int getNumberOfDelimiters() {
        return 0;
    }

    @Override
    public int getDelimiterIndex() {
        throw new IllegalStateException("Not a repeated reader");
    }

    @Override
    public void write(IColumnValuesWriter writer, boolean callNext) throws HyracksDataException {
        if (callNext && !this.next()) {
            ColumnarValueException e = new ColumnarValueException();
            this.appendReaderInformation(e.createNode(this.getClass().getSimpleName()));
            throw e;
        }
        writer.writeLevel(this.level);
        if (this.primaryKey || this.isValue()) {
            try {
                writer.writeValue(this);
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
    }

    @Override
    public IValueReference getValue(int index) {
        return ((IColumnKeyValueReader)((Object)this.valueReader)).getValue(index);
    }

    @Override
    public int reset(int startIndex, int skipCount) throws HyracksDataException {
        ((IColumnKeyValueReader)((Object)this.valueReader)).reset(startIndex, skipCount);
        this.nextLevel();
        int numberOfAntiMatters = this.level < this.maxLevel ? 1 : 0;
        for (int i = 0; i < skipCount; ++i) {
            this.nextLevel();
            numberOfAntiMatters += this.level < this.maxLevel ? 1 : 0;
        }
        return numberOfAntiMatters;
    }

    @Override
    public void appendReaderInformation(ObjectNode node) {
        this.appendCommon(node);
        node.put("isPrimaryKeyColumn", this.primaryKey);
    }
}

