/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.util;

import it.unimi.dsi.fastutil.ints.IntList;
import java.io.DataInput;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.column.metadata.FieldNamesDictionary;
import org.apache.asterix.column.metadata.schema.AbstractSchemaNode;
import org.apache.asterix.column.metadata.schema.ISchemaNodeVisitor;
import org.apache.asterix.column.metadata.schema.ObjectSchemaNode;
import org.apache.asterix.column.metadata.schema.UnionSchemaNode;
import org.apache.asterix.column.metadata.schema.collection.AbstractCollectionSchemaNode;
import org.apache.asterix.column.metadata.schema.primitive.PrimitiveSchemaNode;
import org.apache.asterix.dataflow.data.nontagged.serde.AStringSerializerDeserializer;
import org.apache.asterix.om.base.AString;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ByteArrayAccessibleDataInputStream;
import org.apache.hyracks.data.std.util.ByteArrayAccessibleInputStream;
import org.apache.hyracks.util.string.UTF8StringReader;
import org.apache.hyracks.util.string.UTF8StringWriter;

public class SchemaStringBuilderVisitor
implements ISchemaNodeVisitor<Void, Void> {
    public static String RECORD_SCHEMA = "record";
    public static String META_RECORD_SCHEMA = "meta-record";
    private final StringBuilder builder = new StringBuilder();
    private final List<String> fieldNames = new ArrayList<String>();
    private int level;
    private int indent;

    public SchemaStringBuilderVisitor(FieldNamesDictionary dictionary) throws HyracksDataException {
        AStringSerializerDeserializer stringSerDer = new AStringSerializerDeserializer(new UTF8StringWriter(), new UTF8StringReader());
        List<IValueReference> extractedFieldNames = dictionary.getFieldNames();
        ByteArrayAccessibleInputStream in = new ByteArrayAccessibleInputStream(new byte[0], 0, 0);
        ByteArrayAccessibleDataInputStream dataIn = new ByteArrayAccessibleDataInputStream(in);
        for (IValueReference serFieldName : extractedFieldNames) {
            in.setContent(serFieldName.getByteArray(), 0, serFieldName.getLength());
            AString fieldName = stringSerDer.deserialize((DataInput)dataIn);
            this.fieldNames.add(fieldName.getStringValue());
        }
        this.level = 0;
        this.indent = 0;
    }

    public String build(ObjectSchemaNode root) throws HyracksDataException {
        this.builder.append("root\n");
        this.visit(root, null);
        return this.builder.toString();
    }

    @Override
    public Void visit(ObjectSchemaNode objectNode, Void arg) throws HyracksDataException {
        List<AbstractSchemaNode> children = objectNode.getChildren();
        IntList fieldNameIndexes = objectNode.getChildrenFieldNameIndexes();
        ++this.level;
        ++this.indent;
        for (int i = 0; i < children.size(); ++i) {
            int index = fieldNameIndexes.getInt(i);
            String fieldName = index < 0 ? "<empty>" : this.fieldNames.get(index);
            AbstractSchemaNode child = children.get(i);
            this.append(fieldName, index, child);
            child.accept(this, null);
        }
        --this.level;
        --this.indent;
        return null;
    }

    @Override
    public Void visit(AbstractCollectionSchemaNode collectionNode, Void arg) throws HyracksDataException {
        ++this.level;
        ++this.indent;
        AbstractSchemaNode itemNode = collectionNode.getItemNode();
        this.append("item", itemNode);
        itemNode.accept(this, null);
        --this.level;
        --this.indent;
        return null;
    }

    @Override
    public Void visit(UnionSchemaNode unionNode, Void arg) throws HyracksDataException {
        ++this.indent;
        for (AbstractSchemaNode child : unionNode.getChildren().values()) {
            this.append(child.getTypeTag().toString(), child);
            child.accept(this, null);
        }
        --this.indent;
        return null;
    }

    @Override
    public Void visit(PrimitiveSchemaNode primitiveNode, Void arg) throws HyracksDataException {
        return null;
    }

    private void appendDecor() {
        this.builder.append("|    ".repeat(Math.max(0, this.indent - 1)));
        this.builder.append("|-- ");
    }

    private void append(String key, AbstractSchemaNode node) {
        this.append(key, -1, node);
    }

    private void append(String key, int index, AbstractSchemaNode node) {
        this.appendDecor();
        this.builder.append(key);
        if (index >= 0) {
            this.builder.append(" (");
            this.builder.append(index);
            this.builder.append(')');
        }
        this.builder.append(": ");
        this.builder.append(node.getTypeTag().toString());
        this.builder.append(" <level: ");
        this.builder.append(this.level);
        if (!node.isNested()) {
            PrimitiveSchemaNode primitiveNode = (PrimitiveSchemaNode)node;
            this.builder.append(", index: ");
            this.builder.append(primitiveNode.getColumnIndex());
        }
        this.builder.append(">\n");
    }
}

