/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.tuple;

import java.nio.ByteBuffer;
import org.apache.asterix.column.bytes.stream.in.MultiByteBufferInputStream;
import org.apache.asterix.column.operation.lsm.merge.IEndOfPageCallBack;
import org.apache.asterix.column.operation.lsm.merge.MergeColumnReadMetadata;
import org.apache.asterix.column.tuple.AbstractAsterixColumnTupleReference;
import org.apache.asterix.column.values.IColumnValuesReader;
import org.apache.asterix.column.values.reader.PrimitiveColumnValuesReader;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnBufferProvider;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnReadMultiPageOp;
import org.apache.hyracks.storage.am.lsm.btree.column.api.projection.IColumnProjectionInfo;
import org.apache.hyracks.storage.am.lsm.btree.column.impls.btree.ColumnBTreeReadLeafFrame;

public final class MergeColumnTupleReference
extends AbstractAsterixColumnTupleReference {
    private static final IEndOfPageCallBack EMPTY_PAGE_CALLBACK = MergeColumnTupleReference.createNoOpCallBack();
    private final IColumnValuesReader[] columnReaders;
    private int skipCount;
    private IEndOfPageCallBack endOfPageCallBack;
    private int mergingLength;

    public MergeColumnTupleReference(int componentIndex, ColumnBTreeReadLeafFrame frame, MergeColumnReadMetadata columnMetadata, IColumnReadMultiPageOp multiPageOp) {
        super(componentIndex, frame, columnMetadata, multiPageOp);
        this.columnReaders = columnMetadata.getColumnReaders();
        this.endOfPageCallBack = EMPTY_PAGE_CALLBACK;
    }

    @Override
    protected PrimitiveColumnValuesReader[] getPrimaryKeyReaders(IColumnProjectionInfo info) {
        MergeColumnReadMetadata columnMetadata = (MergeColumnReadMetadata)info;
        int numberOfPrimaryKeys = columnMetadata.getNumberOfPrimaryKeys();
        PrimitiveColumnValuesReader[] primaryKeyReaders = new PrimitiveColumnValuesReader[numberOfPrimaryKeys];
        IColumnValuesReader[] readers = columnMetadata.getColumnReaders();
        for (int i = 0; i < numberOfPrimaryKeys; ++i) {
            primaryKeyReaders[i] = (PrimitiveColumnValuesReader)readers[i];
        }
        return primaryKeyReaders;
    }

    protected boolean startNewPage(ByteBuffer pageZero, int numberOfColumns, int numberOfTuples) {
        pageZero.position(pageZero.position() + numberOfColumns * 16);
        this.skipCount = 0;
        this.mergingLength = 0;
        return true;
    }

    protected void startColumn(IColumnBufferProvider buffersProvider, int ordinal, int numberOfTuples) throws HyracksDataException {
        int numberOfPrimaryKeys = this.primaryKeyStreams.length;
        if (ordinal < numberOfPrimaryKeys) {
            return;
        }
        MultiByteBufferInputStream columnStream = (MultiByteBufferInputStream)this.columnStreams[ordinal];
        columnStream.reset(buffersProvider);
        IColumnValuesReader reader = this.columnReaders[ordinal];
        reader.reset(columnStream, numberOfTuples);
        this.mergingLength += buffersProvider.getLength();
    }

    protected void startColumnFilter(IColumnBufferProvider buffersProvider, int ordinal, int numberOfTuples) throws HyracksDataException {
    }

    protected boolean evaluateFilter() throws HyracksDataException {
        return true;
    }

    public void skip(int count) throws HyracksDataException {
        this.skipCount += count;
    }

    @Override
    public void lastTupleReached() throws HyracksDataException {
        this.endOfPageCallBack.callEnd(this);
    }

    public int getAndResetSkipCount() {
        int currentSkipCount = this.skipCount;
        this.skipCount = 0;
        return currentSkipCount;
    }

    public IColumnValuesReader getReader(int columnIndex) {
        return this.columnReaders[columnIndex];
    }

    public void registerEndOfPageCallBack(IEndOfPageCallBack endOfPageCallBack) {
        this.endOfPageCallBack = endOfPageCallBack;
    }

    public int getMergingLength() {
        return this.mergingLength;
    }

    private static IEndOfPageCallBack createNoOpCallBack() {
        return columnTuple -> {
            if (!columnTuple.isEmpty()) {
                throw new NullPointerException("endOfPageCallBack is null");
            }
        };
    }
}

