/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.bytes.stream.in;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import org.apache.asterix.column.bytes.stream.in.AbstractBytesInputStream;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnBufferProvider;

public final class MultiByteBufferInputStream
extends AbstractBytesInputStream {
    private static final ByteBuffer EMPTY = ByteBuffer.allocate(0);
    private final Queue<ByteBuffer> buffers = new ArrayDeque<ByteBuffer>();
    private final ArrayBackedValueStorage tempPointableStorage = new ArrayBackedValueStorage();
    private int length;
    private ByteBuffer current;
    private int position;

    public MultiByteBufferInputStream() {
        this.current = EMPTY;
        this.position = 0;
        this.length = 0;
    }

    private MultiByteBufferInputStream(MultiByteBufferInputStream original, int len) throws EOFException {
        this.position = original.position;
        this.length = original.length;
        this.buffers.addAll(original.sliceBuffers(len));
        this.nextBuffer();
    }

    @Override
    public void reset(IColumnBufferProvider bufferProvider) throws HyracksDataException {
        this.reset();
        this.length = bufferProvider.getLength();
        if (this.length > 0) {
            bufferProvider.readAll(this.buffers);
            this.nextBuffer();
        }
    }

    @Override
    protected void addBuffer(ByteBuffer buffer) {
        this.buffers.add(buffer);
        this.length += buffer.remaining();
    }

    @Override
    public void resetAt(int bytesToSkip, AbstractBytesInputStream stream) throws IOException {
        MultiByteBufferInputStream original = (MultiByteBufferInputStream)stream;
        this.buffers.clear();
        this.position = original.position;
        this.length = original.length;
        this.current = original.current.duplicate();
        for (ByteBuffer buffer : original.buffers) {
            this.buffers.add(buffer.duplicate());
        }
        if (this.skip(bytesToSkip) != (long)bytesToSkip) {
            throw new EOFException();
        }
    }

    @Override
    public long skip(long n) {
        if (n <= 0L) {
            return 0L;
        }
        if (this.current == null) {
            return -1L;
        }
        long bytesSkipped = 0L;
        while (bytesSkipped < n) {
            if (this.current.remaining() > 0) {
                long bytesToSkip = Math.min(n - bytesSkipped, (long)this.current.remaining());
                this.current.position(this.current.position() + (int)bytesToSkip);
                bytesSkipped += bytesToSkip;
                this.position = (int)((long)this.position + bytesToSkip);
                continue;
            }
            if (this.nextBuffer()) continue;
            return bytesSkipped > 0L ? bytesSkipped : -1L;
        }
        return bytesSkipped;
    }

    @Override
    public int read(ByteBuffer out) {
        int len = out.remaining();
        if (len <= 0) {
            return 0;
        }
        if (this.current == null) {
            return -1;
        }
        int bytesCopied = 0;
        while (bytesCopied < len) {
            if (this.current.remaining() > 0) {
                ByteBuffer copyBuffer;
                int bytesToCopy;
                if (this.current.remaining() <= out.remaining()) {
                    bytesToCopy = this.current.remaining();
                    copyBuffer = this.current;
                } else {
                    bytesToCopy = out.remaining();
                    copyBuffer = this.current.duplicate();
                    copyBuffer.limit(copyBuffer.position() + bytesToCopy);
                    this.current.position(copyBuffer.position() + bytesToCopy);
                }
                out.put(copyBuffer);
                bytesCopied += bytesToCopy;
                this.position += bytesToCopy;
                continue;
            }
            if (this.nextBuffer()) continue;
            return bytesCopied > 0 ? bytesCopied : -1;
        }
        return bytesCopied;
    }

    @Override
    public AbstractBytesInputStream sliceStream(int length) throws EOFException {
        return new MultiByteBufferInputStream(this, length);
    }

    @Override
    public AbstractBytesInputStream remainingStream() throws EOFException {
        return new MultiByteBufferInputStream(this, this.length - this.position);
    }

    @Override
    public int read(byte[] bytes, int off, int len) {
        if (len <= 0) {
            if (len < 0) {
                throw new IndexOutOfBoundsException("Read length must be greater than 0: " + len);
            }
            return 0;
        }
        if (this.current == null) {
            return -1;
        }
        int bytesRead = 0;
        while (bytesRead < len) {
            if (this.current.remaining() > 0) {
                int bytesToRead = Math.min(len - bytesRead, this.current.remaining());
                this.current.get(bytes, off + bytesRead, bytesToRead);
                bytesRead += bytesToRead;
                this.position += bytesToRead;
                continue;
            }
            if (this.nextBuffer()) continue;
            return bytesRead > 0 ? bytesRead : -1;
        }
        return bytesRead;
    }

    @Override
    public int read(byte[] bytes) {
        return this.read(bytes, 0, bytes.length);
    }

    @Override
    public int read() throws IOException {
        if (this.current == null) {
            throw new EOFException();
        }
        do {
            if (this.current.remaining() <= 0) continue;
            ++this.position;
            return this.current.get() & 0xFF;
        } while (this.nextBuffer());
        throw new EOFException();
    }

    @Override
    public void read(IPointable pointable, int length) throws EOFException {
        if (this.current.remaining() >= length) {
            pointable.set(this.current.array(), this.current.position(), length);
            this.current.position(this.current.position() + length);
            this.position += length;
        } else {
            this.tempPointableStorage.setSize(length);
            int bytesRead = this.read(this.tempPointableStorage.getByteArray(), 0, length);
            if (bytesRead != length) {
                throw new EOFException();
            }
            pointable.set((IValueReference)this.tempPointableStorage);
        }
    }

    @Override
    public int available() {
        return this.length - this.position;
    }

    @Override
    public void mark(int readLimit) {
        throw new UnsupportedOperationException("reset() is not supported");
    }

    @Override
    public void reset() {
        this.buffers.clear();
        this.current = EMPTY;
        this.position = 0;
        this.length = 0;
    }

    private List<ByteBuffer> sliceBuffers(long length) throws EOFException {
        if (length <= 0L) {
            return Collections.emptyList();
        }
        if (this.current == null) {
            throw new EOFException();
        }
        ArrayList<ByteBuffer> sliceBuffers = new ArrayList<ByteBuffer>();
        long bytesAccumulated = 0L;
        while (bytesAccumulated < length) {
            if (this.current.remaining() > 0) {
                int bufLen = (int)Math.min(length - bytesAccumulated, (long)this.current.remaining());
                ByteBuffer slice = this.current.duplicate();
                slice.limit(slice.position() + bufLen);
                sliceBuffers.add(slice);
                bytesAccumulated += (long)bufLen;
                this.current.position(this.current.position() + bufLen);
                this.position += bufLen;
                continue;
            }
            if (this.nextBuffer()) continue;
            throw new EOFException();
        }
        return sliceBuffers;
    }

    private boolean nextBuffer() {
        if (this.buffers.isEmpty()) {
            return false;
        }
        this.current = this.buffers.poll();
        return true;
    }

    static {
        EMPTY.limit(0);
    }
}

