/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.bytes.encoder;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.asterix.column.bytes.ParquetDeltaBinaryPackingConfig;
import org.apache.asterix.column.bytes.encoder.AbstractParquetValuesWriter;
import org.apache.asterix.column.bytes.stream.out.MultiTemporaryBufferBytesOutputStream;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnWriteMultiPageOp;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.io.ParquetEncodingException;

public abstract class AbstractParquetDeltaBinaryPackingValuesWriter
extends AbstractParquetValuesWriter {
    public static final int DEFAULT_NUM_BLOCK_VALUES = 128;
    public static final int DEFAULT_NUM_MINIBLOCKS = 4;
    protected final MultiTemporaryBufferBytesOutputStream outputStream;
    protected final ParquetDeltaBinaryPackingConfig config;
    protected final int[] bitWidths;
    protected int totalValueCount = 0;
    protected int deltaValuesToFlush = 0;
    protected byte[] miniBlockByteBuffer;
    protected int estimatedElementSize = 0;
    protected int estimatedSize = 0;

    protected AbstractParquetDeltaBinaryPackingValuesWriter(int blockSizeInValues, int miniBlockNum, Mutable<IColumnWriteMultiPageOp> multiPageOpRef) {
        this.config = new ParquetDeltaBinaryPackingConfig(blockSizeInValues, miniBlockNum);
        this.bitWidths = new int[this.config.getMiniBlockNumInABlock()];
        this.outputStream = new MultiTemporaryBufferBytesOutputStream(multiPageOpRef);
    }

    protected void writeBitWidthForMiniBlock(int i) {
        try {
            BytesUtils.writeIntLittleEndianOnOneByte((OutputStream)this.outputStream, (int)this.bitWidths[i]);
        }
        catch (IOException e) {
            throw new ParquetEncodingException("can not write bit width for mini-block", (Throwable)e);
        }
    }

    protected int getMiniBlockCountToFlush(double numberCount) {
        return (int)Math.ceil(numberCount / (double)this.config.getMiniBlockSizeInValues());
    }

    @Override
    public void reset() throws HyracksDataException {
        this.totalValueCount = 0;
        this.outputStream.reset();
        this.deltaValuesToFlush = 0;
    }

    @Override
    public void close() {
        this.totalValueCount = 0;
        this.deltaValuesToFlush = 0;
        this.outputStream.finish();
    }

    @Override
    public int getEstimatedSize() {
        return this.outputStream.size() + this.estimatedSize;
    }

    @Override
    public int getAllocatedSize() {
        return this.outputStream.capacity();
    }
}

