/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tpcds.row.generator;

import com.teradata.tpcds.BusinessKeyGenerator;
import com.teradata.tpcds.Nulls;
import com.teradata.tpcds.Session;
import com.teradata.tpcds.Table;
import com.teradata.tpcds.generator.WarehouseGeneratorColumn;
import com.teradata.tpcds.random.RandomValueGenerator;
import com.teradata.tpcds.row.WarehouseRow;
import com.teradata.tpcds.row.generator.AbstractRowGenerator;
import com.teradata.tpcds.row.generator.RowGenerator;
import com.teradata.tpcds.row.generator.RowGeneratorResult;
import com.teradata.tpcds.type.Address;

public class WarehouseRowGenerator
extends AbstractRowGenerator {
    public WarehouseRowGenerator() {
        super(Table.WAREHOUSE);
    }

    @Override
    public RowGeneratorResult generateRowAndChildRows(long rowNumber, Session session, RowGenerator parentRowGenerator, RowGenerator childRowGenerator) {
        long nullBitMap = Nulls.createNullBitMap(Table.WAREHOUSE, this.getRandomNumberStream(WarehouseGeneratorColumn.W_NULLS));
        long wWarehouseSk = rowNumber;
        String wWarehouseId = BusinessKeyGenerator.makeBusinessKey(rowNumber);
        String wWarehouseName = RandomValueGenerator.generateRandomText(10, 20, this.getRandomNumberStream(WarehouseGeneratorColumn.W_WAREHOUSE_NAME));
        int wWarehouseSqFt = RandomValueGenerator.generateUniformRandomInt(50000, 1000000, this.getRandomNumberStream(WarehouseGeneratorColumn.W_WAREHOUSE_SQ_FT));
        Address wAddress = Address.makeAddressForColumn(Table.WAREHOUSE, this.getRandomNumberStream(WarehouseGeneratorColumn.W_WAREHOUSE_ADDRESS), session.getScaling());
        return new RowGeneratorResult(new WarehouseRow(nullBitMap, wWarehouseSk, wWarehouseId, wWarehouseName, wWarehouseSqFt, wAddress));
    }
}

