/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.parser;

import java.util.Set;
import java.util.Stack;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.lang.common.context.RootScopeFactory;
import org.apache.asterix.lang.common.context.Scope;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.Counter;

public class ScopeChecker {
    protected static String quot = "\"";
    protected String eol = System.getProperty("line.separator", "\n");
    protected Counter varCounter = new Counter(-1);
    protected Stack<Scope> scopeStack = new Stack();
    protected Stack<Scope> forbiddenScopeStack = new Stack();
    protected String[] inputLines;

    public ScopeChecker() {
        this.scopeStack.push(RootScopeFactory.createRootScope(this));
    }

    protected void setInput(String s) {
        this.inputLines = s.split("\n|\r\n?");
    }

    public final Scope createNewScope() {
        Scope scope = this.extendCurrentScopeNoPush(false);
        this.scopeStack.push(scope);
        return scope;
    }

    public final Scope extendCurrentScope() {
        Scope scope = this.extendCurrentScopeNoPush(false);
        this.replaceCurrentScope(scope);
        return scope;
    }

    protected final Scope extendCurrentScopeNoPush(boolean maskParentScope) {
        Scope parent = this.scopeStack.peek();
        return new Scope(this, parent, maskParentScope);
    }

    public final void replaceCurrentScope(Scope scope) {
        this.scopeStack.pop();
        this.scopeStack.push(scope);
    }

    public final void pushExistingScope(Scope scope) {
        this.scopeStack.push(scope);
    }

    public final Scope removeCurrentScope() {
        return this.scopeStack.pop();
    }

    public final Scope getCurrentScope() {
        return this.scopeStack.peek();
    }

    public final Scope getPrecedingScope() {
        int n = this.scopeStack.size();
        return n > 1 ? (Scope)this.scopeStack.get(n - 2) : null;
    }

    public final Identifier lookupSymbol(String name) {
        Pair<Identifier, Set<? extends Scope.SymbolAnnotation>> symbol;
        if (name != null && (symbol = this.getCurrentScope().findSymbol(name)) != null) {
            return (Identifier)symbol.first;
        }
        return null;
    }

    public final FunctionSignature lookupFunctionSignature(String databaseName, DataverseName dataverseName, String name, int arity) {
        if (dataverseName != null) {
            return this.getCurrentScope().findFunctionSignature(databaseName, dataverseName, name, arity);
        }
        return null;
    }

    public final int getVarCounter() {
        return this.varCounter.get();
    }

    public final void setVarCounter(Counter varCounter) {
        this.varCounter = varCounter;
    }

    public final void incVarCounter() {
        this.varCounter.inc();
    }

    public final void pushForbiddenScope(Scope s) {
        this.forbiddenScopeStack.push(s);
    }

    public final void popForbiddenScope() {
        this.forbiddenScopeStack.pop();
    }

    public final boolean isInForbiddenScopes(String ident) {
        for (Scope s : this.forbiddenScopeStack) {
            if (s.findLocalSymbol(ident) == null) continue;
            return true;
        }
        return false;
    }

    protected int appendExpected(StringBuilder expected, int[][] expectedTokenSequences, String[] tokenImage) {
        int maxSize = 0;
        for (int i = 0; i < expectedTokenSequences.length; ++i) {
            if (maxSize < expectedTokenSequences[i].length) {
                maxSize = expectedTokenSequences[i].length;
            }
            for (int j = 0; j < expectedTokenSequences[i].length; ++j) {
                this.append(expected, ScopeChecker.fixQuotes(tokenImage[expectedTokenSequences[i][j]]));
                this.append(expected, " ");
            }
            if (expectedTokenSequences[i][expectedTokenSequences[i].length - 1] != 0) {
                this.append(expected, "...");
            }
            this.append(expected, this.eol);
            this.append(expected, "    ");
        }
        return maxSize;
    }

    private void append(StringBuilder expected, String str) {
        if (expected != null) {
            expected.append(str);
        }
    }

    protected static String fixQuotes(String token) {
        String stripped = ScopeChecker.stripQuotes(token);
        return stripped != null ? "'" + stripped + "'" : token;
    }

    protected static String stripQuotes(String token) {
        int last = token.length() - 1;
        return token.charAt(0) == '\"' && token.charAt(last) == '\"' ? token.substring(1, last) : null;
    }

    protected static String addEscapes(String str) {
        StringBuilder escaped = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            ScopeChecker.appendChar(escaped, str.charAt(i));
        }
        return escaped.toString();
    }

    private static void appendChar(StringBuilder escaped, char c) {
        switch (c) {
            case '\u0000': {
                return;
            }
            case '\b': {
                escaped.append("\\b");
                return;
            }
            case '\t': {
                escaped.append("\\t");
                return;
            }
            case '\n': {
                escaped.append("\\n");
                return;
            }
            case '\f': {
                escaped.append("\\f");
                return;
            }
            case '\r': {
                escaped.append("\\r");
                return;
            }
            case '\"': {
                escaped.append("\\\"");
                return;
            }
            case '\'': {
                escaped.append("\\'");
                return;
            }
            case '\\': {
                escaped.append("\\\\");
                return;
            }
        }
        char ch = c;
        if (ch < ' ' || ch > '~') {
            String s = "0000" + Integer.toString(ch, 16);
            escaped.append("\\u").append(s.substring(s.length() - 4, s.length()));
        } else {
            escaped.append(ch);
        }
    }

    public static String removeQuotesAndEscapes(String s) {
        if (s.length() < 2) {
            throw new IllegalStateException("Should have been caught by the lexer");
        }
        StringBuilder res = new StringBuilder();
        char[] cray = s.toCharArray();
        int pos = 1;
        block8: while (pos < cray.length - 1) {
            char c = cray[pos];
            ++pos;
            if (c == '\\') {
                c = cray[pos];
                ++pos;
                switch (c) {
                    case 'b': {
                        res.append('\b');
                        continue block8;
                    }
                    case 'f': {
                        res.append('\f');
                        continue block8;
                    }
                    case 'n': {
                        res.append('\n');
                        continue block8;
                    }
                    case 'r': {
                        res.append('\r');
                        continue block8;
                    }
                    case 't': {
                        res.append('\t');
                        continue block8;
                    }
                    case '\"': 
                    case '\'': 
                    case '/': 
                    case '\\': 
                    case '`': {
                        res.append(c);
                        continue block8;
                    }
                }
                throw new IllegalStateException("'\\" + c + "' should have been caught by the lexer");
            }
            res.append(c);
            if (cray[0] == '\'' && c == '\'') {
                if (pos >= cray.length - 1 || cray[pos] != '\'') {
                    throw new IllegalStateException("'" + c + "' should have been caught by the lexer");
                }
                ++pos;
                continue;
            }
            if (cray[0] == '`' && c == '`') {
                if (pos >= cray.length - 1 || cray[pos] != '`') {
                    throw new IllegalStateException("`" + c + "' should have been caught by the lexer");
                }
                ++pos;
                continue;
            }
            if (cray[0] != c) continue;
            throw new IllegalStateException("should have been caught by lexer");
        }
        return res.toString();
    }

    protected String getLine(int line) {
        int idx = line - 1;
        return idx >= 0 && idx < this.inputLines.length ? this.inputLines[idx] : "";
    }

    protected String extractFragment(int beginLine, int beginColumn, int endLine, int endColumn) {
        StringBuilder extract = new StringBuilder();
        if (beginLine == endLine) {
            return this.inputLines[beginLine - 1].substring(beginColumn, endColumn - 1).trim();
        }
        extract.append(this.inputLines[beginLine - 1].substring(beginColumn));
        for (int i = beginLine + 1; i < endLine; ++i) {
            extract.append("\n");
            extract.append(this.inputLines[i - 1]);
        }
        extract.append("\n");
        extract.append(this.inputLines[endLine - 1].substring(0, endColumn - 1));
        return extract.toString().trim();
    }
}

