/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.impls;

import java.util.List;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.PermutingTupleReference;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilter;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMIndexSearchCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndexAccessor;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexDiskComponent;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexMemoryComponent;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexOpContext;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexRangeSearchCursorInitialState;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.IIndexAccessor;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.storage.common.NoOpIndexCursorStats;

public class LSMInvertedIndexRangeSearchCursor
extends LSMIndexSearchCursor {
    private IIndexCursor[] deletedKeysBTreeCursors;
    protected BloomFilter[] bloomFilters;
    protected final long[] hashes = BloomFilter.createHashArray();
    protected IIndexAccessor[] deletedKeysBTreeAccessors;
    protected PermutingTupleReference keysOnlyTuple;
    protected RangePredicate keySearchPred;

    public LSMInvertedIndexRangeSearchCursor(ILSMIndexOperationContext opCtx) {
        super(opCtx, false, NoOpIndexCursorStats.INSTANCE);
    }

    public void doOpen(ICursorInitialState initState, ISearchPredicate searchPred) throws HyracksDataException {
        ILSMComponent component;
        int i;
        LSMInvertedIndexOpContext ctx = (LSMInvertedIndexOpContext)this.opCtx;
        LSMInvertedIndexRangeSearchCursorInitialState lsmInitState = (LSMInvertedIndexRangeSearchCursorInitialState)initState;
        List<ILSMComponent> components = lsmInitState.getOperationalComponents();
        this.cmp = lsmInitState.getOriginalKeyComparator();
        int numComponents = lsmInitState.getNumComponents();
        this.rangeCursors = new IIndexCursor[numComponents];
        for (i = 0; i < numComponents; ++i) {
            component = components.get(i);
            IInvertedIndexAccessor invIndexAccessor = (IInvertedIndexAccessor)component.getIndex().createAccessor(ctx.getIndexAccessParameters());
            this.rangeCursors[i] = invIndexAccessor.createRangeSearchCursor();
            invIndexAccessor.rangeSearch(this.rangeCursors[i], lsmInitState.getSearchPredicate());
        }
        this.lsmHarness = lsmInitState.getLSMHarness();
        this.operationalComponents = lsmInitState.getOperationalComponents();
        this.includeMutableComponent = lsmInitState.getIncludeMemComponent();
        this.keysOnlyTuple = lsmInitState.getKeysOnlyTuple();
        this.bloomFilters = new BloomFilter[numComponents];
        if (numComponents > 0) {
            this.deletedKeysBTreeAccessors = new IIndexAccessor[numComponents];
            this.deletedKeysBTreeCursors = new IIndexCursor[numComponents];
            for (i = 0; i < this.operationalComponents.size(); ++i) {
                component = (ILSMComponent)this.operationalComponents.get(i);
                if (component.getType() == ILSMComponent.LSMComponentType.MEMORY) {
                    this.bloomFilters[i] = null;
                    this.deletedKeysBTreeAccessors[i] = ((LSMInvertedIndexMemoryComponent)component).getBuddyIndex().createAccessor(this.iap);
                } else {
                    this.bloomFilters[i] = ((LSMInvertedIndexDiskComponent)component).getBloomFilter();
                    this.deletedKeysBTreeAccessors[i] = ((LSMInvertedIndexDiskComponent)component).getBuddyIndex().createAccessor(this.iap);
                }
                this.deletedKeysBTreeCursors[i] = this.deletedKeysBTreeAccessors[i].createSearchCursor(false);
            }
        }
        MultiComparator keyCmp = lsmInitState.getKeyComparator();
        this.keySearchPred = new RangePredicate((ITupleReference)this.keysOnlyTuple, (ITupleReference)this.keysOnlyTuple, true, true, keyCmp, keyCmp);
        this.setPriorityQueueComparator();
        this.initPriorityQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isDeleted(LSMIndexSearchCursor.PriorityQueueElement checkElement) throws HyracksDataException {
        this.keysOnlyTuple.reset(checkElement.getTuple());
        int end = checkElement.getCursorIndex();
        for (int i = 0; i < end; ++i) {
            if (this.bloomFilters[i] != null && !this.bloomFilters[i].contains((ITupleReference)this.keysOnlyTuple, this.hashes)) continue;
            this.deletedKeysBTreeAccessors[i].search(this.deletedKeysBTreeCursors[i], (ISearchPredicate)this.keySearchPred);
            try {
                if (!this.deletedKeysBTreeCursors[i].hasNext()) continue;
                boolean bl = true;
                return bl;
            }
            finally {
                this.deletedKeysBTreeCursors[i].close();
            }
        }
        return false;
    }

    public void doClose() throws HyracksDataException {
        try {
            super.doClose();
        }
        finally {
            if (this.deletedKeysBTreeCursors != null) {
                for (int i = 0; i < this.deletedKeysBTreeCursors.length; ++i) {
                    this.deletedKeysBTreeCursors[i].close();
                }
            }
        }
    }

    public void doDestroy() throws HyracksDataException {
        try {
            super.doDestroy();
        }
        finally {
            if (this.deletedKeysBTreeCursors != null) {
                for (int i = 0; i < this.deletedKeysBTreeCursors.length; ++i) {
                    this.deletedKeysBTreeCursors[i].destroy();
                }
                this.deletedKeysBTreeCursors = null;
            }
        }
    }
}

