/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.exceptions;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.exceptions.SourceLocation;

public interface IFormattedException {
    public String getComponent();

    public int getErrorCode();

    public String getMessage();

    public Throwable[] getSuppressed();

    public Optional<IError> getError();

    public SourceLocation getSourceLocation();

    public Serializable[] getParams();

    default public boolean matches(IError candidate) {
        Objects.requireNonNull(candidate, "candidate");
        return this.getComponent().equals(candidate.component()) && this.getErrorCode() == candidate.intValue();
    }

    default public boolean matchesAny(IError candidate, IError ... otherCandidates) {
        return this.matches(candidate) || Stream.of(otherCandidates).anyMatch(this::matches);
    }

    public static boolean matches(Throwable th, IError candidate) {
        return th instanceof IFormattedException && ((IFormattedException)((Object)th)).matches(candidate);
    }

    public static boolean matchesAny(Throwable th, IError candidate, IError ... otherCandidates) {
        return th instanceof IFormattedException && ((IFormattedException)((Object)th)).matchesAny(candidate, otherCandidates);
    }

    public static Optional<IError> getError(Throwable throwable) {
        return throwable instanceof IFormattedException ? ((IFormattedException)((Object)throwable)).getError() : Optional.empty();
    }
}

