/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.ipc.sockets;

import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLEngine;
import org.apache.hyracks.api.network.INetworkSecurityManager;
import org.apache.hyracks.api.network.ISocketChannel;
import org.apache.hyracks.api.network.ISocketChannelFactory;
import org.apache.hyracks.ipc.sockets.SslSocketChannel;

public class SslSocketChannelFactory
implements ISocketChannelFactory {
    private final INetworkSecurityManager networkSecurityManager;

    public SslSocketChannelFactory(INetworkSecurityManager networkSecurityManager) {
        this.networkSecurityManager = networkSecurityManager;
    }

    public ISocketChannel createServerChannel(SocketChannel socketChannel) {
        SSLEngine sslEngine = this.networkSecurityManager.newSSLEngine();
        sslEngine.setUseClientMode(false);
        return new SslSocketChannel(socketChannel, sslEngine);
    }

    public ISocketChannel createClientChannel(SocketChannel socketChannel) {
        SSLEngine sslEngine = this.networkSecurityManager.newSSLEngine();
        sslEngine.setUseClientMode(true);
        return new SslSocketChannel(socketChannel, sslEngine);
    }
}

