/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableString;
import org.apache.asterix.om.exceptions.ExceptionUtil;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public abstract class AbstractQuadStringStringEval
implements IScalarEvaluator {
    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private DataOutput dout = this.resultStorage.getDataOutput();
    private IPointable ptr0 = new VoidPointable();
    private IPointable ptr1 = new VoidPointable();
    private IPointable ptr2 = new VoidPointable();
    private IPointable ptr3 = new VoidPointable();
    private IScalarEvaluator eval0;
    private IScalarEvaluator eval1;
    private IScalarEvaluator eval2;
    private IScalarEvaluator eval3;
    protected final FunctionIdentifier funcID;
    protected final SourceLocation sourceLoc;
    private AMutableString resultBuffer = new AMutableString("");
    private ISerializerDeserializer strSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING);
    private final IEvaluatorContext ctx;
    private final UTF8StringPointable strPtr0 = new UTF8StringPointable();
    private final UTF8StringPointable strPtr1 = new UTF8StringPointable();
    private final UTF8StringPointable strPtr2 = new UTF8StringPointable();
    private final UTF8StringPointable strPtr3 = new UTF8StringPointable();

    public AbstractQuadStringStringEval(IEvaluatorContext context, IScalarEvaluatorFactory eval0, IScalarEvaluatorFactory eval1, IScalarEvaluatorFactory eval2, IScalarEvaluatorFactory eval3, FunctionIdentifier funcID, SourceLocation sourceLoc) throws HyracksDataException {
        this.ctx = context;
        this.eval0 = eval0.createScalarEvaluator(context);
        this.eval1 = eval1.createScalarEvaluator(context);
        this.eval2 = eval2.createScalarEvaluator(context);
        this.eval3 = eval3.createScalarEvaluator(context);
        this.funcID = funcID;
        this.sourceLoc = sourceLoc;
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.eval0.evaluate(tuple, this.ptr0);
        this.eval1.evaluate(tuple, this.ptr1);
        this.eval2.evaluate(tuple, this.ptr2);
        this.eval3.evaluate(tuple, this.ptr3);
        if (PointableHelper.checkAndSetMissingOrNull(result, this.ptr0, this.ptr1, this.ptr2, this.ptr3)) {
            return;
        }
        if (!(this.processArgument(0, this.ptr0, this.strPtr0) && this.processArgument(1, this.ptr1, this.strPtr1) && this.processArgument(2, this.ptr2, this.strPtr2) && this.processArgument(3, this.ptr3, this.strPtr3))) {
            PointableHelper.setNull(result);
            return;
        }
        this.resultStorage.reset();
        try {
            String res = this.compute(this.strPtr0, this.strPtr1, this.strPtr2, this.strPtr3);
            this.resultBuffer.setValue(res);
            this.strSerde.serialize((Object)this.resultBuffer, this.dout);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        result.set((IValueReference)this.resultStorage);
    }

    protected boolean processArgument(int argIdx, IPointable argPtr, UTF8StringPointable outStrPtr) throws HyracksDataException {
        int start;
        byte[] bytes = argPtr.getByteArray();
        if (bytes[start = argPtr.getStartOffset()] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
            ExceptionUtil.warnTypeMismatch((IEvaluatorContext)this.ctx, (SourceLocation)this.sourceLoc, (FunctionIdentifier)this.funcID, (byte)bytes[start], (int)argIdx, (ATypeTag)ATypeTag.STRING);
            return false;
        }
        int len = argPtr.getLength();
        outStrPtr.set(bytes, start + 1, len);
        return true;
    }

    protected abstract String compute(UTF8StringPointable var1, UTF8StringPointable var2, UTF8StringPointable var3, UTF8StringPointable var4) throws IOException;
}

