/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.rtree.tuples;

import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.am.common.util.BitOperationUtils;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMTreeTupleReference;
import org.apache.hyracks.storage.am.rtree.tuples.RTreeTypeAwareTupleReference;

public class LSMRTreeTupleReferenceForPointMBR
extends RTreeTypeAwareTupleReference
implements ILSMTreeTupleReference {
    private final int inputKeyFieldCount;
    private final int inputTotalFieldCount;
    private final int storedKeyFieldCount;
    private final boolean antimatterAware;

    public LSMRTreeTupleReferenceForPointMBR(ITypeTraits[] typeTraits, int keyFieldCount, int valueFieldCount, boolean antimatterAware, ITypeTraits nullTypeTraits) {
        super(typeTraits, nullTypeTraits);
        this.inputKeyFieldCount = keyFieldCount;
        this.inputTotalFieldCount = keyFieldCount + valueFieldCount;
        this.storedKeyFieldCount = keyFieldCount / 2;
        this.nullFlagsBytes = this.getNullFlagsBytes();
        this.decodedFieldSlots = new int[this.inputTotalFieldCount];
        this.antimatterAware = antimatterAware;
    }

    public void resetByTupleOffset(byte[] buf, int tupleStartOff) {
        this.buf = buf;
        this.tupleStartOff = tupleStartOff;
        int field = 0;
        int cumul = 0;
        int nullFlagsRunner = 0;
        this.encDec.reset(buf, tupleStartOff + this.nullFlagsBytes);
        int i = 0;
        while (i < this.storedKeyFieldCount) {
            cumul = !this.typeTraits[i].isFixedLength() ? (cumul += this.encDec.decode()) : (this.nullTypeTraits != null && this.isNull(buf, tupleStartOff, nullFlagsRunner) ? (cumul += this.nullTypeTraits.getFixedLength()) : (cumul += this.typeTraits[i].getFixedLength()));
            this.decodedFieldSlots[field++] = cumul;
            ++i;
            ++nullFlagsRunner;
        }
        for (i = 0; i < this.storedKeyFieldCount; ++i) {
            this.decodedFieldSlots[field++] = this.decodedFieldSlots[i];
        }
        i = this.inputKeyFieldCount;
        while (i < this.inputTotalFieldCount) {
            cumul = !this.typeTraits[i].isFixedLength() ? (cumul += this.encDec.decode()) : (this.nullTypeTraits != null && this.isNull(buf, tupleStartOff, nullFlagsRunner) ? (cumul += this.nullTypeTraits.getFixedLength()) : (cumul += this.typeTraits[i].getFixedLength()));
            this.decodedFieldSlots[field++] = cumul;
            ++i;
            ++nullFlagsRunner;
        }
        this.dataStartOff = this.encDec.getPos();
    }

    public void resetByTupleIndex(ITreeIndexFrame frame, int tupleIndex) {
        this.resetByTupleOffset(frame.getBuffer().array(), frame.getTupleOffset(tupleIndex));
    }

    public void setFieldCount(int fieldCount) {
    }

    public void setFieldCount(int fieldStartIndex, int fieldCount) {
    }

    public int getFieldCount() {
        return this.inputTotalFieldCount;
    }

    public int getFieldLength(int fIdx) {
        int internalFieldIdx = this.getInternalFieldIdx(fIdx);
        if (internalFieldIdx == 0) {
            return this.decodedFieldSlots[0];
        }
        return this.decodedFieldSlots[internalFieldIdx] - this.decodedFieldSlots[internalFieldIdx - 1];
    }

    public int getFieldStart(int fIdx) {
        int internalFieldIdx = this.getInternalFieldIdx(fIdx);
        if (internalFieldIdx == 0) {
            return this.dataStartOff;
        }
        return this.dataStartOff + this.decodedFieldSlots[internalFieldIdx - 1];
    }

    private int getInternalFieldIdx(int fIdx) {
        if (fIdx >= this.storedKeyFieldCount && fIdx < this.inputKeyFieldCount) {
            return fIdx % this.storedKeyFieldCount;
        }
        return fIdx;
    }

    protected int getNullFlagsBytes() {
        return BitOperationUtils.getFlagBytes((int)(this.storedKeyFieldCount + this.inputTotalFieldCount - this.inputKeyFieldCount + (this.antimatterAware ? 1 : 0)));
    }

    public int getTupleSize() {
        return this.dataStartOff - this.tupleStartOff + this.decodedFieldSlots[this.inputTotalFieldCount - 1];
    }

    public boolean isAntimatter() {
        return BitOperationUtils.getBit((byte[])this.buf, (int)this.tupleStartOff, (byte)7);
    }

    protected int getAdjustedFieldIdx(int fieldIdx) {
        return this.antimatterAware ? fieldIdx + 1 : fieldIdx;
    }
}

