/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites.visitor;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.lang.common.base.AbstractClause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.base.Literal;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.expression.FieldBinding;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.RecordConstructor;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.Projection;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.clause.SelectElement;
import org.apache.asterix.lang.sqlpp.clause.SelectRegular;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.util.SqlppVariableUtil;
import org.apache.asterix.lang.sqlpp.visitor.SqlppSubstituteExpressionVisitor;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppExpressionScopingVisitor;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class InlineColumnAliasVisitor
extends AbstractSqlppExpressionScopingVisitor {
    public InlineColumnAliasVisitor(LangRewritingContext context) {
        super(context);
    }

    @Override
    public Expression visit(SelectBlock selectBlock, ILangExpression arg) throws CompilationException {
        SelectExpression selectExpression;
        Map<Expression, ColumnAliasBinding> map = this.getMap(selectBlock.getSelectClause());
        if (selectBlock.hasGroupbyClause()) {
            map.keySet().removeAll(SqlppVariableUtil.getBindingVariables(selectBlock.getGroupbyClause()));
            if (selectBlock.hasLetHavingClausesAfterGroupby()) {
                map.keySet().removeAll(SqlppVariableUtil.getLetBindingVariables(selectBlock.getLetHavingListAfterGroupby()));
            }
        } else {
            if (selectBlock.hasFromClause()) {
                map.keySet().removeAll(SqlppVariableUtil.getBindingVariables(selectBlock.getFromClause()));
            }
            if (selectBlock.hasLetWhereClauses()) {
                map.keySet().removeAll(SqlppVariableUtil.getLetBindingVariables(selectBlock.getLetWhereList()));
            }
        }
        if (!(selectExpression = (SelectExpression)arg).getSelectSetOperation().hasRightInputs()) {
            SubstituteColumnAliasVisitor visitor = new SubstituteColumnAliasVisitor(this.context, InlineColumnAliasVisitor.toExpressionMap(map));
            if (selectExpression.hasOrderby()) {
                selectExpression.getOrderbyClause().accept((ILangVisitor)visitor, (Object)arg);
            }
            if (selectExpression.hasLimit()) {
                selectExpression.getLimitClause().accept((ILangVisitor)visitor, (Object)arg);
            }
            if (!visitor.letVarMap.isEmpty()) {
                this.introduceLetClauses(visitor.letVarMap, map, selectBlock);
            }
        }
        return super.visit(selectBlock, arg);
    }

    private Map<Expression, ColumnAliasBinding> getMap(SelectClause selectClause) {
        if (selectClause.selectElement()) {
            return this.getMap(selectClause.getSelectElement());
        }
        if (selectClause.selectRegular()) {
            return this.getMap(selectClause.getSelectRegular());
        }
        return Collections.emptyMap();
    }

    private Map<Expression, ColumnAliasBinding> getMap(SelectElement selectElement) {
        Expression expr = selectElement.getExpression();
        if (expr.getKind() == Expression.Kind.RECORD_CONSTRUCTOR_EXPRESSION) {
            return this.mapRecordConstructor((RecordConstructor)expr);
        }
        return Collections.emptyMap();
    }

    private Map<Expression, ColumnAliasBinding> getMap(SelectRegular selectRegular) {
        return this.mapProjections(selectRegular.getProjections());
    }

    private Map<Expression, ColumnAliasBinding> mapRecordConstructor(RecordConstructor rc) {
        HashMap<Expression, ColumnAliasBinding> exprMap = new HashMap<Expression, ColumnAliasBinding>();
        for (FieldBinding binding : rc.getFbList()) {
            LiteralExpr literalExpr;
            Expression leftExpr = binding.getLeftExpr();
            if (leftExpr.getKind() != Expression.Kind.LITERAL_EXPRESSION || (literalExpr = (LiteralExpr)leftExpr).getValue().getLiteralType() != Literal.Type.STRING) continue;
            String fieldName = SqlppVariableUtil.toInternalVariableName(literalExpr.getValue().getStringValue());
            exprMap.put((Expression)new VariableExpr(new VarIdentifier(fieldName)), ColumnAliasBinding.of(binding));
        }
        return exprMap;
    }

    private Map<Expression, ColumnAliasBinding> mapProjections(List<Projection> projections) {
        HashMap<Expression, ColumnAliasBinding> exprMap = new HashMap<Expression, ColumnAliasBinding>();
        for (Projection projection : projections) {
            if (projection.getKind() != Projection.Kind.NAMED_EXPR) continue;
            String varName = SqlppVariableUtil.toInternalVariableName(projection.getName());
            exprMap.put((Expression)new VariableExpr(new VarIdentifier(varName)), ColumnAliasBinding.of(projection));
        }
        return exprMap;
    }

    private void introduceLetClauses(Map<Expression, VarIdentifier> letVarMap, Map<Expression, ColumnAliasBinding> aliasBindingMap, SelectBlock selectBlock) throws CompilationException {
        List<AbstractClause> targetLetClauses = selectBlock.hasGroupbyClause() ? selectBlock.getLetHavingListAfterGroupby() : selectBlock.getLetWhereList();
        for (Map.Entry<Expression, VarIdentifier> me : letVarMap.entrySet()) {
            Expression columnAliasVarExpr = me.getKey();
            SourceLocation sourceLoc = columnAliasVarExpr.getSourceLocation();
            ColumnAliasBinding columnAliasBinding = aliasBindingMap.get(columnAliasVarExpr);
            if (columnAliasBinding == null) {
                throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, sourceLoc, new Serializable[0]);
            }
            VarIdentifier letVarId = me.getValue();
            VariableExpr letVarDefExpr = new VariableExpr(letVarId);
            letVarDefExpr.setSourceLocation(sourceLoc);
            LetClause newLetClause = new LetClause(letVarDefExpr, columnAliasBinding.getExpression());
            newLetClause.setSourceLocation(sourceLoc);
            targetLetClauses.add((AbstractClause)newLetClause);
            VariableExpr letVarRefExpr = new VariableExpr(letVarId);
            letVarRefExpr.setSourceLocation(sourceLoc);
            columnAliasBinding.setExpression((Expression)letVarRefExpr);
        }
    }

    private static Map<Expression, Expression> toExpressionMap(Map<Expression, ColumnAliasBinding> bindingMap) {
        HashMap<Expression, Expression> exprMap = new HashMap<Expression, Expression>();
        for (Map.Entry<Expression, ColumnAliasBinding> me : bindingMap.entrySet()) {
            exprMap.put(me.getKey(), me.getValue().getExpression());
        }
        return exprMap;
    }

    private static class SubstituteColumnAliasVisitor
    extends SqlppSubstituteExpressionVisitor {
        private final Map<Expression, VarIdentifier> letVarMap = new LinkedHashMap<Expression, VarIdentifier>();

        private SubstituteColumnAliasVisitor(LangRewritingContext context, Map<Expression, Expression> exprMap) {
            super(context, exprMap);
        }

        @Override
        protected Expression preVisit(Expression expr) {
            return expr;
        }

        @Override
        protected Expression postVisit(Expression expr) throws CompilationException {
            return this.substitute(expr);
        }

        @Override
        protected Expression getMappedExpr(Expression expr) throws CompilationException {
            Expression mappedExpr = super.getMappedExpr(expr);
            if (mappedExpr == null) {
                return null;
            }
            switch (mappedExpr.getKind()) {
                case LITERAL_EXPRESSION: 
                case VARIABLE_EXPRESSION: {
                    return mappedExpr;
                }
            }
            VarIdentifier var = this.letVarMap.get(expr);
            if (var == null) {
                var = this.context.newVariable();
                this.letVarMap.put(expr, var);
            }
            VariableExpr varExpr = new VariableExpr(var);
            varExpr.setSourceLocation(expr.getSourceLocation());
            return varExpr;
        }
    }

    private static abstract class ColumnAliasBinding {
        private ColumnAliasBinding() {
        }

        abstract Expression getExpression();

        abstract void setExpression(Expression var1);

        static ColumnAliasBinding of(final FieldBinding fieldBinding) {
            return new ColumnAliasBinding(){

                @Override
                Expression getExpression() {
                    return fieldBinding.getRightExpr();
                }

                @Override
                void setExpression(Expression expr) {
                    fieldBinding.setRightExpr(expr);
                }
            };
        }

        static ColumnAliasBinding of(final Projection projection) {
            return new ColumnAliasBinding(){

                @Override
                Expression getExpression() {
                    return projection.getExpression();
                }

                @Override
                void setExpression(Expression expr) {
                    projection.setExpression(expr);
                }
            };
        }
    }
}

