/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.feeds;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Map;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.MetadataException;
import org.apache.asterix.common.exceptions.NoOpWarningCollector;
import org.apache.asterix.common.external.IDataSourceAdapter;
import org.apache.asterix.common.functions.ExternalFunctionLanguage;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.utils.IdentifierUtil;
import org.apache.asterix.external.adapter.factory.ExternalAdapterFactory;
import org.apache.asterix.external.api.ITypedAdapterFactory;
import org.apache.asterix.external.feed.api.IFeed;
import org.apache.asterix.external.feed.policy.FeedPolicyAccessor;
import org.apache.asterix.external.provider.AdapterFactoryProvider;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.DatasourceAdapter;
import org.apache.asterix.metadata.entities.Datatype;
import org.apache.asterix.metadata.entities.Feed;
import org.apache.asterix.metadata.entities.FeedPolicyEntity;
import org.apache.asterix.metadata.entities.Library;
import org.apache.asterix.metadata.utils.MetadataConstants;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.commons.lang3.StringUtils;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.api.application.ICCServiceContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IWarningCollector;

public class FeedMetadataUtil {
    private FeedMetadataUtil() {
    }

    public static Dataset validateIfDatasetExists(MetadataProvider metadataProvider, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        Dataset dataset = metadataProvider.findDataset(dataverseName, datasetName);
        if (dataset == null) {
            throw new CompilationException("Unknown target " + IdentifierUtil.dataset() + " :" + datasetName);
        }
        if (!dataset.getDatasetType().equals((Object)DatasetConfig.DatasetType.INTERNAL)) {
            throw new CompilationException("Statement not applicable. " + StringUtils.capitalize((String)IdentifierUtil.dataset()) + " " + datasetName + " is not of required type " + DatasetConfig.DatasetType.INTERNAL);
        }
        return dataset;
    }

    public static Feed validateIfFeedExists(DataverseName dataverseName, String feedName, MetadataTransactionContext ctx) throws AlgebricksException {
        Feed feed = MetadataManager.INSTANCE.getFeed(ctx, dataverseName, feedName);
        if (feed == null) {
            throw new CompilationException("Unknown source feed: " + feedName);
        }
        return feed;
    }

    public static FeedPolicyEntity validateIfPolicyExists(DataverseName dataverseName, String policyName, MetadataTransactionContext ctx) throws AlgebricksException {
        FeedPolicyEntity feedPolicy = MetadataManager.INSTANCE.getFeedPolicy(ctx, dataverseName, policyName);
        if (feedPolicy == null && (feedPolicy = MetadataManager.INSTANCE.getFeedPolicy(ctx, MetadataConstants.METADATA_DATAVERSE_NAME, policyName)) == null) {
            throw new CompilationException("Unknown feed policy" + policyName);
        }
        return feedPolicy;
    }

    public static void validateFeed(Feed feed, MetadataTransactionContext mdTxnCtx, ICcApplicationContext appCtx, IWarningCollector warningCollector) throws AlgebricksException {
        try {
            ITypedAdapterFactory adapterFactory;
            Map<String, String> configuration = feed.getConfiguration();
            ARecordType adapterOutputType = FeedMetadataUtil.getOutputType(feed, configuration.get("type-name"));
            ARecordType metaType = FeedMetadataUtil.getOutputType(feed, configuration.get("meta-type-name"));
            ExternalDataUtils.prepareFeed(configuration, (DataverseName)feed.getDataverseName(), (String)feed.getFeedName());
            String adapterName = configuration.get("adapter-name");
            if (adapterName == null) {
                throw new AlgebricksException("cannot find adapter name");
            }
            DatasourceAdapter adapterEntity = MetadataManager.INSTANCE.getAdapter(mdTxnCtx, MetadataConstants.METADATA_DATAVERSE_NAME, adapterName);
            if (adapterEntity == null) {
                adapterEntity = MetadataManager.INSTANCE.getAdapter(mdTxnCtx, feed.getDataverseName(), adapterName);
            }
            if (adapterEntity != null) {
                IDataSourceAdapter.AdapterType adapterType = adapterEntity.getType();
                String adapterFactoryClassname = adapterEntity.getClassname();
                switch (adapterType) {
                    case INTERNAL: {
                        adapterFactory = (ITypedAdapterFactory)Class.forName(adapterFactoryClassname).newInstance();
                        break;
                    }
                    case EXTERNAL: {
                        adapterFactory = FeedMetadataUtil.createExternalAdapterFactory(mdTxnCtx, adapterEntity, adapterFactoryClassname);
                        break;
                    }
                    default: {
                        throw new AsterixException("Unknown Adapter type " + adapterType);
                    }
                }
            } else {
                ExternalDataUtils.prepare((String)adapterName, configuration);
                adapterFactory = (ITypedAdapterFactory)appCtx.getAdapterFactoryService().createAdapterFactory();
            }
            adapterFactory.setOutputType(adapterOutputType);
            adapterFactory.setMetaType(metaType);
            adapterFactory.configure(appCtx.getServiceContext(), configuration, warningCollector);
            if (metaType == null && configuration.containsKey("meta-type-name") && (metaType = FeedMetadataUtil.getOutputType(feed, configuration.get("meta-type-name"))) == null) {
                throw new AsterixException("Unknown specified feed meta output data type " + configuration.get("meta-type-name"));
            }
            if (adapterOutputType == null) {
                if (!configuration.containsKey("type-name")) {
                    throw new AsterixException("Unspecified feed output data type");
                }
                adapterOutputType = FeedMetadataUtil.getOutputType(feed, configuration.get("type-name"));
                if (adapterOutputType == null) {
                    throw new AsterixException("Unknown specified feed output data type " + configuration.get("type-name"));
                }
            }
        }
        catch (Exception e) {
            throw new AsterixException("Invalid feed parameters. Exception Message:" + e.getMessage(), (Throwable)e);
        }
    }

    private static ITypedAdapterFactory createExternalAdapterFactory(MetadataTransactionContext mdTxnCtx, DatasourceAdapter adapterEntity, String adapterFactoryClassname) throws AlgebricksException, RemoteException, HyracksDataException {
        String libraryName;
        DataverseName libraryDataverse = adapterEntity.getLibraryDataverseName();
        Library library = MetadataManager.INSTANCE.getLibrary(mdTxnCtx, libraryDataverse, libraryName = adapterEntity.getLibraryName());
        if (library == null) {
            throw new CompilationException(ErrorCode.UNKNOWN_LIBRARY, new Serializable[]{libraryName});
        }
        if (!ExternalFunctionLanguage.JAVA.name().equals(library.getLanguage())) {
            throw new HyracksDataException("Unexpected library language: " + library.getLanguage());
        }
        return new ExternalAdapterFactory(libraryDataverse, libraryName, adapterFactoryClassname);
    }

    public static Triple<ITypedAdapterFactory, RecordDescriptor, IDataSourceAdapter.AdapterType> getFeedFactoryAndOutput(Feed feed, FeedPolicyAccessor policyAccessor, MetadataTransactionContext mdTxnCtx, ICcApplicationContext appCtx) throws AlgebricksException {
        String adapterName = null;
        DatasourceAdapter adapterEntity = null;
        String adapterFactoryClassname = null;
        ITypedAdapterFactory adapterFactory = null;
        ARecordType adapterOutputType = null;
        ARecordType metaType = null;
        Triple feedProps = null;
        IDataSourceAdapter.AdapterType adapterType = null;
        try {
            Map<String, String> configuration = feed.getConfiguration();
            adapterName = configuration.get("adapter-name");
            configuration.putAll(policyAccessor.getFeedPolicy());
            adapterOutputType = FeedMetadataUtil.getOutputType(feed, configuration.get("type-name"));
            metaType = FeedMetadataUtil.getOutputType(feed, configuration.get("meta-type-name"));
            ExternalDataUtils.prepareFeed(configuration, (DataverseName)feed.getDataverseName(), (String)feed.getFeedName());
            adapterEntity = MetadataManager.INSTANCE.getAdapter(mdTxnCtx, MetadataConstants.METADATA_DATAVERSE_NAME, adapterName);
            if (adapterEntity == null) {
                adapterEntity = MetadataManager.INSTANCE.getAdapter(mdTxnCtx, feed.getDataverseName(), adapterName);
            }
            if (adapterEntity != null) {
                adapterType = adapterEntity.getType();
                adapterFactoryClassname = adapterEntity.getClassname();
                switch (adapterType) {
                    case INTERNAL: {
                        adapterFactory = (ITypedAdapterFactory)Class.forName(adapterFactoryClassname).newInstance();
                        break;
                    }
                    case EXTERNAL: {
                        adapterFactory = FeedMetadataUtil.createExternalAdapterFactory(mdTxnCtx, adapterEntity, adapterFactoryClassname);
                        break;
                    }
                    default: {
                        throw new AsterixException("Unknown Adapter type " + adapterType);
                    }
                }
                adapterFactory.setOutputType(adapterOutputType);
                adapterFactory.setMetaType(metaType);
                adapterFactory.configure(appCtx.getServiceContext(), configuration, NoOpWarningCollector.INSTANCE);
            } else {
                adapterFactory = AdapterFactoryProvider.getAdapterFactory((ICCServiceContext)appCtx.getServiceContext(), (String)adapterName, configuration, (ARecordType)adapterOutputType, (ARecordType)metaType, (IWarningCollector)NoOpWarningCollector.INSTANCE);
                adapterType = IDataSourceAdapter.AdapterType.INTERNAL;
            }
            if (metaType == null) {
                metaType = FeedMetadataUtil.getOutputType(feed, configuration.get("meta-type-name"));
            }
            if (adapterOutputType == null) {
                if (!configuration.containsKey("type-name")) {
                    throw new AsterixException("Unspecified feed output data type");
                }
                adapterOutputType = FeedMetadataUtil.getOutputType(feed, configuration.get("type-name"));
            }
            int numOfOutputs = 1;
            if (metaType != null) {
                ++numOfOutputs;
            }
            if (ExternalDataUtils.isChangeFeed(configuration)) {
                numOfOutputs += ExternalDataUtils.getNumberOfKeys(configuration);
            }
            ISerializerDeserializer[] serdes = new ISerializerDeserializer[numOfOutputs];
            int i = 0;
            serdes[i++] = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)adapterOutputType);
            if (metaType != null) {
                serdes[i++] = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)metaType);
            }
            if (ExternalDataUtils.isChangeFeed(configuration)) {
                FeedMetadataUtil.getSerdesForPKs(serdes, configuration, metaType, adapterOutputType, i);
            }
            feedProps = new Triple((Object)adapterFactory, (Object)new RecordDescriptor(serdes), (Object)adapterType);
        }
        catch (Exception e) {
            throw new AlgebricksException("unable to create adapter", (Throwable)e);
        }
        return feedProps;
    }

    private static void getSerdesForPKs(ISerializerDeserializer[] serdes, Map<String, String> configuration, ARecordType metaType, ARecordType adapterOutputType, int index) throws AlgebricksException {
        int[] pkIndexes = ExternalDataUtils.getPKIndexes(configuration);
        if (metaType != null) {
            int[] pkIndicators = ExternalDataUtils.getPKSourceIndicators(configuration);
            for (int j = 0; j < pkIndexes.length; ++j) {
                int aInt = pkIndexes[j];
                if (pkIndicators[j] == 0) {
                    serdes[index++] = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)adapterOutputType.getFieldTypes()[aInt]);
                    continue;
                }
                if (pkIndicators[j] == 1) {
                    serdes[index++] = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)metaType.getFieldTypes()[aInt]);
                    continue;
                }
                throw new AlgebricksException("a key source indicator can only be 0 or 1");
            }
        } else {
            for (int aInt : pkIndexes) {
                serdes[index++] = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)adapterOutputType.getFieldTypes()[aInt]);
            }
        }
    }

    public static ARecordType getOutputType(IFeed feed, String fqOutputType) throws AlgebricksException {
        ARecordType outputType;
        block6: {
            if (fqOutputType == null) {
                return null;
            }
            outputType = null;
            MetadataTransactionContext ctx = null;
            try {
                ctx = MetadataManager.INSTANCE.beginTransaction();
                Datatype t = MetadataManager.INSTANCE.getDatatype(ctx, feed.getDataverseName(), fqOutputType);
                if (t == null || t.getDatatype().getTypeTag() != ATypeTag.OBJECT) {
                    throw new MetadataException(ErrorCode.FEED_METADATA_UTIL_UNEXPECTED_FEED_DATATYPE, new Serializable[]{fqOutputType});
                }
                outputType = (ARecordType)t.getDatatype();
                MetadataManager.INSTANCE.commitTransaction(ctx);
            }
            catch (RemoteException | ACIDException e) {
                if (ctx == null) break block6;
                try {
                    MetadataManager.INSTANCE.abortTransaction(ctx);
                }
                catch (RemoteException | ACIDException e2) {
                    e.addSuppressed(e2);
                }
                throw new MetadataException(ErrorCode.FEED_CREATE_FEED_DATATYPE_ERROR, e, new Serializable[]{fqOutputType});
            }
        }
        return outputType;
    }
}

