/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.utils;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HyracksThreadFactory
implements ThreadFactory {
    private final String identifier;
    private final AtomicInteger threadId = new AtomicInteger();
    private static final Logger LOGGER = LogManager.getLogger();

    public HyracksThreadFactory(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread t = new Thread(runnable, "Executor-" + this.threadId.incrementAndGet() + ":" + this.identifier);
        t.setDaemon(true);
        t.setUncaughtExceptionHandler((thread, e) -> LOGGER.log(Level.ERROR, "Uncaught exception by " + thread.getName(), e));
        return t;
    }
}

