/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.ondisk;

import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.IIndexOperationContext;
import org.apache.hyracks.storage.am.common.impls.NoOpIndexAccessParameters;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexSearchCursorInitialState;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IIndexAccessor;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.MultiComparator;

public class OnDiskInvertedIndexOpContext
implements IIndexOperationContext {
    private final RangePredicate btreePred = new RangePredicate(null, null, true, true, null, null);
    private final IIndexAccessor btreeAccessor;
    private final IIndexCursor btreeCursor;
    private final MultiComparator searchCmp;
    private MultiComparator prefixSearchCmp;
    private boolean destroyed = false;
    private LSMInvertedIndexSearchCursorInitialState cursorInitialState;

    public OnDiskInvertedIndexOpContext(BTree btree) throws HyracksDataException {
        this.btreeAccessor = btree.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
        this.btreeCursor = this.btreeAccessor.createSearchCursor(false);
        this.searchCmp = MultiComparator.create((IBinaryComparatorFactory[])btree.getComparatorFactories());
        if (btree.getComparatorFactories().length > 1) {
            this.prefixSearchCmp = MultiComparator.create((IBinaryComparatorFactory[])btree.getComparatorFactories(), (int)0, (int)1);
        }
    }

    public void reset() {
    }

    public void setOperation(IndexOperation newOp) {
    }

    public IndexOperation getOperation() {
        return IndexOperation.SEARCH;
    }

    public RangePredicate getBtreePred() {
        return this.btreePred;
    }

    public MultiComparator getSearchCmp() {
        return this.searchCmp;
    }

    public IIndexAccessor getBtreeAccessor() {
        return this.btreeAccessor;
    }

    public IIndexCursor getBtreeCursor() {
        return this.btreeCursor;
    }

    public MultiComparator getPrefixSearchCmp() {
        return this.prefixSearchCmp;
    }

    public void destroy() throws HyracksDataException {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        try {
            this.btreeAccessor.destroy();
        }
        finally {
            this.btreeCursor.destroy();
        }
    }

    public LSMInvertedIndexSearchCursorInitialState getCursorInitialState() {
        if (this.cursorInitialState == null) {
            this.cursorInitialState = new LSMInvertedIndexSearchCursorInitialState();
        }
        return this.cursorInitialState;
    }
}

