/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.fulltext;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import org.apache.hyracks.storage.am.lsm.invertedindex.fulltext.IFullTextConfigEvaluator;
import org.apache.hyracks.storage.am.lsm.invertedindex.fulltext.IFullTextFilterEvaluator;
import org.apache.hyracks.storage.am.lsm.invertedindex.fulltext.TokenizerCategory;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IBinaryTokenizer;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IToken;

public class FullTextConfigEvaluator
implements IFullTextConfigEvaluator {
    private final String name;
    private IBinaryTokenizer tokenizer;
    private final ImmutableList<IFullTextFilterEvaluator> filters;
    private IToken currentToken;
    private IToken nextToken;

    public FullTextConfigEvaluator(String name, TokenizerCategory tokenizerCategory, ImmutableList<IFullTextFilterEvaluator> filters) {
        this.name = name;
        this.filters = filters;
        switch (tokenizerCategory) {
            case WORD: {
                this.tokenizer = null;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public IBinaryTokenizer getTokenizer() {
        return this.tokenizer;
    }

    @Override
    public TokenizerCategory getTokenizerCategory() {
        return this.tokenizer.getTokenizerCategory();
    }

    @Override
    public void setTokenizer(IBinaryTokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void reset(byte[] data, int start, int length) {
        this.currentToken = null;
        this.nextToken = null;
        this.tokenizer.reset(data, start, length);
    }

    @Override
    public IToken getToken() {
        return this.currentToken;
    }

    @Override
    public boolean hasNext() {
        if (this.nextToken != null) {
            return true;
        }
        while (this.tokenizer.hasNext()) {
            IFullTextFilterEvaluator filter;
            this.tokenizer.next();
            IToken candidateToken = this.tokenizer.getToken();
            UnmodifiableIterator unmodifiableIterator = this.filters.iterator();
            while (unmodifiableIterator.hasNext() && (candidateToken = (filter = (IFullTextFilterEvaluator)unmodifiableIterator.next()).processToken(this.tokenizer.getTokenizerType(), candidateToken)) != null) {
            }
            if (candidateToken == null) continue;
            this.nextToken = candidateToken;
            break;
        }
        return this.nextToken != null;
    }

    @Override
    public void next() {
        this.currentToken = this.nextToken;
        this.nextToken = null;
    }

    @Override
    public int getTokensCount() {
        return this.tokenizer.getTokensCount();
    }
}

