/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc;

import java.lang.management.ManagementFactory;
import java.util.Arrays;
import org.apache.hyracks.api.application.INCApplication;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.config.IConfigManager;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.config.Section;
import org.apache.hyracks.api.control.CcId;
import org.apache.hyracks.api.io.IFileDeviceResolver;
import org.apache.hyracks.api.job.resource.NodeCapacity;
import org.apache.hyracks.control.common.ControllerShutdownHook;
import org.apache.hyracks.control.common.config.ConfigManager;
import org.apache.hyracks.control.common.controllers.CCConfig;
import org.apache.hyracks.control.common.controllers.ControllerConfig;
import org.apache.hyracks.control.common.controllers.NCConfig;
import org.apache.hyracks.control.nc.io.DefaultDeviceResolver;
import org.apache.hyracks.util.ExitUtil;
import org.apache.hyracks.util.LoggingConfigUtil;
import org.apache.logging.log4j.Level;

public class BaseNCApplication
implements INCApplication {
    public static final BaseNCApplication INSTANCE = new BaseNCApplication();
    protected INCServiceContext ncServiceCtx;
    private ConfigManager configManager;
    private Thread shutdownHook;

    protected BaseNCApplication() {
    }

    public void init(IServiceContext serviceCtx) throws Exception {
        this.ncServiceCtx = (INCServiceContext)serviceCtx;
    }

    public void start(String[] args) throws Exception {
        if (args.length > 0) {
            throw new IllegalArgumentException("Unrecognized argument(s): " + Arrays.toString(args));
        }
    }

    public void startupCompleted() throws Exception {
        this.installShutdownHook();
    }

    public void tasksCompleted(CcId ccId) throws Exception {
    }

    public void stop() throws Exception {
        this.uninstallShutdownHook();
    }

    public void preStop() throws Exception {
    }

    protected Thread createShutdownHook() {
        return new ControllerShutdownHook((IServiceContext)this.ncServiceCtx);
    }

    protected void installShutdownHook() {
        this.shutdownHook = this.createShutdownHook();
        ExitUtil.registerShutdownHook((Thread)this.shutdownHook);
    }

    protected void uninstallShutdownHook() {
        if (this.shutdownHook != null) {
            ExitUtil.unregisterShutdownHook((Thread)this.shutdownHook);
        }
    }

    public NodeCapacity getCapacity() {
        int allCores = ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors();
        return new NodeCapacity(Runtime.getRuntime().maxMemory(), allCores > 1 ? allCores - 1 : allCores);
    }

    public void registerConfig(IConfigManager configManager) {
        this.configManager = (ConfigManager)configManager;
        configManager.addIniParamOptions(new IOption[]{ControllerConfig.Option.CONFIG_FILE, ControllerConfig.Option.CONFIG_FILE_URL});
        configManager.addCmdLineSections(new Section[]{Section.NC, Section.COMMON, Section.LOCALNC});
        configManager.setUsageFilter(this.getUsageFilter());
        configManager.register(new Class[]{ControllerConfig.Option.class, CCConfig.Option.class, NCConfig.Option.class});
    }

    public Object getApplicationContext() {
        return null;
    }

    public IFileDeviceResolver getFileDeviceResolver() {
        return new DefaultDeviceResolver();
    }

    public void configureLoggingLevel(Level level) {
        LoggingConfigUtil.defaultIfMissing((String)"org.apache.hyracks", (Level)level);
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }
}

