/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.math.BigDecimal;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AFloatSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.base.AMutableFloat;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.exceptions.ExceptionUtil;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.common.ArgumentUtils;
import org.apache.asterix.runtime.evaluators.functions.AbstractScalarEval;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class NumericRoundTruncEvaluator
extends AbstractScalarEval {
    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private final DataOutput out = this.resultStorage.getDataOutput();
    private final IPointable valueArg = new VoidPointable();
    private final IPointable precisionArg = new VoidPointable();
    private final AMutableDouble aDouble = new AMutableDouble(0.0);
    private final AMutableFloat aFloat = new AMutableFloat(0.0f);
    private final AMutableInt32 aInt32 = new AMutableInt32(0);
    private final IEvaluatorContext ctx;
    private final IScalarEvaluator valueEval;
    private final IScalarEvaluator precisionEval;
    private final int roundingMode;

    NumericRoundTruncEvaluator(IEvaluatorContext ctx, IScalarEvaluatorFactory[] args, int roundingMode, FunctionIdentifier funID, SourceLocation srcLoc) throws HyracksDataException {
        super(srcLoc, funID);
        this.ctx = ctx;
        this.valueEval = args[0].createScalarEvaluator(ctx);
        this.precisionEval = args[1].createScalarEvaluator(ctx);
        this.roundingMode = roundingMode;
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        int offset;
        this.resultStorage.reset();
        this.valueEval.evaluate(tuple, this.valueArg);
        this.precisionEval.evaluate(tuple, this.precisionArg);
        if (PointableHelper.checkAndSetMissingOrNull(result, this.valueArg, this.precisionArg)) {
            return;
        }
        byte[] value = this.valueArg.getByteArray();
        byte valueTag = value[offset = this.valueArg.getStartOffset()];
        if (ATypeHierarchy.getTypeDomain((ATypeTag)ATypeTag.VALUE_TYPE_MAPPING[valueTag]) != ATypeHierarchy.Domain.NUMERIC) {
            ExceptionUtil.warnTypeMismatch((IEvaluatorContext)this.ctx, (SourceLocation)this.srcLoc, (FunctionIdentifier)this.funID, (byte)valueTag, (int)0, (byte[])ArgumentUtils.NUMERIC_TYPES);
            PointableHelper.setNull(result);
            return;
        }
        if (!ArgumentUtils.setInteger(this.ctx, this.srcLoc, this.funID, 1, this.precisionArg.getByteArray(), this.precisionArg.getStartOffset(), this.aInt32)) {
            PointableHelper.setNull(result);
            return;
        }
        if (valueTag == ATypeTag.SERIALIZED_INT8_TYPE_TAG || valueTag == ATypeTag.SERIALIZED_INT16_TYPE_TAG || valueTag == ATypeTag.SERIALIZED_INT32_TYPE_TAG || valueTag == ATypeTag.SERIALIZED_INT64_TYPE_TAG) {
            result.set((IValueReference)this.valueArg);
            return;
        }
        if (valueTag == ATypeTag.SERIALIZED_FLOAT_TYPE_TAG) {
            ISerializerDeserializer serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AFLOAT);
            float val = AFloatSerializerDeserializer.getFloat((byte[])value, (int)(offset + 1));
            if (Float.isNaN(val) || Float.isInfinite(val) || Float.compare(val, -0.0f) == 0 || Float.compare(val, 0.0f) == 0) {
                this.aFloat.setValue(val);
                serde.serialize((Object)this.aFloat, this.out);
            } else {
                BigDecimal r = new BigDecimal(Float.toString(val));
                this.aFloat.setValue(r.setScale(this.aInt32.getIntegerValue(), this.roundingMode).floatValue());
                serde.serialize((Object)this.aFloat, this.out);
            }
        } else if (valueTag == ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG) {
            ISerializerDeserializer serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADOUBLE);
            double val = ADoubleSerializerDeserializer.getDouble((byte[])value, (int)(offset + 1));
            if (Double.isNaN(val) || Double.isInfinite(val) || Double.compare(val, -0.0) == 0 || Double.compare(val, 0.0) == 0) {
                this.aDouble.setValue(val);
                serde.serialize((Object)this.aDouble, this.out);
            } else {
                BigDecimal r = new BigDecimal(Double.toString(val));
                this.aDouble.setValue(r.setScale(this.aInt32.getIntegerValue(), this.roundingMode).doubleValue());
                serde.serialize((Object)this.aDouble, this.out);
            }
        } else {
            ExceptionUtil.warnUnsupportedType((IEvaluatorContext)this.ctx, (SourceLocation)this.srcLoc, (String)this.funID.getName(), (ATypeTag)ATypeTag.VALUE_TYPE_MAPPING[valueTag]);
            PointableHelper.setNull(result);
            return;
        }
        result.set((IValueReference)this.resultStorage);
    }
}

