/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.statement;

import java.util.Objects;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.lang.common.base.AbstractStatement;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;

public class DeleteStatement
extends AbstractStatement {
    private VariableExpr vars;
    private DataverseName dataverseName;
    private String datasetName;
    private Expression condition;
    private int varCounter;
    private Query rewrittenQuery;

    public DeleteStatement(VariableExpr vars, DataverseName dataverseName, String datasetName, Expression condition, int varCounter) {
        this.vars = vars;
        this.dataverseName = dataverseName;
        this.datasetName = datasetName;
        this.condition = condition;
        this.varCounter = varCounter;
    }

    @Override
    public Statement.Kind getKind() {
        return Statement.Kind.DELETE;
    }

    public VariableExpr getVariableExpr() {
        return this.vars;
    }

    public DataverseName getDataverseName() {
        return this.dataverseName;
    }

    public void setDataverseName(DataverseName dataverseName) {
        this.dataverseName = dataverseName;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public void setDatasetName(String datasetName) {
        this.datasetName = datasetName;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public int getVarCounter() {
        return this.varCounter;
    }

    public void setQuery(Query rewrittenQuery) {
        this.rewrittenQuery = rewrittenQuery;
    }

    public Query getQuery() {
        return this.rewrittenQuery;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    public int hashCode() {
        return Objects.hash(this.condition, this.datasetName, this.dataverseName, this.rewrittenQuery, this.vars);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DeleteStatement)) {
            return false;
        }
        DeleteStatement target = (DeleteStatement)object;
        return Objects.equals(this.condition, target.condition) && Objects.equals(this.datasetName, target.datasetName) && Objects.equals(this.dataverseName, target.dataverseName) && Objects.equals(this.rewrittenQuery, target.rewrittenQuery) && Objects.equals(this.vars, target.vars) && this.varCounter == target.varCounter;
    }

    @Override
    public byte getCategory() {
        return 2;
    }
}

