/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import org.apache.asterix.dataflow.data.nontagged.serde.ADateTimeSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ADate;
import org.apache.asterix.om.base.AMutableDate;
import org.apache.asterix.om.base.temporal.ADateParserFactory;
import org.apache.asterix.om.base.temporal.GregorianCalendarSystem;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.runtime.evaluators.constructors.AbstractConstructorEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;

public abstract class AbstractDateConstructorEvaluator
extends AbstractConstructorEvaluator {
    private final AMutableDate aDate = new AMutableDate(0);
    private final ISerializerDeserializer<ADate> dateSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADATE);
    private final UTF8StringPointable utf8Ptr = new UTF8StringPointable();
    private final GregorianCalendarSystem cal = GregorianCalendarSystem.getInstance();

    protected AbstractDateConstructorEvaluator(IEvaluatorContext ctx, IScalarEvaluator inputEval, SourceLocation sourceLoc) {
        super(ctx, inputEval, sourceLoc);
    }

    @Override
    protected void evaluateImpl(IPointable result) throws HyracksDataException {
        byte[] bytes = this.inputArg.getByteArray();
        int startOffset = this.inputArg.getStartOffset();
        int len = this.inputArg.getLength();
        ATypeTag inputType = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes[startOffset]);
        switch (inputType) {
            case DATE: {
                result.set((IValueReference)this.inputArg);
                break;
            }
            case DATETIME: {
                long chronon = ADateTimeSerializerDeserializer.getChronon((byte[])bytes, (int)(startOffset + 1));
                int chrononInDays = this.cal.getChrononInDays(chronon);
                this.aDate.setValue(chrononInDays);
                this.resultStorage.reset();
                this.dateSerde.serialize((Object)this.aDate, this.out);
                result.set((IValueReference)this.resultStorage);
                break;
            }
            case STRING: {
                this.utf8Ptr.set(bytes, startOffset + 1, len - 1);
                if (this.parseDate(this.utf8Ptr, this.aDate)) {
                    this.resultStorage.reset();
                    this.dateSerde.serialize((Object)this.aDate, this.out);
                    result.set((IValueReference)this.resultStorage);
                    break;
                }
                this.handleParseError(this.utf8Ptr, result);
                break;
            }
            default: {
                this.handleUnsupportedType(inputType, result);
            }
        }
    }

    protected boolean parseDate(UTF8StringPointable textPtr, AMutableDate result) {
        int stringLength = textPtr.getUTF8Length();
        if (stringLength < 8) {
            return false;
        }
        try {
            long chronon = ADateParserFactory.parseDatePart((byte[])textPtr.getByteArray(), (int)textPtr.getCharStartOffset(), (int)stringLength);
            int chrononInDays = this.cal.getChrononInDays(chronon);
            result.setValue(chrononInDays);
            return true;
        }
        catch (HyracksDataException e) {
            return false;
        }
    }

    @Override
    protected final BuiltinType getTargetType() {
        return BuiltinType.ADATE;
    }
}

