/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.implementation.connectionstring;

import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.implementation.connectionstring.ConnectionSettings;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;

public final class StorageEndpoint {
    private final String primaryUri;
    private final String secondaryUri;

    public StorageEndpoint(URI primaryUri) {
        Objects.requireNonNull(primaryUri);
        this.primaryUri = primaryUri.toString();
        this.secondaryUri = null;
    }

    public StorageEndpoint(URI primaryUri, URI secondaryUri) {
        Objects.requireNonNull(primaryUri);
        Objects.requireNonNull(secondaryUri);
        this.primaryUri = primaryUri.toString();
        this.secondaryUri = secondaryUri.toString();
    }

    public String getPrimaryUri() {
        return this.primaryUri;
    }

    public String getSecondaryUri() {
        return this.secondaryUri;
    }

    public static StorageEndpoint fromStorageSettings(ConnectionSettings settings, String service, String serviceEndpointName, String serviceSecondaryEndpointName, Boolean matchesAutomaticEndpointsSpec, ClientLogger logger) {
        String serviceEndpoint = settings.getSettingValue(serviceEndpointName);
        String serviceSecondaryEndpoint = settings.getSettingValue(serviceSecondaryEndpointName);
        if (serviceEndpoint != null && serviceSecondaryEndpoint != null) {
            try {
                return new StorageEndpoint(new URI(serviceEndpoint), new URI(serviceSecondaryEndpoint));
            }
            catch (URISyntaxException use) {
                throw logger.logExceptionAsError(new RuntimeException(use));
            }
        }
        if (serviceEndpoint != null) {
            try {
                return new StorageEndpoint(new URI(serviceEndpoint));
            }
            catch (URISyntaxException use) {
                throw logger.logExceptionAsError(new RuntimeException(use));
            }
        }
        if (matchesAutomaticEndpointsSpec.booleanValue()) {
            URI secondaryUri;
            URI primaryUri;
            String protocol = settings.getSettingValue("DefaultEndpointsProtocol");
            if (StorageEndpoint.isNullOrEmpty(protocol)) {
                throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'DefaultEndpointsProtocol' is required, specify whether to use http or https."));
            }
            String accountName = settings.getSettingValue("AccountName");
            if (StorageEndpoint.isNullOrEmpty(accountName)) {
                throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'AccountName' is required."));
            }
            String endpointSuffix = settings.getSettingValue("EndpointSuffix");
            if (endpointSuffix == null) {
                endpointSuffix = "core.windows.net";
            }
            try {
                primaryUri = new URI(String.format("%s://%s.%s.%s", protocol, accountName, service, endpointSuffix));
            }
            catch (URISyntaxException use) {
                throw logger.logExceptionAsError(new RuntimeException(use));
            }
            try {
                secondaryUri = new URI(String.format("%s://%s-secondary.%s.%s", protocol, accountName, service, endpointSuffix));
            }
            catch (URISyntaxException use) {
                throw logger.logExceptionAsError(new RuntimeException(use));
            }
            return new StorageEndpoint(primaryUri, secondaryUri);
        }
        return null;
    }

    private static boolean isNullOrEmpty(String value) {
        return value == null || value.length() == 0;
    }
}

