/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.result;

import java.io.Serializable;
import org.apache.hyracks.api.comm.NetworkAddress;

public class ResultDirectoryRecord
implements Serializable {
    private static final long serialVersionUID = 1L;
    private NetworkAddress address = null;
    private boolean readEOS = false;
    private Status status = Status.IDLE;
    private boolean empty;

    public void setNetworkAddress(NetworkAddress address) {
        this.address = address;
    }

    public NetworkAddress getNetworkAddress() {
        return this.address;
    }

    public void setEmpty(boolean empty) {
        this.empty = empty;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void readEOS() {
        this.readEOS = true;
    }

    public boolean hasReachedReadEOS() {
        return this.readEOS;
    }

    public void start() {
        this.updateStatus(Status.RUNNING);
    }

    public void writeEOS() {
        this.updateStatus(Status.SUCCESS);
    }

    public void fail() {
        this.status = Status.FAILED;
    }

    private void updateStatus(Status newStatus) {
        if (this.status != Status.FAILED) {
            this.status = newStatus;
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResultDirectoryRecord)) {
            return false;
        }
        return this.address.equals(((ResultDirectoryRecord)o).address);
    }

    public String toString() {
        return String.valueOf(this.address) + " " + this.status + (this.empty ? " (empty)" : "") + (this.readEOS ? " (EOS)" : "");
    }

    public static enum Status {
        IDLE,
        RUNNING,
        SUCCESS,
        FAILED;

    }
}

