/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.am.array;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.asterix.optimizer.rules.am.array.AbstractOperatorFromSubplanRewrite;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;

public class JoinFromSubplanRewrite
extends AbstractOperatorFromSubplanRewrite<AbstractBinaryJoinOperator> {
    private static final Set<FunctionIdentifier> optimizableFunctions = new HashSet<FunctionIdentifier>();
    private final Deque<JoinFromSubplanContext> contextStack = new ArrayDeque<JoinFromSubplanContext>();

    public static void addOptimizableFunction(FunctionIdentifier functionIdentifier) {
        optimizableFunctions.add(functionIdentifier);
    }

    public void findAfterSubplanSelectOperator(List<Mutable<ILogicalOperator>> afterJoinRefs) throws AlgebricksException {
        JoinFromSubplanContext joinContext = new JoinFromSubplanContext();
        this.contextStack.push(joinContext);
        if (afterJoinRefs.size() < 3) {
            return;
        }
        Mutable<ILogicalOperator> afterJoinOpRef1 = afterJoinRefs.get(afterJoinRefs.size() - 1);
        Mutable<ILogicalOperator> afterJoinOpRef2 = afterJoinRefs.get(afterJoinRefs.size() - 2);
        Mutable<ILogicalOperator> afterJoinOpRef3 = afterJoinRefs.get(afterJoinRefs.size() - 3);
        ILogicalOperator afterJoinOp1 = (ILogicalOperator)afterJoinOpRef1.getValue();
        ILogicalOperator afterJoinOp2 = (ILogicalOperator)afterJoinOpRef2.getValue();
        ILogicalOperator afterJoinOp3 = (ILogicalOperator)afterJoinOpRef3.getValue();
        if (!afterJoinOp1.getOperatorTag().equals((Object)LogicalOperatorTag.SUBPLAN) || !afterJoinOp2.getOperatorTag().equals((Object)LogicalOperatorTag.SELECT)) {
            return;
        }
        ArrayList<VariableReferenceExpression> booleanVariables = new ArrayList<VariableReferenceExpression>();
        joinContext.selectAfterSubplan = (SelectOperator)afterJoinOp2;
        this.gatherBooleanVariables((ILogicalExpression)joinContext.selectAfterSubplan.getCondition().getValue(), booleanVariables, new ArrayList<ILogicalExpression>());
        if (booleanVariables.isEmpty()) {
            return;
        }
        joinContext.removedAfterJoinOperators = new ArrayList<Mutable<ILogicalOperator>>();
        joinContext.removedAfterJoinOperators.add(afterJoinOpRef2);
        joinContext.removedAfterJoinOperators.add(afterJoinOpRef1);
        afterJoinRefs.remove(afterJoinOpRef2);
        afterJoinRefs.remove(afterJoinOpRef1);
        joinContext.afterJoinOpForRewrite = OperatorManipulationUtil.deepCopy((ILogicalOperator)afterJoinOp3);
        joinContext.afterJoinOpForRewrite.getInputs().clear();
        joinContext.afterJoinOpForRewrite.getInputs().addAll(afterJoinOp3.getInputs());
    }

    @Override
    public AbstractBinaryJoinOperator createOperator(AbstractBinaryJoinOperator originalOperator, IOptimizationContext context) throws AlgebricksException {
        List originalOpInputs;
        this.reset(originalOperator.getSourceLocation(), context, optimizableFunctions);
        JoinFromSubplanContext joinContext = this.contextStack.getFirst();
        joinContext.originalJoinRoot = originalOperator;
        if (joinContext.removedAfterJoinOperators == null) {
            return null;
        }
        SubplanOperator subplanOperator = (SubplanOperator)((Mutable)joinContext.selectAfterSubplan.getInputs().get(0)).getValue();
        Pair<SelectOperator, UnnestOperator> traversalOutput = this.traverseSubplanBranch(subplanOperator, (ILogicalOperator)((Mutable)(originalOpInputs = originalOperator.getInputs()).get(1)).getValue(), true);
        if (traversalOutput == null) {
            return null;
        }
        ScalarFunctionCallExpression newCond = this.coalesceConditions((SelectOperator)traversalOutput.first, (ILogicalOperator)joinContext.originalJoinRoot);
        joinContext.newJoinRoot = new InnerJoinOperator((Mutable)new MutableObject((Object)newCond));
        joinContext.newJoinRoot.getInputs().add(0, new MutableObject((Object)((ILogicalOperator)((Mutable)originalOpInputs.get(0)).getValue())));
        ((UnnestOperator)traversalOutput.second).getInputs().clear();
        ((UnnestOperator)traversalOutput.second).getInputs().add(new MutableObject((Object)((ILogicalOperator)((Mutable)originalOpInputs.get(1)).getValue())));
        joinContext.newJoinRoot.getInputs().add(1, (Mutable)((SelectOperator)traversalOutput.first).getInputs().get(0));
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)joinContext.newJoinRoot);
        ArrayList conjuncts = new ArrayList();
        if (newCond.splitIntoConjuncts(conjuncts)) {
            for (Mutable conjunct : conjuncts) {
                this.extractFunctionCallToAssign(joinContext.newJoinRoot, context, (ILogicalExpression)conjunct.getValue());
            }
        } else {
            this.extractFunctionCallToAssign(joinContext.newJoinRoot, context, (ILogicalExpression)newCond);
        }
        OperatorManipulationUtil.substituteOpInInput((ILogicalOperator)joinContext.afterJoinOpForRewrite, (ILogicalOperator)((ILogicalOperator)joinContext.removedAfterJoinOperators.get(0).getValue()), (Mutable)new MutableObject((Object)joinContext.newJoinRoot));
        context.computeAndSetTypeEnvironmentForOperator(joinContext.afterJoinOpForRewrite);
        return joinContext.newJoinRoot;
    }

    @Override
    public AbstractBinaryJoinOperator restoreBeforeRewrite(List<Mutable<ILogicalOperator>> afterOperatorRefs, IOptimizationContext context) {
        JoinFromSubplanContext joinContext = this.contextStack.pop();
        if (joinContext.removedAfterJoinOperators != null) {
            afterOperatorRefs.addAll(joinContext.removedAfterJoinOperators);
        }
        return joinContext.originalJoinRoot;
    }

    private void extractFunctionCallToAssign(AbstractBinaryJoinOperator joinOp, IOptimizationContext context, ILogicalExpression condition) throws AlgebricksException {
        if (!condition.getExpressionTag().equals((Object)LogicalExpressionTag.FUNCTION_CALL)) {
            return;
        }
        AbstractFunctionCallExpression conditionAsFuncCall = (AbstractFunctionCallExpression)condition;
        if (!AlgebricksBuiltinFunctions.isComparisonFunction((FunctionIdentifier)conditionAsFuncCall.getFunctionIdentifier())) {
            return;
        }
        for (Mutable arg : conditionAsFuncCall.getArguments()) {
            if (!((ILogicalExpression)arg.getValue()).getExpressionTag().equals((Object)LogicalExpressionTag.FUNCTION_CALL)) continue;
            LogicalVariable newVar = context.newVar();
            VariableReferenceExpression newVarRef = new VariableReferenceExpression(newVar);
            newVarRef.setSourceLocation(joinOp.getSourceLocation());
            MutableObject clonedArgRef = new MutableObject((Object)((ILogicalExpression)arg.getValue()).cloneExpression());
            AssignOperator newAssign = new AssignOperator(newVar, (Mutable)clonedArgRef);
            newAssign.setSourceLocation(((ILogicalExpression)clonedArgRef.getValue()).getSourceLocation());
            newAssign.setExecutionMode(joinOp.getExecutionMode());
            ILogicalOperator leftBranchRoot = (ILogicalOperator)((Mutable)joinOp.getInputs().get(0)).getValue();
            ILogicalOperator rightBranchRoot = (ILogicalOperator)((Mutable)joinOp.getInputs().get(1)).getValue();
            ArrayList usedVarsFromFunc = new ArrayList();
            ArrayList varsFromLeftBranch = new ArrayList();
            ArrayList varsFromRightBranch = new ArrayList();
            VariableUtilities.getUsedVariables((ILogicalOperator)newAssign, usedVarsFromFunc);
            VariableUtilities.getProducedVariablesInDescendantsAndSelf((ILogicalOperator)leftBranchRoot, varsFromLeftBranch);
            VariableUtilities.getProducedVariablesInDescendantsAndSelf((ILogicalOperator)rightBranchRoot, varsFromRightBranch);
            if (new HashSet(varsFromLeftBranch).containsAll(usedVarsFromFunc)) {
                newAssign.getInputs().add(new MutableObject((Object)leftBranchRoot));
                context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)newAssign);
                ((Mutable)joinOp.getInputs().get(0)).setValue((Object)newAssign);
                context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)joinOp);
                arg.setValue((Object)newVarRef);
                continue;
            }
            if (!new HashSet(varsFromRightBranch).containsAll(usedVarsFromFunc)) continue;
            newAssign.getInputs().add(new MutableObject((Object)rightBranchRoot));
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)newAssign);
            ((Mutable)joinOp.getInputs().get(1)).setValue((Object)newAssign);
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)joinOp);
            arg.setValue((Object)newVarRef);
        }
    }

    private static class JoinFromSubplanContext {
        private List<Mutable<ILogicalOperator>> removedAfterJoinOperators;
        private AbstractBinaryJoinOperator originalJoinRoot;
        private AbstractBinaryJoinOperator newJoinRoot;
        private SelectOperator selectAfterSubplan;
        private ILogicalOperator afterJoinOpForRewrite;

        private JoinFromSubplanContext() {
        }
    }
}

