/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.dataflow;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.util.CleanupUtils;
import org.apache.hyracks.api.util.ExceptionUtils;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryOutputSourceOperatorNodePushable;
import org.apache.hyracks.storage.am.common.api.IIndexDataflowHelper;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.api.ITreeIndexAccessor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.impls.IndexAccessParameters;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.impls.TreeIndexDiskOrderScanCursor;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.LocalResource;

public class TreeIndexDiskOrderScanOperatorNodePushable
extends AbstractUnaryOutputSourceOperatorNodePushable {
    private final IHyracksTaskContext ctx;
    private final IIndexDataflowHelper treeIndexHelper;
    private final ISearchOperationCallbackFactory searchCallbackFactory;

    public TreeIndexDiskOrderScanOperatorNodePushable(IHyracksTaskContext ctx, int partition, IIndexDataflowHelperFactory indexHelperFactory, ISearchOperationCallbackFactory searchCallbackFactory) throws HyracksDataException {
        this.ctx = ctx;
        this.treeIndexHelper = indexHelperFactory.create(ctx.getJobletContext().getServiceContext(), partition);
        this.searchCallbackFactory = searchCallbackFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws HyracksDataException {
        Throwable failure = null;
        this.treeIndexHelper.open();
        try {
            this.writer.open();
            FrameTupleAppender appender = new FrameTupleAppender((IFrame)new VSizeFrame((IHyracksFrameMgrContext)this.ctx));
            this.scan(appender);
            appender.write(this.writer, true);
        }
        catch (Throwable th) {
            failure = th;
            try {
                this.writer.fail();
            }
            catch (Throwable failFailure) {
                failure = ExceptionUtils.suppress((Throwable)failure, (Throwable)failFailure);
            }
        }
        finally {
            failure = CleanupUtils.close((IFrameWriter)this.writer, (Throwable)failure);
        }
        if (failure != null) {
            throw HyracksDataException.create((Throwable)failure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scan(FrameTupleAppender appender) throws IOException {
        ITreeIndex treeIndex = (ITreeIndex)this.treeIndexHelper.getIndexInstance();
        LocalResource resource = this.treeIndexHelper.getResource();
        ISearchOperationCallback searchCallback = this.searchCallbackFactory.createSearchOperationCallback(resource.getId(), this.ctx, null);
        IndexAccessParameters iap = new IndexAccessParameters(NoOpOperationCallback.INSTANCE, searchCallback);
        ITreeIndexAccessor indexAccessor = (ITreeIndexAccessor)treeIndex.createAccessor(iap);
        try {
            this.doScan(treeIndex, indexAccessor, appender);
        }
        finally {
            indexAccessor.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doScan(ITreeIndex treeIndex, ITreeIndexAccessor indexAccessor, FrameTupleAppender appender) throws IOException {
        int fieldCount = treeIndex.getFieldCount();
        ArrayTupleBuilder tb = new ArrayTupleBuilder(fieldCount);
        DataOutput dos = tb.getDataOutput();
        ITreeIndexFrame cursorFrame = treeIndex.getLeafFrameFactory().createFrame();
        TreeIndexDiskOrderScanCursor cursor = new TreeIndexDiskOrderScanCursor(cursorFrame);
        try {
            indexAccessor.diskOrderScan(cursor);
            try {
                while (cursor.hasNext()) {
                    tb.reset();
                    cursor.next();
                    ITupleReference frameTuple = cursor.getTuple();
                    for (int i = 0; i < frameTuple.getFieldCount(); ++i) {
                        dos.write(frameTuple.getFieldData(i), frameTuple.getFieldStart(i), frameTuple.getFieldLength(i));
                        tb.addFieldEndOffset();
                    }
                    FrameUtils.appendToWriter((IFrameWriter)this.writer, (IFrameTupleAppender)appender, (int[])tb.getFieldEndOffsets(), (byte[])tb.getByteArray(), (int)0, (int)tb.getSize());
                }
            }
            finally {
                cursor.close();
            }
        }
        finally {
            cursor.destroy();
        }
    }

    public void deinitialize() throws HyracksDataException {
        this.treeIndexHelper.close();
    }
}

