/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.group.preclustered;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputOperatorNodePushable;
import org.apache.hyracks.dataflow.std.group.IAggregatorDescriptorFactory;
import org.apache.hyracks.dataflow.std.group.preclustered.PreclusteredGroupWriter;

class PreclusteredGroupOperatorNodePushable
extends AbstractUnaryInputUnaryOutputOperatorNodePushable {
    private final IHyracksTaskContext ctx;
    private final int[] groupFields;
    private final IBinaryComparatorFactory[] comparatorFactories;
    private final IAggregatorDescriptorFactory aggregatorFactory;
    private final RecordDescriptor inRecordDescriptor;
    private final RecordDescriptor outRecordDescriptor;
    private final boolean groupAll;
    private final int frameLimit;
    private PreclusteredGroupWriter pgw;

    PreclusteredGroupOperatorNodePushable(IHyracksTaskContext ctx, int[] groupFields, IBinaryComparatorFactory[] comparatorFactories, IAggregatorDescriptorFactory aggregatorFactory, RecordDescriptor inRecordDescriptor, RecordDescriptor outRecordDescriptor, boolean groupAll, int frameLimit) {
        this.ctx = ctx;
        this.groupFields = groupFields;
        this.comparatorFactories = comparatorFactories;
        this.aggregatorFactory = aggregatorFactory;
        this.inRecordDescriptor = inRecordDescriptor;
        this.outRecordDescriptor = outRecordDescriptor;
        this.groupAll = groupAll;
        this.frameLimit = frameLimit;
    }

    public void open() throws HyracksDataException {
        IBinaryComparator[] comparators = new IBinaryComparator[this.comparatorFactories.length];
        for (int i = 0; i < this.comparatorFactories.length; ++i) {
            comparators[i] = this.comparatorFactories[i].createBinaryComparator();
        }
        this.pgw = new PreclusteredGroupWriter(this.ctx, this.groupFields, comparators, this.aggregatorFactory, this.inRecordDescriptor, this.outRecordDescriptor, this.writer, false, this.groupAll, this.frameLimit);
        this.pgw.open();
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.pgw.nextFrame(buffer);
    }

    public void fail() throws HyracksDataException {
        this.pgw.fail();
    }

    public void close() throws HyracksDataException {
        this.pgw.close();
    }

    public void flush() throws HyracksDataException {
        this.pgw.flush();
    }
}

