/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.blob.models.SyncCopyStatusType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;

@JacksonXmlRootElement(localName="Blob-CopyFromURL-Headers")
public final class BlobCopyFromURLHeaders {
    @JsonProperty(value="ETag")
    private String eTag;
    @JsonProperty(value="Last-Modified")
    private DateTimeRfc1123 lastModified;
    @JsonProperty(value="x-ms-client-request-id")
    private String clientRequestId;
    @JsonProperty(value="x-ms-request-id")
    private String requestId;
    @JsonProperty(value="x-ms-version")
    private String version;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 dateProperty;
    @JsonProperty(value="x-ms-copy-id")
    private String copyId;
    @JsonProperty(value="x-ms-copy-status")
    private SyncCopyStatusType copyStatus;
    @JsonProperty(value="Content-MD5")
    private byte[] contentMD5;
    @JsonProperty(value="x-ms-content-crc64")
    private byte[] xMsContentCrc64;
    @JsonProperty(value="x-ms-version-id")
    private String versionId;
    @JsonProperty(value="x-ms-error-code")
    private String errorCode;

    public String getETag() {
        return this.eTag;
    }

    public BlobCopyFromURLHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public BlobCopyFromURLHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public String getClientRequestId() {
        return this.clientRequestId;
    }

    public BlobCopyFromURLHeaders setClientRequestId(String clientRequestId) {
        this.clientRequestId = clientRequestId;
        return this;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public BlobCopyFromURLHeaders setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public BlobCopyFromURLHeaders setVersion(String version) {
        this.version = version;
        return this;
    }

    public OffsetDateTime getDateProperty() {
        if (this.dateProperty == null) {
            return null;
        }
        return this.dateProperty.getDateTime();
    }

    public BlobCopyFromURLHeaders setDateProperty(OffsetDateTime dateProperty) {
        this.dateProperty = dateProperty == null ? null : new DateTimeRfc1123(dateProperty);
        return this;
    }

    public String getCopyId() {
        return this.copyId;
    }

    public BlobCopyFromURLHeaders setCopyId(String copyId) {
        this.copyId = copyId;
        return this;
    }

    public SyncCopyStatusType getCopyStatus() {
        return this.copyStatus;
    }

    public BlobCopyFromURLHeaders setCopyStatus(SyncCopyStatusType copyStatus) {
        this.copyStatus = copyStatus;
        return this;
    }

    public byte[] getContentMD5() {
        return CoreUtils.clone((byte[])this.contentMD5);
    }

    public BlobCopyFromURLHeaders setContentMD5(byte[] contentMD5) {
        this.contentMD5 = CoreUtils.clone((byte[])contentMD5);
        return this;
    }

    public byte[] getXMsContentCrc64() {
        return CoreUtils.clone((byte[])this.xMsContentCrc64);
    }

    public BlobCopyFromURLHeaders setXMsContentCrc64(byte[] xMsContentCrc64) {
        this.xMsContentCrc64 = CoreUtils.clone((byte[])xMsContentCrc64);
        return this;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public BlobCopyFromURLHeaders setVersionId(String versionId) {
        this.versionId = versionId;
        return this;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public BlobCopyFromURLHeaders setErrorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }
}

