/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.nontagged.printers.json.clean;

import java.io.PrintStream;
import org.apache.asterix.formats.nontagged.CleanJSONPrinterFactoryProvider;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.hyracks.algebricks.data.IPrinter;
import org.apache.hyracks.algebricks.data.IPrinterFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class AOptionalFieldPrinterFactory
implements IPrinterFactory {
    private static final long serialVersionUID = 1L;
    private AUnionType unionType;

    public AOptionalFieldPrinterFactory(AUnionType unionType) {
        this.unionType = unionType;
    }

    public IPrinter createPrinter() {
        return new IPrinter(){
            private IPrinter nullPrinter;
            private IPrinter fieldPrinter;

            public void init() throws HyracksDataException {
                this.nullPrinter = CleanJSONPrinterFactoryProvider.INSTANCE.getPrinterFactory(BuiltinType.AMISSING).createPrinter();
                this.fieldPrinter = CleanJSONPrinterFactoryProvider.INSTANCE.getPrinterFactory(AOptionalFieldPrinterFactory.this.unionType.getActualType()).createPrinter();
            }

            public void print(byte[] b, int s, int l, PrintStream ps) throws HyracksDataException {
                this.fieldPrinter.init();
                if (b[s] == ATypeTag.SERIALIZED_NULL_TYPE_TAG || b[s] == ATypeTag.SERIALIZED_MISSING_TYPE_TAG) {
                    this.nullPrinter.print(b, s, l, ps);
                } else {
                    this.fieldPrinter.print(b, s, l, ps);
                }
            }
        };
    }
}

