/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.typecomputer.impl.ArrayRangeTypeComputer;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.functions.AbstractScalarEval;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.TaggedValuePointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class ArrayRangeEvaluator
extends AbstractScalarEval {
    private final OrderedListBuilder listBuilder;
    private final ArrayBackedValueStorage storage = new ArrayBackedValueStorage();
    private final IScalarEvaluator startNumEval;
    private final TaggedValuePointable start = new TaggedValuePointable();
    private final IScalarEvaluator endNumEval;
    private final TaggedValuePointable end = new TaggedValuePointable();
    private final AMutableDouble aDouble;
    private final AMutableInt64 aLong;
    private IScalarEvaluator stepNumEval;
    private TaggedValuePointable step;

    ArrayRangeEvaluator(IScalarEvaluatorFactory[] args, IEvaluatorContext ctx, SourceLocation sourceLocation, FunctionIdentifier functionIdentifier) throws HyracksDataException {
        super(sourceLocation, functionIdentifier);
        this.startNumEval = args[0].createScalarEvaluator(ctx);
        this.endNumEval = args[1].createScalarEvaluator(ctx);
        this.listBuilder = new OrderedListBuilder();
        this.aDouble = new AMutableDouble(0.0);
        this.aLong = new AMutableInt64(0L);
        if (args.length == 3) {
            this.stepNumEval = args[2].createScalarEvaluator(ctx);
            this.step = new TaggedValuePointable();
        }
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.startNumEval.evaluate(tuple, (IPointable)this.start);
        this.endNumEval.evaluate(tuple, (IPointable)this.end);
        if (this.stepNumEval != null) {
            this.stepNumEval.evaluate(tuple, (IPointable)this.step);
        }
        if (PointableHelper.checkAndSetMissingOrNull(result, (IPointable)this.start, (IPointable)this.end, (IPointable)this.step)) {
            return;
        }
        String n = this.funID.getName();
        ATypeTag startTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.start.getTag());
        ATypeTag endTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.end.getTag());
        ATypeTag stepTag = ATypeTag.INTEGER;
        double stepNum = 1.0;
        if (this.stepNumEval != null) {
            this.stepNumEval.evaluate(tuple, (IPointable)this.step);
            stepTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.step.getTag());
            if (!ATypeHierarchy.isCompatible((ATypeTag)ATypeTag.DOUBLE, (ATypeTag)stepTag)) {
                PointableHelper.setNull(result);
                return;
            }
            stepNum = ATypeHierarchy.getDoubleValue((String)n, (int)2, (byte[])this.step.getByteArray(), (int)this.step.getStartOffset());
        }
        if (!ATypeHierarchy.isCompatible((ATypeTag)ATypeTag.DOUBLE, (ATypeTag)startTag) || Double.isNaN(stepNum) || !ATypeHierarchy.isCompatible((ATypeTag)ATypeTag.DOUBLE, (ATypeTag)endTag) || Double.isInfinite(stepNum)) {
            PointableHelper.setNull(result);
            return;
        }
        if (ATypeHierarchy.canPromote((ATypeTag)startTag, (ATypeTag)ATypeTag.BIGINT) && ATypeHierarchy.canPromote((ATypeTag)endTag, (ATypeTag)ATypeTag.BIGINT) && ATypeHierarchy.canPromote((ATypeTag)stepTag, (ATypeTag)ATypeTag.BIGINT)) {
            ISerializerDeserializer serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
            long startNum = ATypeHierarchy.getLongValue((String)n, (int)0, (byte[])this.start.getByteArray(), (int)this.start.getStartOffset());
            long endNum = ATypeHierarchy.getLongValue((String)n, (int)1, (byte[])this.end.getByteArray(), (int)this.end.getStartOffset());
            this.listBuilder.reset((AbstractCollectionType)ArrayRangeTypeComputer.LONG_LIST);
            while (startNum < endNum && stepNum > 0.0 || startNum > endNum && stepNum < 0.0) {
                this.aLong.setValue(startNum);
                this.storage.reset();
                serde.serialize((Object)this.aLong, this.storage.getDataOutput());
                this.listBuilder.addItem((IValueReference)this.storage);
                startNum = (long)((double)startNum + stepNum);
            }
        } else {
            double startNum;
            ISerializerDeserializer serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADOUBLE);
            double endNum = ATypeHierarchy.getDoubleValue((String)n, (int)1, (byte[])this.end.getByteArray(), (int)this.end.getStartOffset());
            if (Double.isNaN(startNum) || Double.isInfinite(startNum) || Double.isNaN(endNum) || Double.isInfinite(endNum)) {
                PointableHelper.setNull(result);
                return;
            }
            this.listBuilder.reset((AbstractCollectionType)ArrayRangeTypeComputer.DOUBLE_LIST);
            for (startNum = ATypeHierarchy.getDoubleValue((String)n, (int)0, (byte[])this.start.getByteArray(), (int)this.start.getStartOffset()); startNum < endNum && stepNum > 0.0 || startNum > endNum && stepNum < 0.0; startNum += stepNum) {
                this.aDouble.setValue(startNum);
                this.storage.reset();
                serde.serialize((Object)this.aDouble, this.storage.getDataOutput());
                this.listBuilder.addItem((IValueReference)this.storage);
            }
        }
        this.storage.reset();
        this.listBuilder.write(this.storage.getDataOutput(), true);
        result.set((IValueReference)this.storage);
    }
}

