/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.api.IDataParser;
import org.apache.asterix.external.api.IRawRecord;
import org.apache.asterix.external.input.record.RecordWithPK;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.ADouble;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.base.AMutableString;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.data.parsers.IValueParser;

public class RecordWithMetadataAndPK<T>
extends RecordWithPK<T> {
    private final ArrayBackedValueStorage[] fieldValueBuffers;
    private final DataOutput[] fieldValueBufferOutputs;
    private final IValueParser[] valueParsers;
    private final byte[] fieldTypeTags;
    private final IAType[] metaTypes;
    private final ISerializerDeserializer<ADouble> doubleSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADOUBLE);
    private final AMutableDouble mutableDouble = new AMutableDouble(0.0);
    private final ISerializerDeserializer<AString> stringSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING);
    private final AMutableString mutableString = new AMutableString(null);
    private final ISerializerDeserializer<AInt32> int32Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT32);
    private final AMutableInt32 mutableInt = new AMutableInt32(0);
    protected ISerializerDeserializer<AInt64> int64Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
    private final AMutableInt64 mutableLong = new AMutableInt64(0L);
    private final ISerializerDeserializer<ABoolean> booleanSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ABOOLEAN);
    private final int[] keyIndicator;

    public RecordWithMetadataAndPK(IRawRecord<T> record, IAType[] metaTypes, ARecordType recordType, int[] keyIndicator, int[] pkIndexes, IAType[] keyTypes) {
        super(record, keyTypes, pkIndexes);
        this.metaTypes = metaTypes;
        this.fieldValueBuffers = new ArrayBackedValueStorage[metaTypes.length];
        this.fieldValueBufferOutputs = new DataOutput[metaTypes.length];
        this.valueParsers = new IValueParser[metaTypes.length];
        this.fieldTypeTags = new byte[metaTypes.length];
        for (int i = 0; i < metaTypes.length; ++i) {
            ATypeTag tag = metaTypes[i].getTypeTag();
            this.fieldTypeTags[i] = tag.serialize();
            this.fieldValueBuffers[i] = new ArrayBackedValueStorage();
            this.fieldValueBufferOutputs[i] = this.fieldValueBuffers[i].getDataOutput();
            this.valueParsers[i] = ExternalDataUtils.getParserFactory(tag).createValueParser();
        }
        this.keyIndicator = keyIndicator;
    }

    @Override
    public IRawRecord<T> getRecord() {
        return this.record;
    }

    public IAType[] getMetaTypes() {
        return this.metaTypes;
    }

    public ArrayBackedValueStorage getMetadata(int index) {
        return this.fieldValueBuffers[index];
    }

    @Override
    public void reset() {
        this.record.reset();
        for (ArrayBackedValueStorage fieldBuffer : this.fieldValueBuffers) {
            fieldBuffer.reset();
        }
    }

    public void setMetadata(int index, int value) throws IOException {
        this.fieldValueBufferOutputs[index].writeByte(this.fieldTypeTags[index]);
        this.mutableInt.setValue(value);
        IDataParser.toBytes(this.mutableInt, this.fieldValueBuffers[index], this.int32Serde);
    }

    public void setMetadata(int index, long value) throws IOException {
        this.fieldValueBufferOutputs[index].writeByte(this.fieldTypeTags[index]);
        this.mutableLong.setValue(value);
        IDataParser.toBytes(this.mutableLong, this.fieldValueBuffers[index], this.int64Serde);
    }

    public void setMetadata(int index, String value) throws IOException {
        this.fieldValueBufferOutputs[index].writeByte(this.fieldTypeTags[index]);
        this.mutableString.setValue(value);
        IDataParser.toBytes(this.mutableString, this.fieldValueBuffers[index], this.stringSerde);
    }

    public void setMetadata(int index, boolean value) throws IOException {
        this.fieldValueBufferOutputs[index].writeByte(this.fieldTypeTags[index]);
        IDataParser.toBytes(value ? ABoolean.TRUE : ABoolean.FALSE, this.fieldValueBuffers[index], this.booleanSerde);
    }

    public void setMetadata(int index, double value) throws IOException {
        this.fieldValueBufferOutputs[index].writeByte(this.fieldTypeTags[index]);
        this.mutableDouble.setValue(value);
        IDataParser.toBytes(this.mutableDouble, this.fieldValueBuffers[index], this.doubleSerde);
    }

    public void setRawMetadata(int index, char[] src, int offset, int length) throws IOException {
        if (length == 0) {
            if (!NonTaggedFormatUtil.isOptional((IAType)this.metaTypes[index])) {
                throw new RuntimeDataException(ErrorCode.INPUT_RECORD_RECORD_WITH_METADATA_AND_PK_NULL_IN_NON_OPTIONAL, new Serializable[]{Integer.valueOf(index)});
            }
            this.fieldValueBufferOutputs[index].writeByte(ATypeTag.SERIALIZED_NULL_TYPE_TAG);
        } else {
            this.fieldValueBufferOutputs[index].writeByte(this.fieldTypeTags[index]);
            if (!this.valueParsers[index].parse(src, offset, length, this.fieldValueBufferOutputs[index])) {
                throw new RuntimeDataException(ErrorCode.FAILED_TO_PARSE_METADATA, new Serializable[0]);
            }
        }
    }

    @Override
    public void appendPrimaryKeyToTuple(ArrayTupleBuilder tb) throws HyracksDataException {
        for (int i = 0; i < this.pkIndexes.length; ++i) {
            if (this.keyIndicator[i] != 1) {
                throw new RuntimeDataException(ErrorCode.INPUT_RECORD_RECORD_WITH_METADATA_AND_PK_CANNT_GET_PKEY, new Serializable[0]);
            }
            tb.addField((IValueReference)this.getMetadata(this.pkIndexes[i]));
        }
    }

    @Override
    public byte[] getBytes() {
        return this.record.getBytes();
    }

    @Override
    public T get() {
        return this.record.get();
    }

    @Override
    public int size() {
        return this.record.size();
    }

    @Override
    public void set(T t) {
        this.record.set(t);
    }
}

