/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.OrderColumn;
import org.apache.hyracks.dataflow.common.data.partition.range.RangeMap;

abstract class AbstractOrderedPartitionedProperty
implements IPartitioningProperty {
    protected final List<OrderColumn> orderColumns;
    protected final RangeMap rangeMap;
    protected INodeDomain domain;

    AbstractOrderedPartitionedProperty(List<OrderColumn> orderColumns, INodeDomain domain) {
        this(orderColumns, domain, null);
    }

    AbstractOrderedPartitionedProperty(List<OrderColumn> orderColumns, INodeDomain domain, RangeMap rangeMap) {
        this.orderColumns = orderColumns;
        this.domain = domain;
        this.rangeMap = rangeMap;
    }

    public List<OrderColumn> getOrderColumns() {
        return this.orderColumns;
    }

    public List<LogicalVariable> getColumns() {
        ArrayList<LogicalVariable> cols = new ArrayList<LogicalVariable>(this.orderColumns.size());
        for (OrderColumn oc : this.orderColumns) {
            cols.add(oc.getColumn());
        }
        return cols;
    }

    public String toString() {
        return this.getPartitioningType().toString() + this.orderColumns + " domain:" + this.domain + (this.rangeMap != null ? " range-map:" + this.rangeMap : "");
    }

    @Override
    public void getColumns(Collection<LogicalVariable> columns) {
        for (OrderColumn oc : this.orderColumns) {
            columns.add(oc.getColumn());
        }
    }

    public RangeMap getRangeMap() {
        return this.rangeMap;
    }

    @Override
    public INodeDomain getNodeDomain() {
        return this.domain;
    }

    @Override
    public void setNodeDomain(INodeDomain domain) {
        this.domain = domain;
    }

    @Override
    public IPartitioningProperty substituteColumnVars(Map<LogicalVariable, LogicalVariable> varMap) {
        boolean applied = false;
        ArrayList<OrderColumn> newOrderColumns = new ArrayList<OrderColumn>(this.orderColumns.size());
        for (OrderColumn orderColumn : this.orderColumns) {
            LogicalVariable columnVar = orderColumn.getColumn();
            LogicalVariable newColumnVar = varMap.get(columnVar);
            if (newColumnVar != null) {
                applied = true;
            } else {
                newColumnVar = columnVar;
            }
            newOrderColumns.add(new OrderColumn(newColumnVar, orderColumn.getOrder()));
        }
        return applied ? this.newInstance(newOrderColumns, this.domain, this.rangeMap) : this;
    }

    @Override
    public IPartitioningProperty clonePartitioningProperty() {
        return this.newInstance(new ArrayList<OrderColumn>(this.orderColumns), this.domain, this.rangeMap);
    }

    protected abstract AbstractOrderedPartitionedProperty newInstance(List<OrderColumn> var1, INodeDomain var2, RangeMap var3);
}

