/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.result;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.hyracks.api.comm.NetworkAddress;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.api.job.JobStatus;
import org.apache.hyracks.api.result.IJobResultCallback;
import org.apache.hyracks.api.result.IResultManager;
import org.apache.hyracks.api.result.IResultMetadata;
import org.apache.hyracks.api.result.IResultStateRecord;
import org.apache.hyracks.api.result.ResultDirectoryRecord;
import org.apache.hyracks.api.result.ResultJobRecord;
import org.apache.hyracks.api.result.ResultSetId;
import org.apache.hyracks.api.result.ResultSetMetaData;
import org.apache.hyracks.control.cc.result.IResultDirectoryService;
import org.apache.hyracks.control.cc.result.JobResultInfo;
import org.apache.hyracks.control.cc.result.Waiter;
import org.apache.hyracks.control.common.result.AbstractResultManager;
import org.apache.hyracks.control.common.result.ResultStateSweeper;
import org.apache.hyracks.control.common.work.IResultCallback;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResultDirectoryService
extends AbstractResultManager
implements IResultDirectoryService {
    private static final Logger LOGGER = LogManager.getLogger();
    private final long resultSweepThreshold;
    private final Map<JobId, JobResultInfo> jobResultLocations;
    private IJobResultCallback jobResultCallback;

    public ResultDirectoryService(long resultTTL, long resultSweepThreshold) {
        super(resultTTL);
        this.resultSweepThreshold = resultSweepThreshold;
        this.jobResultLocations = new LinkedHashMap<JobId, JobResultInfo>();
    }

    @Override
    public void init(ExecutorService executor, IJobResultCallback jobResultCallback) {
        executor.execute((Runnable)new ResultStateSweeper((IResultManager)this, this.resultSweepThreshold, LOGGER));
        this.jobResultCallback = jobResultCallback;
    }

    public synchronized void notifyJobCreation(JobId jobId, JobSpecification spec) throws HyracksException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(this.getClass().getSimpleName() + " notified of new job " + jobId);
        }
        if (this.jobResultLocations.get(jobId) != null) {
            throw HyracksDataException.create((int)15, (Serializable[])new Serializable[]{jobId});
        }
        this.jobResultLocations.put(jobId, new JobResultInfo(new ResultJobRecord(), null));
    }

    public synchronized void notifyJobStart(JobId jobId) throws HyracksException {
        this.jobResultLocations.get(jobId).getRecord().start();
    }

    public void notifyJobFinish(JobId jobId, JobStatus jobStatus, List<Exception> exceptions) throws HyracksException {
        if (exceptions == null || exceptions.isEmpty()) {
            ResultJobRecord resultJobRecord = this.getResultJobRecord(jobId);
            if (resultJobRecord == null) {
                return;
            }
            resultJobRecord.finish();
            this.jobResultCallback.completed(jobId, resultJobRecord);
        }
    }

    private ResultJobRecord getResultJobRecord(JobId jobId) {
        JobResultInfo jri = this.jobResultLocations.get(jobId);
        return jri == null ? null : jri.getRecord();
    }

    private ResultJobRecord getNonNullResultJobRecord(JobId jobId) throws HyracksDataException {
        ResultJobRecord djr = this.getResultJobRecord(jobId);
        if (djr == null) {
            throw HyracksDataException.create((int)24, (Serializable[])new Serializable[]{jobId});
        }
        return djr;
    }

    @Override
    public synchronized void registerResultPartitionLocation(JobId jobId, ResultSetId rsId, IResultMetadata metadata, boolean emptyResult, int partition, int nPartitions, NetworkAddress networkAddress) throws HyracksDataException {
        ResultJobRecord djr = this.getNonNullResultJobRecord(jobId);
        djr.setResultSetMetaData(rsId, metadata, nPartitions);
        ResultDirectoryRecord record = djr.getOrCreateDirectoryRecord(partition);
        record.setNetworkAddress(networkAddress);
        record.setEmpty(emptyResult);
        record.start();
        JobResultInfo jobResultInfo = this.jobResultLocations.get(jobId);
        Waiter waiter = jobResultInfo.getWaiter(rsId);
        if (waiter != null) {
            try {
                ResultDirectoryRecord[] updatedRecords = this.updatedRecords(jobId, rsId, waiter.knownRecords);
                if (updatedRecords != null) {
                    jobResultInfo.removeWaiter(rsId);
                    waiter.callback.setValue((Object)updatedRecords);
                }
            }
            catch (Exception e) {
                waiter.callback.setException(e);
            }
        }
        this.notifyAll();
    }

    @Override
    public synchronized void reportResultPartitionWriteCompletion(JobId jobId, ResultSetId rsId, int partition) throws HyracksDataException {
        ResultJobRecord djr = this.getNonNullResultJobRecord(jobId);
        djr.getDirectoryRecord(partition).writeEOS();
        djr.updateState();
        this.notifyAll();
    }

    @Override
    public synchronized void reportJobFailure(JobId jobId, List<Exception> exceptions) {
        JobResultInfo jobResultInfo;
        ResultJobRecord rjr;
        Exception ex = exceptions.isEmpty() ? null : exceptions.get(0);
        Level logLevel = Level.DEBUG;
        if (LOGGER.isEnabled(logLevel)) {
            LOGGER.log(logLevel, "job " + jobId + " failed and is being reported to " + this.getClass().getSimpleName(), (Throwable)ex);
        }
        if ((rjr = this.getResultJobRecord(jobId)) != null) {
            rjr.fail(exceptions);
        }
        if ((jobResultInfo = this.jobResultLocations.get(jobId)) != null) {
            jobResultInfo.setException(ex);
        }
        this.notifyAll();
    }

    @Override
    public synchronized ResultJobRecord.Status getResultStatus(JobId jobId, ResultSetId rsId) throws HyracksDataException {
        return this.getNonNullResultJobRecord(jobId).getStatus();
    }

    @Override
    public synchronized IResultMetadata getResultMetadata(JobId jobId, ResultSetId rsId) throws HyracksDataException {
        return this.getNonNullResultJobRecord(jobId).getResultSetMetaData().getMetadata();
    }

    public synchronized Set<JobId> getJobIds() {
        return this.jobResultLocations.keySet();
    }

    public IResultStateRecord getState(JobId jobId) {
        return this.getResultJobRecord(jobId);
    }

    public synchronized void sweep(JobId jobId) {
        this.jobResultLocations.remove(jobId);
    }

    @Override
    public synchronized void getResultPartitionLocations(JobId jobId, ResultSetId rsId, ResultDirectoryRecord[] knownRecords, IResultCallback<ResultDirectoryRecord[]> callback) throws HyracksDataException {
        ResultDirectoryRecord[] updatedRecords = this.updatedRecords(jobId, rsId, knownRecords);
        if (updatedRecords == null) {
            this.jobResultLocations.get(jobId).addWaiter(rsId, knownRecords, callback);
        } else {
            callback.setValue((Object)updatedRecords);
        }
    }

    private ResultDirectoryRecord[] updatedRecords(JobId jobId, ResultSetId rsId, ResultDirectoryRecord[] knownRecords) throws HyracksDataException {
        ResultJobRecord djr = this.getNonNullResultJobRecord(jobId);
        if (djr.getStatus().getState() == ResultJobRecord.State.FAILED) {
            List caughtExceptions = djr.getStatus().getExceptions();
            if (caughtExceptions != null && !caughtExceptions.isEmpty()) {
                Exception cause = (Exception)caughtExceptions.get(caughtExceptions.size() - 1);
                if (cause instanceof HyracksDataException) {
                    throw (HyracksDataException)((Object)cause);
                }
                throw HyracksDataException.create((int)16, (Throwable)cause, (Serializable[])new Serializable[]{rsId, jobId});
            }
            throw HyracksDataException.create((int)17, (Serializable[])new Serializable[]{rsId, jobId});
        }
        ResultSetMetaData resultSetMetaData = djr.getResultSetMetaData();
        if (resultSetMetaData == null) {
            return null;
        }
        Object[] records = resultSetMetaData.getRecords();
        return Arrays.equals(records, knownRecords) ? null : records;
    }

    public PrintWriter print(PrintWriter pw) {
        for (JobId jId : this.getJobIds()) {
            pw.print(jId.toString());
            pw.print(" - ");
            pw.println(this.getResultJobRecord(jId));
        }
        pw.flush();
        return pw;
    }
}

