/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.aql.visitor;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.aql.clause.DistinctClause;
import org.apache.asterix.lang.aql.clause.ForClause;
import org.apache.asterix.lang.aql.expression.FLWOGRExpression;
import org.apache.asterix.lang.aql.expression.UnionExpr;
import org.apache.asterix.lang.aql.visitor.base.IAQLVisitor;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.expression.GbyVariableExpressionPair;
import org.apache.asterix.lang.common.expression.ListSliceExpression;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.visitor.QueryPrintVisitor;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;

class AQLAstPrintVisitor
extends QueryPrintVisitor
implements IAQLVisitor<Void, Integer> {
    public AQLAstPrintVisitor(PrintWriter out) {
        super(out);
    }

    @Override
    public Void visit(FLWOGRExpression flwor, Integer step) throws CompilationException {
        this.out.println(this.skip(step) + "FLWOGR [");
        for (Clause cl : flwor.getClauseList()) {
            cl.accept((ILangVisitor)this, (Object)(step + 1));
        }
        this.out.println(this.skip(step + 1) + "Return");
        flwor.getReturnExpr().accept((ILangVisitor)this, (Object)(step + 2));
        this.out.println(this.skip(step) + "]");
        return null;
    }

    @Override
    public Void visit(ForClause fc, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "For ");
        fc.getVarExpr().accept((ILangVisitor)this, (Object)0);
        this.out.println(this.skip(step + 1) + "In ");
        fc.getInExpr().accept((ILangVisitor)this, (Object)(step + 1));
        return null;
    }

    @Override
    public Void visit(UnionExpr u, Integer step) throws CompilationException {
        this.out.println(this.skip(step) + "Union [");
        for (Expression expr : u.getExprs()) {
            expr.accept((ILangVisitor)this, (Object)(step + 1));
        }
        this.out.println(this.skip(step) + "]");
        return null;
    }

    @Override
    public Void visit(DistinctClause dc, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "Distinct ");
        for (Expression expr : dc.getDistinctByExpr()) {
            expr.accept((ILangVisitor)this, (Object)(step + 1));
        }
        return null;
    }

    public Void visit(ListSliceExpression expression, Integer step) throws CompilationException {
        return null;
    }

    public Void visit(GroupbyClause gc, Integer step) throws CompilationException {
        this.out.println(this.skip(step) + "Groupby");
        List gbyList = gc.getGbyPairList();
        if (gbyList.size() == 1) {
            for (GbyVariableExpressionPair gbyVariableExpressionPair : (List)gbyList.get(0)) {
                if (gbyVariableExpressionPair.getVar() != null) {
                    gbyVariableExpressionPair.getVar().accept((ILangVisitor)this, (Object)(step + 1));
                    this.out.println(this.skip(step + 1) + ":=");
                }
                gbyVariableExpressionPair.getExpr().accept((ILangVisitor)this, (Object)(step + 1));
            }
        } else {
            throw new CompilationException(1038, gc.getSourceLocation(), new Serializable[]{""});
        }
        if (gc.hasDecorList()) {
            this.out.println(this.skip(step + 1) + "Decor");
            for (GbyVariableExpressionPair gbyVariableExpressionPair : gc.getDecorPairList()) {
                if (gbyVariableExpressionPair.getVar() != null) {
                    gbyVariableExpressionPair.getVar().accept((ILangVisitor)this, (Object)(step + 1));
                    this.out.println(this.skip(step + 1) + ":=");
                }
                gbyVariableExpressionPair.getExpr().accept((ILangVisitor)this, (Object)(step + 1));
            }
        }
        if (gc.hasWithMap()) {
            this.out.println(this.skip(step + 1) + "With");
            for (Map.Entry entry : gc.getWithVarMap().entrySet()) {
                Expression key = (Expression)entry.getKey();
                VariableExpr value = (VariableExpr)entry.getValue();
                key.accept((ILangVisitor)this, (Object)(step + 1));
                if (key.equals(value)) continue;
                this.out.println(this.skip(step + 1) + "AS");
                value.accept((ILangVisitor)this, (Object)(step + 1));
            }
        }
        this.out.println();
        return null;
    }
}

