/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.parser;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import org.apache.asterix.builders.IARecordBuilder;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.builders.UnorderedListBuilder;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.api.IRawRecord;
import org.apache.asterix.external.api.IRecordDataParser;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.util.string.UTF8StringWriter;

public class HiveRecordParser
implements IRecordDataParser<Writable> {
    private ARecordType recordType;
    private SerDe hiveSerde;
    private StructObjectInspector oi;
    private IARecordBuilder recBuilder;
    private ArrayBackedValueStorage fieldValueBuffer;
    private ArrayBackedValueStorage listItemBuffer;
    private byte[] fieldTypeTags;
    private IAType[] fieldTypes;
    private OrderedListBuilder orderedListBuilder;
    private UnorderedListBuilder unorderedListBuilder;
    private List<? extends StructField> fieldRefs;
    private UTF8StringWriter utf8Writer = new UTF8StringWriter();

    public HiveRecordParser(ARecordType recordType, JobConf hadoopConfiguration, String hiveSerdeClassName) throws HyracksDataException {
        try {
            this.recordType = recordType;
            int n = recordType.getFieldNames().length;
            this.fieldTypes = recordType.getFieldTypes();
            Properties tbl = new Properties();
            tbl.put("columns", this.getCommaDelimitedColNames(this.recordType));
            tbl.put("columns.types", this.getColTypes(this.recordType));
            this.hiveSerde = (SerDe)Class.forName(hiveSerdeClassName).newInstance();
            this.hiveSerde.initialize((Configuration)hadoopConfiguration, tbl);
            this.oi = (StructObjectInspector)this.hiveSerde.getObjectInspector();
            this.fieldValueBuffer = new ArrayBackedValueStorage();
            this.recBuilder = new RecordBuilder();
            this.recBuilder.reset(recordType);
            this.recBuilder.init();
            this.fieldTypeTags = new byte[n];
            for (int i = 0; i < n; ++i) {
                ATypeTag tag = recordType.getFieldTypes()[i].getTypeTag();
                this.fieldTypeTags[i] = tag.serialize();
            }
            this.fieldRefs = this.oi.getAllStructFieldRefs();
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    @Override
    public boolean parse(IRawRecord<? extends Writable> record, DataOutput out) throws HyracksDataException {
        try {
            Writable hiveRawRecord = record.get();
            Object hiveObject = this.hiveSerde.deserialize(hiveRawRecord);
            int n = this.recordType.getFieldNames().length;
            List attributesValues = this.oi.getStructFieldsDataAsList(hiveObject);
            this.recBuilder.reset(this.recordType);
            this.recBuilder.init();
            for (int i = 0; i < n; ++i) {
                Object value = attributesValues.get(i);
                ObjectInspector foi = this.fieldRefs.get(i).getFieldObjectInspector();
                this.fieldValueBuffer.reset();
                DataOutput dataOutput = this.fieldValueBuffer.getDataOutput();
                dataOutput.writeByte(this.fieldTypeTags[i]);
                this.parseItem(this.fieldTypes[i], value, foi, dataOutput, false);
                this.recBuilder.addField(i, (IValueReference)this.fieldValueBuffer);
            }
            this.recBuilder.write(out, true);
            return true;
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private void parseItem(IAType itemType, Object value, ObjectInspector foi, DataOutput dataOutput, boolean primitiveOnly) throws HyracksDataException {
        try {
            switch (itemType.getTypeTag()) {
                case BOOLEAN: {
                    this.parseBoolean(value, (BooleanObjectInspector)foi, dataOutput);
                    break;
                }
                case TIME: {
                    this.parseTime(value, (TimestampObjectInspector)foi, dataOutput);
                    break;
                }
                case DATE: {
                    this.parseDate(value, (TimestampObjectInspector)foi, dataOutput);
                    break;
                }
                case DATETIME: {
                    this.parseDateTime(value, (TimestampObjectInspector)foi, dataOutput);
                    break;
                }
                case DOUBLE: {
                    this.parseDouble(value, (DoubleObjectInspector)foi, dataOutput);
                    break;
                }
                case FLOAT: {
                    this.parseFloat(value, (FloatObjectInspector)foi, dataOutput);
                    break;
                }
                case TINYINT: {
                    this.parseInt8(value, (ByteObjectInspector)foi, dataOutput);
                    break;
                }
                case SMALLINT: {
                    this.parseInt16(value, (ShortObjectInspector)foi, dataOutput);
                    break;
                }
                case INTEGER: {
                    this.parseInt32(value, (IntObjectInspector)foi, dataOutput);
                    break;
                }
                case BIGINT: {
                    this.parseInt64(value, (LongObjectInspector)foi, dataOutput);
                    break;
                }
                case STRING: {
                    this.parseString(value, (StringObjectInspector)foi, dataOutput);
                    break;
                }
                case ARRAY: {
                    if (primitiveOnly) {
                        throw new RuntimeDataException(3010, new Serializable[0]);
                    }
                    this.parseOrderedList((AOrderedListType)itemType, value, (ListObjectInspector)foi);
                    break;
                }
                case MULTISET: {
                    if (primitiveOnly) {
                        throw new RuntimeDataException(3010, new Serializable[0]);
                    }
                    this.parseUnorderedList((AUnorderedListType)itemType, value, (ListObjectInspector)foi);
                    break;
                }
                default: {
                    throw new RuntimeDataException(3011, new Serializable[]{itemType.getTypeTag()});
                }
            }
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private Object getColTypes(ARecordType record) throws HyracksDataException {
        int n = record.getFieldTypes().length;
        if (n < 1) {
            throw new RuntimeDataException(3012, new Serializable[0]);
        }
        String cols = this.getHiveTypeString(record.getFieldTypes(), 0);
        for (int i = 1; i < n; ++i) {
            cols = cols + "," + this.getHiveTypeString(record.getFieldTypes(), i);
        }
        return cols;
    }

    private String getCommaDelimitedColNames(ARecordType record) throws HyracksDataException {
        if (record.getFieldNames().length < 1) {
            throw new RuntimeDataException(3013, new Serializable[0]);
        }
        String cols = record.getFieldNames()[0];
        for (int i = 1; i < record.getFieldNames().length; ++i) {
            cols = cols + "," + record.getFieldNames()[i];
        }
        return cols;
    }

    private String getHiveTypeString(IAType[] types, int i) throws HyracksDataException {
        IAType type = types[i];
        ATypeTag tag = type.getTypeTag();
        if (tag == ATypeTag.UNION) {
            if (NonTaggedFormatUtil.isOptional((IAType)type)) {
                throw new RuntimeDataException(3014, new Serializable[0]);
            }
            tag = ((AUnionType)type).getActualType().getTypeTag();
        }
        if (tag == null) {
            throw new RuntimeDataException(3015, new Serializable[]{Integer.valueOf(i)});
        }
        switch (tag) {
            case BOOLEAN: {
                return "boolean";
            }
            case DATE: {
                return "date";
            }
            case DATETIME: {
                return "datetime";
            }
            case DOUBLE: {
                return "double";
            }
            case FLOAT: {
                return "float";
            }
            case SMALLINT: {
                return "smallint";
            }
            case INTEGER: {
                return "int";
            }
            case BIGINT: {
                return "bigint";
            }
            case TINYINT: {
                return "tinyint";
            }
            case ARRAY: {
                return "array";
            }
            case STRING: {
                return "string";
            }
            case TIME: {
                return "datetime";
            }
            case MULTISET: {
                return "array";
            }
        }
        throw new RuntimeDataException(3011, new Serializable[]{tag});
    }

    private void parseInt64(Object obj, LongObjectInspector foi, DataOutput dataOutput) throws IOException {
        dataOutput.writeLong(foi.get(obj));
    }

    private void parseInt32(Object obj, IntObjectInspector foi, DataOutput dataOutput) throws IOException {
        if (obj == null) {
            throw new RuntimeDataException(3016, new Serializable[0]);
        }
        dataOutput.writeInt(foi.get(obj));
    }

    private void parseInt16(Object obj, ShortObjectInspector foi, DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(foi.get(obj));
    }

    private void parseFloat(Object obj, FloatObjectInspector foi, DataOutput dataOutput) throws IOException {
        dataOutput.writeFloat(foi.get(obj));
    }

    private void parseDouble(Object obj, DoubleObjectInspector foi, DataOutput dataOutput) throws IOException {
        dataOutput.writeDouble(foi.get(obj));
    }

    private void parseDateTime(Object obj, TimestampObjectInspector foi, DataOutput dataOutput) throws IOException {
        dataOutput.writeLong(foi.getPrimitiveJavaObject(obj).getTime());
    }

    private void parseDate(Object obj, TimestampObjectInspector foi, DataOutput dataOutput) throws IOException {
        long chrononTimeInMs = foi.getPrimitiveJavaObject(obj).getTime();
        int temp = 0;
        if (chrononTimeInMs < 0L && chrononTimeInMs % 86400000L != 0L) {
            temp = 1;
        }
        dataOutput.writeInt((int)(chrononTimeInMs / 86400000L) - temp);
    }

    private void parseBoolean(Object obj, BooleanObjectInspector foi, DataOutput dataOutput) throws IOException {
        dataOutput.writeBoolean(foi.get(obj));
    }

    private void parseInt8(Object obj, ByteObjectInspector foi, DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(foi.get(obj));
    }

    private void parseString(Object obj, StringObjectInspector foi, DataOutput dataOutput) throws IOException {
        this.utf8Writer.writeUTF8((CharSequence)foi.getPrimitiveJavaObject(obj), dataOutput);
    }

    private void parseTime(Object obj, TimestampObjectInspector foi, DataOutput dataOutput) throws IOException {
        dataOutput.writeInt((int)(foi.getPrimitiveJavaObject(obj).getTime() % 86400000L));
    }

    private void parseOrderedList(AOrderedListType aOrderedListType, Object obj, ListObjectInspector foi) throws HyracksDataException {
        OrderedListBuilder orderedListBuilder = this.getOrderedListBuilder();
        IAType itemType = null;
        if (aOrderedListType != null) {
            itemType = aOrderedListType.getItemType();
        }
        orderedListBuilder.reset((AbstractCollectionType)aOrderedListType);
        int n = foi.getListLength(obj);
        for (int i = 0; i < n; ++i) {
            Object element = foi.getListElement(obj, i);
            ObjectInspector eoi = foi.getListElementObjectInspector();
            if (element == null) {
                throw new RuntimeDataException(3017, new Serializable[0]);
            }
            this.parseItem(itemType, element, eoi, this.listItemBuffer.getDataOutput(), true);
            orderedListBuilder.addItem((IValueReference)this.listItemBuffer);
        }
        orderedListBuilder.write(this.fieldValueBuffer.getDataOutput(), true);
    }

    private void parseUnorderedList(AUnorderedListType uoltype, Object obj, ListObjectInspector oi) throws IOException {
        UnorderedListBuilder unorderedListBuilder = this.getUnorderedListBuilder();
        IAType itemType = null;
        if (uoltype != null) {
            itemType = uoltype.getItemType();
        }
        byte tagByte = itemType.getTypeTag().serialize();
        unorderedListBuilder.reset((AbstractCollectionType)uoltype);
        int n = oi.getListLength(obj);
        for (int i = 0; i < n; ++i) {
            Object element = oi.getListElement(obj, i);
            ObjectInspector eoi = oi.getListElementObjectInspector();
            if (element == null) {
                throw new RuntimeDataException(3017, new Serializable[0]);
            }
            this.listItemBuffer.reset();
            DataOutput dataOutput = this.listItemBuffer.getDataOutput();
            dataOutput.writeByte(tagByte);
            this.parseItem(itemType, element, eoi, dataOutput, true);
            unorderedListBuilder.addItem((IValueReference)this.listItemBuffer);
        }
        unorderedListBuilder.write(this.fieldValueBuffer.getDataOutput(), true);
    }

    private OrderedListBuilder getOrderedListBuilder() {
        if (this.orderedListBuilder != null) {
            return this.orderedListBuilder;
        }
        this.orderedListBuilder = new OrderedListBuilder();
        return this.orderedListBuilder;
    }

    private UnorderedListBuilder getUnorderedListBuilder() {
        if (this.unorderedListBuilder != null) {
            return this.unorderedListBuilder;
        }
        this.unorderedListBuilder = new UnorderedListBuilder();
        return this.unorderedListBuilder;
    }
}

