/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.library;

import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.WarningUtil;
import org.apache.asterix.common.library.ILibraryManager;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.external.ipc.ExternalFunctionResultRouter;
import org.apache.asterix.external.ipc.PythonIPCProto;
import org.apache.asterix.external.library.ExternalScalarFunctionEvaluator;
import org.apache.asterix.external.library.PythonLibrary;
import org.apache.asterix.external.library.msgpack.MessagePackerFromADM;
import org.apache.asterix.external.library.msgpack.MessageUnpackerToADM;
import org.apache.asterix.om.functions.IExternalFunctionInfo;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.TypeTagUtil;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.config.IApplicationConfig;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.TaskAttemptId;
import org.apache.hyracks.api.dataflow.state.IStateObject;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.resources.IDeallocatable;
import org.apache.hyracks.control.common.controllers.NCConfig;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.TaggedValuePointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.dataflow.std.base.AbstractStateObject;
import org.apache.hyracks.ipc.impl.IPCSystem;

class ExternalScalarPythonFunctionEvaluator
extends ExternalScalarFunctionEvaluator {
    private final PythonLibraryEvaluator libraryEvaluator;
    private final ArrayBackedValueStorage resultBuffer = new ArrayBackedValueStorage();
    private final ByteBuffer argHolder;
    private final ByteBuffer outputWrapper;
    private final IEvaluatorContext evaluatorContext;
    private static final String ENTRYPOINT = "entrypoint.py";
    private static final String SITE_PACKAGES = "site-packages";
    private final IPointable[] argValues;

    ExternalScalarPythonFunctionEvaluator(IExternalFunctionInfo finfo, IScalarEvaluatorFactory[] args, IAType[] argTypes, IEvaluatorContext ctx, SourceLocation sourceLoc) throws HyracksDataException {
        super(finfo, args, argTypes, ctx);
        int i;
        String[] pythonArgsRaw;
        IApplicationConfig cfg = ctx.getServiceContext().getAppConfig();
        String pythonPathCmd = cfg.getString((IOption)NCConfig.Option.PYTHON_CMD);
        ArrayList<String> pythonArgs = new ArrayList<String>();
        if (pythonPathCmd == null) {
            pythonPathCmd = "/usr/bin/env";
            pythonArgs.add("python3");
        }
        File pythonPath = new File(pythonPathCmd);
        ArrayList<String> sitePkgs = new ArrayList<String>();
        sitePkgs.add(SITE_PACKAGES);
        String[] addlSitePackages = ctx.getServiceContext().getAppConfig().getStringArray((IOption)NCConfig.Option.PYTHON_ADDITIONAL_PACKAGES);
        sitePkgs.addAll(Arrays.asList(addlSitePackages));
        if (cfg.getBoolean((IOption)NCConfig.Option.PYTHON_USE_BUNDLED_MSGPACK)) {
            sitePkgs.add("ipc" + File.separator + SITE_PACKAGES + File.separator);
        }
        if ((pythonArgsRaw = ctx.getServiceContext().getAppConfig().getStringArray((IOption)NCConfig.Option.PYTHON_ARGS)) != null) {
            pythonArgs.addAll(Arrays.asList(pythonArgsRaw));
        }
        StringBuilder sitePackagesPathBuilder = new StringBuilder();
        for (i = 0; i < sitePkgs.size() - 1; ++i) {
            sitePackagesPathBuilder.append((String)sitePkgs.get(i));
            sitePackagesPathBuilder.append(File.pathSeparator);
        }
        sitePackagesPathBuilder.append((String)sitePkgs.get(sitePkgs.size() - 1));
        try {
            this.libraryEvaluator = PythonLibraryEvaluator.getInstance(finfo, this.libraryManager, this.router, this.ipcSys, pythonPath, ctx.getTaskContext(), sitePackagesPathBuilder.toString(), pythonArgs, ctx.getWarningCollector(), sourceLoc);
        }
        catch (IOException | AsterixException e) {
            throw new HyracksDataException("Failed to initialize Python", e);
        }
        this.argValues = new IPointable[args.length];
        for (i = 0; i < this.argValues.length; ++i) {
            this.argValues[i] = VoidPointable.FACTORY.createPointable();
        }
        this.argHolder = ByteBuffer.wrap(new byte[65534]);
        this.outputWrapper = ByteBuffer.wrap(new byte[65534]);
        this.evaluatorContext = ctx;
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.argHolder.clear();
        int ln = this.argEvals.length;
        for (int i = 0; i < ln; ++i) {
            this.argEvals[i].evaluate(tuple, this.argValues[i]);
            try {
                this.setArgument(i, (IValueReference)this.argValues[i]);
                continue;
            }
            catch (IOException e) {
                throw new HyracksDataException("Error evaluating Python UDF", (Throwable)e);
            }
        }
        try {
            ByteBuffer res = this.libraryEvaluator.callPython(this.argHolder, this.argTypes.length);
            this.resultBuffer.reset();
            this.wrap(res, this.resultBuffer.getDataOutput());
        }
        catch (Exception e) {
            throw new HyracksDataException("Error evaluating Python UDF", (Throwable)e);
        }
        result.set(this.resultBuffer.getByteArray(), this.resultBuffer.getStartOffset(), this.resultBuffer.getLength());
    }

    private void setArgument(int index, IValueReference valueReference) throws IOException {
        IAType type = this.argTypes[index];
        ATypeTag tag = type.getTypeTag();
        switch (tag) {
            case ANY: {
                TaggedValuePointable pointy = TaggedValuePointable.FACTORY.createPointable();
                pointy.set(valueReference);
                ATypeTag rtTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(pointy.getTag());
                IAType rtType = TypeTagUtil.getBuiltinTypeByTag((ATypeTag)rtTypeTag);
                MessagePackerFromADM.pack(valueReference, rtType, this.argHolder);
                break;
            }
            default: {
                MessagePackerFromADM.pack(valueReference, type, this.argHolder);
            }
        }
    }

    private void wrap(ByteBuffer resultWrapper, DataOutput out) throws HyracksDataException {
        this.outputWrapper.clear();
        this.outputWrapper.position(0);
        MessageUnpackerToADM.unpack(resultWrapper, this.outputWrapper, true);
        try {
            out.write(this.outputWrapper.array(), 0, this.outputWrapper.position() + this.outputWrapper.arrayOffset());
        }
        catch (IOException e) {
            throw new HyracksDataException(e.getMessage());
        }
    }

    private static final class PythonLibraryEvaluatorId {
        private final DataverseName libraryDataverseName;
        private final String libraryName;

        private PythonLibraryEvaluatorId(DataverseName libraryDataverseName, String libraryName) {
            this.libraryDataverseName = Objects.requireNonNull(libraryDataverseName);
            this.libraryName = Objects.requireNonNull(libraryName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PythonLibraryEvaluatorId that = (PythonLibraryEvaluatorId)o;
            return this.libraryDataverseName.equals((Object)that.libraryDataverseName) && this.libraryName.equals(that.libraryName);
        }

        public int hashCode() {
            return Objects.hash(this.libraryDataverseName, this.libraryName);
        }
    }

    private static class PythonLibraryEvaluator
    extends AbstractStateObject
    implements IDeallocatable {
        Process p;
        IExternalFunctionInfo finfo;
        ILibraryManager libMgr;
        File pythonHome;
        PythonIPCProto proto;
        ExternalFunctionResultRouter router;
        IPCSystem ipcSys;
        String module;
        String clazz;
        String fn;
        String sitePkgs;
        List<String> pythonArgs;
        TaskAttemptId task;
        IWarningCollector warningCollector;
        SourceLocation sourceLoc;

        private PythonLibraryEvaluator(JobId jobId, PythonLibraryEvaluatorId evaluatorId, IExternalFunctionInfo finfo, ILibraryManager libMgr, File pythonHome, String sitePkgs, List<String> pythonArgs, ExternalFunctionResultRouter router, IPCSystem ipcSys, TaskAttemptId task, IWarningCollector warningCollector, SourceLocation sourceLoc) {
            super(jobId, (Object)evaluatorId);
            this.finfo = finfo;
            this.libMgr = libMgr;
            this.pythonHome = pythonHome;
            this.sitePkgs = sitePkgs;
            this.pythonArgs = pythonArgs;
            this.router = router;
            this.task = task;
            this.ipcSys = ipcSys;
            this.warningCollector = warningCollector;
            this.sourceLoc = sourceLoc;
        }

        public void initialize() throws IOException, AsterixException {
            String fn;
            String clazz;
            PythonLibraryEvaluatorId fnId = (PythonLibraryEvaluatorId)this.id;
            List externalIdents = this.finfo.getExternalIdentifier();
            PythonLibrary library = (PythonLibrary)this.libMgr.getLibrary(fnId.libraryDataverseName, fnId.libraryName);
            String wd = library.getFile().getAbsolutePath();
            String packageModule = (String)externalIdents.get(0);
            String externalIdent1 = (String)externalIdents.get(1);
            int idx = externalIdent1.lastIndexOf(46);
            if (idx >= 0) {
                clazz = externalIdent1.substring(0, idx);
                fn = externalIdent1.substring(idx + 1);
            } else {
                clazz = "None";
                fn = externalIdent1;
            }
            this.fn = fn;
            this.clazz = clazz;
            this.module = packageModule;
            int port = this.ipcSys.getSocketAddress().getPort();
            ArrayList<String> args = new ArrayList<String>();
            args.add(this.pythonHome.getAbsolutePath());
            args.addAll(this.pythonArgs);
            args.add(ExternalScalarPythonFunctionEvaluator.ENTRYPOINT);
            args.add(InetAddress.getLoopbackAddress().getHostAddress());
            args.add(Integer.toString(port));
            args.add(this.sitePkgs);
            ProcessBuilder pb = new ProcessBuilder(args.toArray(new String[0]));
            pb.directory(new File(wd));
            this.p = pb.start();
            this.proto = new PythonIPCProto(this.p.getOutputStream(), this.router, this.ipcSys);
            this.proto.start();
            this.proto.helo();
            this.proto.init(packageModule, clazz, fn);
        }

        ByteBuffer callPython(ByteBuffer arguments, int numArgs) throws Exception {
            ByteBuffer ret = null;
            try {
                ret = this.proto.call(arguments, numArgs);
            }
            catch (AsterixException e) {
                this.warningCollector.warn(WarningUtil.forAsterix((SourceLocation)this.sourceLoc, (int)201, (Serializable[])new Serializable[]{e.getMessage()}));
            }
            return ret;
        }

        public void deallocate() {
            if (this.p != null) {
                boolean dead = false;
                try {
                    this.p.destroy();
                    dead = this.p.waitFor(100L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!dead) {
                    this.p.destroyForcibly();
                }
            }
        }

        private static PythonLibraryEvaluator getInstance(IExternalFunctionInfo finfo, ILibraryManager libMgr, ExternalFunctionResultRouter router, IPCSystem ipcSys, File pythonHome, IHyracksTaskContext ctx, String sitePkgs, List<String> pythonArgs, IWarningCollector warningCollector, SourceLocation sourceLoc) throws IOException, AsterixException {
            PythonLibraryEvaluatorId evaluatorId = new PythonLibraryEvaluatorId(finfo.getLibraryDataverseName(), finfo.getLibraryName());
            PythonLibraryEvaluator evaluator = (PythonLibraryEvaluator)ctx.getStateObject((Object)evaluatorId);
            if (evaluator == null) {
                evaluator = new PythonLibraryEvaluator(ctx.getJobletContext().getJobId(), evaluatorId, finfo, libMgr, pythonHome, sitePkgs, pythonArgs, router, ipcSys, ctx.getTaskAttemptId(), warningCollector, sourceLoc);
                ctx.registerDeallocatable((IDeallocatable)evaluator);
                evaluator.initialize();
                ctx.setStateObject((IStateObject)evaluator);
            }
            return evaluator;
        }
    }
}

