/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.function;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.asterix.external.util.FeedUtils;
import org.apache.asterix.metadata.declared.DataSourceId;
import org.apache.asterix.metadata.declared.FeedDataSource;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Feed;
import org.apache.asterix.metadata.entities.FeedConnection;
import org.apache.asterix.metadata.entities.FeedPolicyEntity;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.metadata.feeds.BuiltinFeedPolicies;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionToDataSourceRewriter;
import org.apache.asterix.om.typecomputer.base.IResultTypeComputer;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.ConstantExpressionUtil;
import org.apache.asterix.optimizer.rules.UnnestToDataScanRule;
import org.apache.asterix.translator.util.PlanTranslationUtil;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.IVariableContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSource;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;

public class FeedRewriter
implements IFunctionToDataSourceRewriter,
IResultTypeComputer {
    public static final FeedRewriter INSTANCE = new FeedRewriter();

    private FeedRewriter() {
    }

    public boolean rewrite(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractFunctionCallExpression f = UnnestToDataScanRule.getFunctionCall(opRef);
        UnnestOperator unnest = (UnnestOperator)opRef.getValue();
        if (unnest.getPositionalVariable() != null) {
            throw new CompilationException(1079, unnest.getSourceLocation(), new Serializable[]{"No positional variables are allowed over feeds."});
        }
        DataverseName dataverseName = DataverseName.createFromCanonicalForm((String)ConstantExpressionUtil.getStringArgument((AbstractFunctionCallExpression)f, (int)0));
        String sourceFeedName = ConstantExpressionUtil.getStringArgument((AbstractFunctionCallExpression)f, (int)1);
        String getTargetFeed = ConstantExpressionUtil.getStringArgument((AbstractFunctionCallExpression)f, (int)2);
        String subscriptionLocation = ConstantExpressionUtil.getStringArgument((AbstractFunctionCallExpression)f, (int)3);
        String targetDataset = ConstantExpressionUtil.getStringArgument((AbstractFunctionCallExpression)f, (int)4);
        String outputType = ConstantExpressionUtil.getStringArgument((AbstractFunctionCallExpression)f, (int)5);
        MetadataProvider metadataProvider = (MetadataProvider)context.getMetadataProvider();
        DataSourceId asid = new DataSourceId(dataverseName, getTargetFeed);
        String policyName = (String)metadataProvider.getConfig().get("feed-policy-name");
        FeedPolicyEntity policy = metadataProvider.findFeedPolicy(dataverseName, policyName);
        if (policy == null && (policy = BuiltinFeedPolicies.getFeedPolicy((String)policyName)) == null) {
            throw new CompilationException(1079, unnest.getSourceLocation(), new Serializable[]{"Unknown feed policy:" + policyName});
        }
        ArrayList<LogicalVariable> feedDataScanOutputVariables = new ArrayList<LogicalVariable>();
        String csLocations = (String)metadataProvider.getConfig().get("collect-locations");
        ArrayList<LogicalVariable> pkVars = new ArrayList<LogicalVariable>();
        FeedDataSource ds = this.createFeedDataSource(asid, targetDataset, sourceFeedName, subscriptionLocation, metadataProvider, policy, outputType, csLocations, unnest.getVariable(), context, pkVars);
        feedDataScanOutputVariables.add(unnest.getVariable());
        if (ds.hasMeta()) {
            feedDataScanOutputVariables.add(context.newVar());
        }
        if (ds.isChange()) {
            feedDataScanOutputVariables.addAll(pkVars);
        }
        DataSourceScanOperator scan = new DataSourceScanOperator(feedDataScanOutputVariables, (IDataSource)ds);
        scan.setSourceLocation(unnest.getSourceLocation());
        List scanInpList = scan.getInputs();
        scanInpList.addAll(unnest.getInputs());
        opRef.setValue((Object)scan);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)scan);
        return true;
    }

    private FeedDataSource createFeedDataSource(DataSourceId id, String targetDataset, String sourceFeedName, String subscriptionLocation, MetadataProvider metadataProvider, FeedPolicyEntity feedPolicy, String outputType, String locations, LogicalVariable recordVar, IOptimizationContext context, List<LogicalVariable> pkVars) throws AlgebricksException {
        ArrayList keyAccessScalarFunctionCallExpression;
        Dataset dataset = metadataProvider.findDataset(id.getDataverseName(), targetDataset);
        ARecordType feedOutputType = (ARecordType)metadataProvider.findType(id.getDataverseName(), outputType);
        Feed sourceFeed = metadataProvider.findFeed(id.getDataverseName(), sourceFeedName);
        FeedConnection feedConnection = metadataProvider.findFeedConnection(id.getDataverseName(), sourceFeedName, targetDataset);
        ARecordType metaType = null;
        if (dataset.hasMetaPart()) {
            String metaTypeName = FeedUtils.getFeedMetaTypeName((Map)sourceFeed.getConfiguration());
            if (metaTypeName == null) {
                throw new AlgebricksException("Feed to a dataset with metadata doesn't have meta type specified");
            }
            metaType = (ARecordType)metadataProvider.findType(id.getDataverseName(), metaTypeName);
        }
        List pkTypes = null;
        List partitioningKeys = null;
        List keySourceIndicator = null;
        if (ExternalDataUtils.isChangeFeed((Map)sourceFeed.getConfiguration())) {
            ArrayList keyAccessExpression = new ArrayList();
            keyAccessScalarFunctionCallExpression = new ArrayList();
            pkTypes = ((InternalDatasetDetails)dataset.getDatasetDetails()).getPrimaryKeyType();
            partitioningKeys = ((InternalDatasetDetails)dataset.getDatasetDetails()).getPartitioningKey();
            if (dataset.hasMetaPart()) {
                keySourceIndicator = ((InternalDatasetDetails)dataset.getDatasetDetails()).getKeySourceIndicator();
            }
            for (int i = 0; i < partitioningKeys.size(); ++i) {
                List key = (List)partitioningKeys.get(i);
                if (keySourceIndicator == null || (Integer)keySourceIndicator.get(i) == 0) {
                    PlanTranslationUtil.prepareVarAndExpression((List)key, (LogicalVariable)recordVar, pkVars, keyAccessExpression, null, (IVariableContext)context, null);
                    continue;
                }
                PlanTranslationUtil.prepareMetaKeyAccessExpression((List)key, (LogicalVariable)recordVar, keyAccessExpression, pkVars, null, (IVariableContext)context, null);
            }
            keyAccessExpression.forEach(expr -> keyAccessScalarFunctionCallExpression.add((ScalarFunctionCallExpression)expr.getValue()));
        } else {
            keyAccessScalarFunctionCallExpression = null;
        }
        FeedDataSource feedDataSource = new FeedDataSource(sourceFeed, id, targetDataset, (IAType)feedOutputType, (IAType)metaType, pkTypes, keyAccessScalarFunctionCallExpression, sourceFeed.getFeedId(), FeedUtils.FeedRuntimeType.valueOf((String)subscriptionLocation), locations.split(","), context.getComputationNodeDomain(), feedConnection);
        feedDataSource.getProperties().put("policy", feedPolicy);
        return feedDataSource;
    }

    public IAType computeType(ILogicalExpression expression, IVariableTypeEnvironment env, IMetadataProvider<?, ?> mp) throws AlgebricksException {
        AbstractFunctionCallExpression f = (AbstractFunctionCallExpression)expression;
        if (f.getArguments().size() != BuiltinFunctions.FEED_COLLECT.getArity()) {
            throw new AlgebricksException("Incorrect number of arguments -> arity is " + BuiltinFunctions.FEED_COLLECT.getArity() + ", not " + f.getArguments().size());
        }
        DataverseName dataverseName = DataverseName.createFromCanonicalForm((String)ConstantExpressionUtil.getStringArgument((AbstractFunctionCallExpression)f, (int)0));
        String outputTypeName = ConstantExpressionUtil.getStringArgument((AbstractFunctionCallExpression)f, (int)5);
        if (outputTypeName == null) {
            return BuiltinType.ANY;
        }
        MetadataProvider metadata = (MetadataProvider)mp;
        IAType outputType = metadata.findType(dataverseName, outputTypeName);
        if (outputType == null) {
            throw new AlgebricksException("Unknown type " + outputTypeName);
        }
        return outputType;
    }
}

