/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.asterix.app.result.ResponsePrinter;
import org.apache.asterix.app.translator.RequestParameters;
import org.apache.asterix.common.api.IClusterManagementWork;
import org.apache.asterix.common.api.IReceptionist;
import org.apache.asterix.common.api.IRequestReference;
import org.apache.asterix.common.api.IResponsePrinter;
import org.apache.asterix.common.context.IStorageComponentProvider;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.common.functions.ExternalFunctionLanguage;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.compiler.provider.ILangCompilationProvider;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.statement.CreateLibraryStatement;
import org.apache.asterix.lang.common.statement.LibraryDropStatement;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.translator.IRequestParameters;
import org.apache.asterix.translator.IStatementExecutor;
import org.apache.asterix.translator.IStatementExecutorFactory;
import org.apache.asterix.translator.ResultProperties;
import org.apache.asterix.translator.SessionConfig;
import org.apache.asterix.translator.SessionOutput;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullWriter;
import org.apache.commons.lang3.StringUtils;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.application.ICCServiceContext;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.exceptions.IFormattedException;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.common.work.SynchronizableWork;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.AbstractServlet;
import org.apache.hyracks.http.server.utils.HttpUtil;
import org.apache.hyracks.util.file.FileUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UdfApiServlet
extends AbstractServlet {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final ICcApplicationContext appCtx;
    private final ClusterControllerService ccs;
    private final HttpScheme httpServerProtocol;
    private final int httpServerPort;
    protected final ILangCompilationProvider compilationProvider;
    protected final IStatementExecutorFactory statementExecutorFactory;
    protected final IStorageComponentProvider componentProvider;
    protected final IReceptionist receptionist;
    protected final Path workingDir;
    protected String sysAuthHeader;

    public UdfApiServlet(ConcurrentMap<String, Object> ctx, String[] paths, ICcApplicationContext appCtx, ILangCompilationProvider compilationProvider, IStatementExecutorFactory statementExecutorFactory, IStorageComponentProvider componentProvider, HttpScheme httpServerProtocol, int httpServerPort) {
        super(ctx, paths);
        this.appCtx = appCtx;
        ICCServiceContext srvCtx = appCtx.getServiceContext();
        this.ccs = (ClusterControllerService)srvCtx.getControllerService();
        this.compilationProvider = compilationProvider;
        this.statementExecutorFactory = statementExecutorFactory;
        this.componentProvider = componentProvider;
        this.receptionist = appCtx.getReceptionist();
        this.httpServerProtocol = httpServerProtocol;
        this.httpServerPort = httpServerPort;
        File baseDir = srvCtx.getServerCtx().getBaseDir();
        this.workingDir = baseDir.getAbsoluteFile().toPath().normalize().resolve(Paths.get("applications", "library", "tmp"));
    }

    public void init() throws IOException {
        this.initAuth();
        this.initStorage();
    }

    protected void initAuth() {
        this.sysAuthHeader = (String)this.ctx.get("org.apache.asterix.SYS_AUTH_HEADER");
    }

    protected void initStorage() throws IOException {
        if (Files.isDirectory(this.workingDir, new LinkOption[0])) {
            try {
                FileUtils.cleanDirectory((File)this.workingDir.toFile());
            }
            catch (IOException e) {
                LOGGER.warn("Could not clean directory: " + this.workingDir, (Throwable)e);
            }
        } else {
            Files.deleteIfExists(this.workingDir);
            FileUtil.forceMkdirs((File)this.workingDir.toFile());
        }
    }

    protected Map<String, String> additionalHttpHeadersFromRequest(IServletRequest request) {
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void post(IServletRequest request, IServletResponse response) {
        ExternalFunctionLanguage language;
        String fileExt;
        FileUpload fileUpload;
        HttpPostRequestDecoder requestDecoder;
        Path libraryTempFile;
        Pair<DataverseName, String> libraryName;
        block27: {
            InterfaceHttpData httpData;
            block26: {
                block25: {
                    IClusterManagementWork.ClusterState clusterState = this.appCtx.getClusterStateManager().getState();
                    if (clusterState != IClusterManagementWork.ClusterState.ACTIVE) {
                        response.setStatus(HttpResponseStatus.SERVICE_UNAVAILABLE);
                        return;
                    }
                    FullHttpRequest httpRequest = request.getHttpRequest();
                    libraryName = this.parseLibraryName(request);
                    if (libraryName == null) {
                        response.setStatus(HttpResponseStatus.BAD_REQUEST);
                        return;
                    }
                    libraryTempFile = null;
                    requestDecoder = new HttpPostRequestDecoder((HttpRequest)httpRequest);
                    try {
                        if (requestDecoder.hasNext() && requestDecoder.getBodyHttpDatas().size() == 1) break block25;
                        response.setStatus(HttpResponseStatus.BAD_REQUEST);
                    }
                    catch (Throwable throwable) {
                        requestDecoder.destroy();
                        if (libraryTempFile != null) {
                            try {
                                Files.deleteIfExists(libraryTempFile);
                            }
                            catch (IOException e) {
                                LOGGER.warn("Could not delete temporary file " + libraryTempFile, (Throwable)e);
                            }
                        }
                        throw throwable;
                    }
                    requestDecoder.destroy();
                    if (libraryTempFile != null) {
                        try {
                            Files.deleteIfExists(libraryTempFile);
                        }
                        catch (IOException e) {
                            LOGGER.warn("Could not delete temporary file " + libraryTempFile, (Throwable)e);
                        }
                    }
                    return;
                }
                httpData = (InterfaceHttpData)requestDecoder.getBodyHttpDatas().get(0);
                if (httpData.getHttpDataType().equals((Object)InterfaceHttpData.HttpDataType.FileUpload)) break block26;
                response.setStatus(HttpResponseStatus.BAD_REQUEST);
                requestDecoder.destroy();
                if (libraryTempFile != null) {
                    try {
                        Files.deleteIfExists(libraryTempFile);
                    }
                    catch (IOException e) {
                        LOGGER.warn("Could not delete temporary file " + libraryTempFile, (Throwable)e);
                    }
                }
                return;
            }
            fileUpload = (FileUpload)httpData;
            fileExt = FilenameUtils.getExtension((String)fileUpload.getFilename());
            language = UdfApiServlet.getLanguageByFileExtension(fileExt);
            if (language != null) break block27;
            response.setStatus(HttpResponseStatus.BAD_REQUEST);
            requestDecoder.destroy();
            if (libraryTempFile != null) {
                try {
                    Files.deleteIfExists(libraryTempFile);
                }
                catch (IOException e) {
                    LOGGER.warn("Could not delete temporary file " + libraryTempFile, (Throwable)e);
                }
            }
            return;
        }
        try {
            IRequestReference requestReference = this.receptionist.welcome(request);
            libraryTempFile = Files.createTempFile(this.workingDir, "lib_", '.' + fileExt, new FileAttribute[0]);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Created temporary file " + libraryTempFile + " for library " + libraryName.first + "." + (String)libraryName.second);
            }
            fileUpload.renameTo(libraryTempFile.toFile());
            URI downloadURI = this.createDownloadURI(libraryTempFile);
            CreateLibraryStatement stmt = new CreateLibraryStatement((DataverseName)libraryName.first, (String)libraryName.second, language, downloadURI, true, this.sysAuthHeader);
            this.executeStatement((Statement)stmt, requestReference, request);
            response.setStatus(HttpResponseStatus.OK);
        }
        catch (Exception e) {
            response.setStatus(this.toHttpErrorStatus(e));
            PrintWriter responseWriter = response.writer();
            responseWriter.write(e.getMessage());
            responseWriter.flush();
            LOGGER.error("Error creating/updating library " + libraryName.first + "." + (String)libraryName.second, (Throwable)e);
        }
        requestDecoder.destroy();
        if (libraryTempFile != null) {
            try {
                Files.deleteIfExists(libraryTempFile);
            }
            catch (IOException e) {
                LOGGER.warn("Could not delete temporary file " + libraryTempFile, (Throwable)e);
            }
        }
    }

    protected URI createDownloadURI(Path file) throws Exception {
        String path = this.paths[0].substring(0, this.trims[0]) + '/' + file.getFileName();
        String host = this.getHyracksClientConnection().getHost();
        return new URI(this.httpServerProtocol.toString(), null, host, this.httpServerPort, path, null, null);
    }

    protected void delete(IServletRequest request, IServletResponse response) {
        IClusterManagementWork.ClusterState clusterState = this.appCtx.getClusterStateManager().getState();
        if (clusterState != IClusterManagementWork.ClusterState.ACTIVE) {
            response.setStatus(HttpResponseStatus.SERVICE_UNAVAILABLE);
            return;
        }
        Pair<DataverseName, String> libraryName = this.parseLibraryName(request);
        if (libraryName == null) {
            response.setStatus(HttpResponseStatus.BAD_REQUEST);
            return;
        }
        try {
            IRequestReference requestReference = this.receptionist.welcome(request);
            LibraryDropStatement stmt = new LibraryDropStatement((DataverseName)libraryName.first, (String)libraryName.second, false);
            this.executeStatement((Statement)stmt, requestReference, request);
            response.setStatus(HttpResponseStatus.OK);
        }
        catch (Exception e) {
            response.setStatus(this.toHttpErrorStatus(e));
            PrintWriter responseWriter = response.writer();
            responseWriter.write(e.getMessage());
            responseWriter.flush();
            LOGGER.error("Error deleting library " + libraryName.first + "." + (String)libraryName.second, (Throwable)e);
        }
    }

    protected void executeStatement(Statement statement, IRequestReference requestReference, IServletRequest request) throws Exception {
        SessionOutput sessionOutput = new SessionOutput(new SessionConfig(SessionConfig.OutputFormat.ADM), new PrintWriter((Writer)NullWriter.NULL_WRITER));
        ResponsePrinter printer = new ResponsePrinter(sessionOutput);
        ResultProperties resultProperties = new ResultProperties(IStatementExecutor.ResultDelivery.IMMEDIATE, 1L);
        RequestParameters requestParams = new RequestParameters(requestReference, "", null, resultProperties, new IStatementExecutor.Stats(), new IStatementExecutor.StatementProperties(), null, null, this.additionalHttpHeadersFromRequest(request), Collections.emptyMap(), false);
        MetadataManager.INSTANCE.init();
        IStatementExecutor translator = this.statementExecutorFactory.create(this.appCtx, Collections.singletonList(statement), sessionOutput, this.compilationProvider, this.componentProvider, (IResponsePrinter)printer);
        translator.compileAndExecute(this.getHyracksClientConnection(), (IRequestParameters)requestParams);
    }

    protected void get(IServletRequest request, IServletResponse response) throws Exception {
        IClusterManagementWork.ClusterState clusterState = this.appCtx.getClusterStateManager().getState();
        if (clusterState != IClusterManagementWork.ClusterState.ACTIVE) {
            response.setStatus(HttpResponseStatus.SERVICE_UNAVAILABLE);
            return;
        }
        String localPath = this.localPath(request);
        while (localPath.startsWith("/")) {
            localPath = localPath.substring(1);
        }
        if (localPath.isEmpty()) {
            response.setStatus(HttpResponseStatus.BAD_REQUEST);
            return;
        }
        Path filePath = this.workingDir.resolve(localPath).normalize();
        if (!filePath.startsWith(this.workingDir)) {
            response.setStatus(HttpResponseStatus.BAD_REQUEST);
            return;
        }
        this.readFromFile(filePath, response);
    }

    protected IHyracksClientConnection getHyracksClientConnection() throws Exception {
        IHyracksClientConnection hcc = (IHyracksClientConnection)this.ctx.get("org.apache.asterix.HYRACKS_CONNECTION");
        if (hcc == null) {
            throw new RuntimeDataException(14, new Serializable[]{"org.apache.asterix.HYRACKS_CONNECTION"});
        }
        return hcc;
    }

    protected Pair<DataverseName, String> parseLibraryName(IServletRequest request) throws IllegalArgumentException {
        String[] path = StringUtils.split((String)this.localPath(request), (char)'/');
        int ln = path.length;
        if (ln < 2) {
            return null;
        }
        String libraryName = path[ln - 1];
        DataverseName dataverseName = DataverseName.create(Arrays.asList(path), (int)0, (int)(ln - 1));
        return new Pair((Object)dataverseName, (Object)libraryName);
    }

    protected static ExternalFunctionLanguage getLanguageByFileExtension(String fileExtension) {
        switch (fileExtension) {
            case "zip": {
                return ExternalFunctionLanguage.JAVA;
            }
            case "pyz": {
                return ExternalFunctionLanguage.PYTHON;
            }
        }
        return null;
    }

    protected HttpResponseStatus toHttpErrorStatus(Exception e) {
        IFormattedException fe;
        if (e instanceof IFormattedException && "ASX".equals((fe = (IFormattedException)e).getComponent())) {
            switch (fe.getErrorCode()) {
                case 1063: 
                case 1117: {
                    return HttpResponseStatus.NOT_FOUND;
                }
            }
        }
        return HttpResponseStatus.INTERNAL_SERVER_ERROR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readFromFile(final Path filePath, IServletResponse response) throws Exception {
        class InputStreamGetter
        extends SynchronizableWork {
            private InputStream is;

            InputStreamGetter() {
            }

            protected void doRun() throws Exception {
                this.is = Files.newInputStream(filePath, new OpenOption[0]);
            }
        }
        InputStreamGetter r = new InputStreamGetter();
        this.ccs.getWorkQueue().scheduleAndSync((SynchronizableWork)r);
        if (r.is == null) {
            response.setStatus(HttpResponseStatus.NOT_FOUND);
            return;
        }
        try {
            response.setStatus(HttpResponseStatus.OK);
            HttpUtil.setContentType((IServletResponse)response, (String)"application/octet-stream");
            IOUtils.copyLarge((InputStream)r.is, (OutputStream)response.outputStream());
        }
        finally {
            r.is.close();
        }
    }
}

