/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.core.whiteboard;

import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.aries.jmx.Logger;
import org.apache.aries.jmx.framework.BundleState;
import org.apache.aries.jmx.framework.Framework;
import org.apache.aries.jmx.framework.PackageState;
import org.apache.aries.jmx.framework.ServiceState;
import org.apache.aries.jmx.util.ObjectNameUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.jmx.framework.BundleStateMBean;
import org.osgi.jmx.framework.FrameworkMBean;
import org.osgi.jmx.framework.PackageStateMBean;
import org.osgi.jmx.framework.ServiceStateMBean;
import org.osgi.jmx.service.cm.ConfigurationAdminMBean;
import org.osgi.jmx.service.permissionadmin.PermissionAdminMBean;
import org.osgi.jmx.service.provisioning.ProvisioningServiceMBean;
import org.osgi.jmx.service.useradmin.UserAdminMBean;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.permissionadmin.PermissionAdmin;
import org.osgi.service.provisioning.ProvisioningService;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.service.useradmin.UserAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
implements BundleActivator,
ServiceTrackerCustomizer {
    private ServiceTracker tracker;
    private BundleContext ctx;
    private ConcurrentMap<Long, ServiceRegistration> _provisioningMBeans = new ConcurrentHashMap<Long, ServiceRegistration>();
    private ConcurrentMap<Long, ServiceRegistration> _userAdminMBeans = new ConcurrentHashMap<Long, ServiceRegistration>();
    private ConcurrentMap<Long, ServiceRegistration> _configAdminMBeans = new ConcurrentHashMap<Long, ServiceRegistration>();
    private AtomicReference<ServiceRegistration> _serviceStateMbean = new AtomicReference();
    private AtomicReference<ServiceRegistration> _permissionAdminMbean = new AtomicReference();
    private AtomicReference<ServiceRegistration> _packageStateMbean = new AtomicReference();
    private AtomicReference<ServiceRegistration> _bundleState = new AtomicReference();
    private AtomicReference<ServiceRegistration> _framework = new AtomicReference();
    private AtomicReference<ServiceReference> _startLevel = new AtomicReference();
    private AtomicReference<ServiceReference> _packageAdmin = new AtomicReference();
    private static final String PACKAGE_ADMIN = "org.osgi.service.packageadmin.PackageAdmin";
    private static final String START_LEVEL = "org.osgi.service.startlevel.StartLevel";
    private static final String PERMISSION_ADMIN = "org.osgi.service.permissionadmin.PermissionAdmin";
    private static final String CONFIG_ADMIN = "org.osgi.service.cm.ConfigurationAdmin";
    private static final String USER_ADMIN = "org.osgi.service.useradmin.UserAdmin";
    private static final String PROVISIONING_SERVICE = "org.osgi.service.provisioning.ProvisioningService";
    private Logger logger;

    public void start(BundleContext context) throws Exception {
        this.ctx = context;
        this.logger = new Logger(this.ctx);
        Filter filter = this.getFilter(context, PACKAGE_ADMIN, START_LEVEL, PERMISSION_ADMIN, CONFIG_ADMIN, USER_ADMIN, PROVISIONING_SERVICE);
        this.tracker = new ServiceTracker(context, filter, (ServiceTrackerCustomizer)this);
        this.tracker.open();
        this.registerMBean(ServiceStateMBean.class.getName(), new Factory<ServiceStateMBean>(){

            @Override
            public ServiceStateMBean create() {
                return new ServiceState(Activator.this.ctx, Activator.this.logger);
            }
        }, "osgi.core:type=serviceState,version=1.7", this._serviceStateMbean);
    }

    private Filter getFilter(BundleContext ctx, String ... services) throws InvalidSyntaxException {
        StringBuilder builder = new StringBuilder("(|");
        for (String type : services) {
            builder.append('(');
            builder.append("objectClass");
            builder.append('=');
            builder.append(type);
            builder.append(')');
        }
        builder.append(')');
        return ctx.createFilter(builder.toString());
    }

    public void stop(BundleContext context) throws Exception {
        this.tracker.close();
    }

    public Object addingService(ServiceReference reference) {
        String[] types;
        ServiceReference tracked = null;
        for (String t : types = (String[])reference.getProperty("objectClass")) {
            if (PACKAGE_ADMIN.equals(t)) {
                this.foundPackageAdmin(reference);
                tracked = reference;
                continue;
            }
            if (START_LEVEL.equals(t)) {
                this.foundStartLevel(reference);
                tracked = reference;
                continue;
            }
            if (PERMISSION_ADMIN.equals(t)) {
                this.foundPermissionAdmin(reference);
                tracked = reference;
                continue;
            }
            if (CONFIG_ADMIN.equals(t)) {
                this.foundConfigAdmin(reference);
                tracked = reference;
                continue;
            }
            if (USER_ADMIN.equals(t)) {
                this.foundUserAdmin(reference);
                tracked = reference;
                continue;
            }
            if (!PROVISIONING_SERVICE.equals(t)) continue;
            this.foundProvisioningService(reference);
            tracked = reference;
        }
        return tracked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void registerMBean(String type, Factory<T> factory, String objectName, AtomicReference<ServiceRegistration> result) {
        AtomicReference<ServiceRegistration> atomicReference = result;
        synchronized (atomicReference) {
            ServiceRegistration reg = this.registerAnMbean(type, factory, objectName);
            if (!result.compareAndSet(null, reg)) {
                reg.unregister();
            }
        }
    }

    private <T> void registerMBean(String type, Factory<T> factory, String objectName, ConcurrentMap<Long, ServiceRegistration> mbeans, ServiceReference referencedServices, String underlyingType) {
        try {
            Class.forName(underlyingType);
            if (referencedServices.isAssignableTo(this.ctx.getBundle(), underlyingType)) {
                ServiceRegistration reg = this.registerAnMbean(type, factory, objectName);
                Long id = (Long)reg.getReference().getProperty("service.id");
                mbeans.put(id, reg);
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
    }

    private <T> ServiceRegistration registerAnMbean(String type, Factory<T> factory, String objectName) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("jmx.objectname", ObjectNameUtils.createFullObjectName(this.ctx, objectName));
        MBeanServiceProxy service = new MBeanServiceProxy(factory);
        ServiceRegistration reg = this.ctx.registerService(type, service, properties);
        return reg;
    }

    private void foundPermissionAdmin(final ServiceReference reference) {
        this.registerMBean(PermissionAdminMBean.class.getName(), new Factory<PermissionAdminMBean>(){

            @Override
            public PermissionAdminMBean create() {
                PermissionAdmin service = (PermissionAdmin)Activator.this.ctx.getService(reference);
                if (service == null) {
                    return null;
                }
                return new org.apache.aries.jmx.permissionadmin.PermissionAdmin(service);
            }
        }, "osgi.core:service=permissionadmin,version=1.2", this._permissionAdminMbean);
    }

    private void foundProvisioningService(final ServiceReference reference) {
        this.registerMBean(ProvisioningServiceMBean.class.getName(), new Factory<ProvisioningServiceMBean>(){

            @Override
            public ProvisioningServiceMBean create() {
                ProvisioningService service = (ProvisioningService)Activator.this.ctx.getService(reference);
                if (service == null) {
                    return null;
                }
                return new org.apache.aries.jmx.provisioning.ProvisioningService(service);
            }
        }, "osgi.compendium:service=provisioning,version=1.2", this._provisioningMBeans, reference, PROVISIONING_SERVICE);
    }

    private void foundUserAdmin(final ServiceReference reference) {
        try {
            Class.forName(USER_ADMIN);
            if (reference.isAssignableTo(this.ctx.getBundle(), USER_ADMIN)) {
                this.registerMBean(UserAdminMBean.class.getName(), new Factory<UserAdminMBean>(){

                    @Override
                    public UserAdminMBean create() {
                        UserAdmin service = (UserAdmin)Activator.this.ctx.getService(reference);
                        if (service == null) {
                            return null;
                        }
                        return new org.apache.aries.jmx.useradmin.UserAdmin(service);
                    }
                }, "osgi.compendium:service=useradmin,version=1.1", this._userAdminMBeans, reference, USER_ADMIN);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void foundConfigAdmin(final ServiceReference reference) {
        this.registerMBean(ConfigurationAdminMBean.class.getName(), new Factory<ConfigurationAdminMBean>(){

            @Override
            public ConfigurationAdminMBean create() {
                ConfigurationAdmin service = (ConfigurationAdmin)Activator.this.ctx.getService(reference);
                if (service == null) {
                    return null;
                }
                return new org.apache.aries.jmx.cm.ConfigurationAdmin(service);
            }
        }, "osgi.compendium:service=cm,version=1.3", this._configAdminMBeans, reference, CONFIG_ADMIN);
    }

    private void foundStartLevel(ServiceReference reference) {
        if (this._startLevel.compareAndSet(null, reference)) {
            this.registerBundleStateAndFrameworkIfPossible();
        }
    }

    private void foundPackageAdmin(final ServiceReference reference) {
        this.registerMBean(PackageStateMBean.class.getName(), new Factory<PackageStateMBean>(){

            @Override
            public PackageStateMBean create() {
                PackageAdmin service = (PackageAdmin)Activator.this.ctx.getService(reference);
                if (service == null) {
                    return null;
                }
                return new PackageState(Activator.this.ctx, service);
            }
        }, "osgi.core:type=packageState,version=1.5", this._packageStateMbean);
        if (this._packageAdmin.compareAndSet(null, reference)) {
            this.registerBundleStateAndFrameworkIfPossible();
        }
    }

    private synchronized void registerBundleStateAndFrameworkIfPossible() {
        if (this._bundleState.get() == null && this._startLevel.get() != null && this._packageAdmin.get() != null) {
            this.registerMBean(BundleStateMBean.class.getName(), new BaseFactory<BundleStateMBean>(){

                @Override
                public BundleStateMBean create(PackageAdmin pa, StartLevel sl) {
                    return new BundleState(Activator.this.ctx, pa, sl, Activator.this.logger);
                }
            }, "osgi.core:type=bundleState,version=1.7", this._bundleState);
        }
        if (this._framework.get() == null && this._startLevel.get() != null && this._packageAdmin.get() != null) {
            this.registerMBean(FrameworkMBean.class.getName(), new BaseFactory<FrameworkMBean>(){

                @Override
                public FrameworkMBean create(PackageAdmin pa, StartLevel sl) {
                    return new Framework(Activator.this.ctx, sl, pa);
                }
            }, "osgi.core:type=framework,version=1.7", this._framework);
        }
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        String[] types;
        for (String t : types = (String[])reference.getProperty("objectClass")) {
            if (PACKAGE_ADMIN.equals(t)) {
                this.lostPackageAdmin(reference);
                continue;
            }
            if (START_LEVEL.equals(t)) {
                this.lostStartLevel(reference);
                continue;
            }
            if (PERMISSION_ADMIN.equals(t)) {
                this.lostPermissionAdmin(reference);
                continue;
            }
            if (CONFIG_ADMIN.equals(t)) {
                this.lostConfigAdmin(reference);
                continue;
            }
            if (USER_ADMIN.equals(t)) {
                this.lostUserAdmin(reference);
                continue;
            }
            if (!PROVISIONING_SERVICE.equals(t)) continue;
            this.lostProvisioningService(reference);
        }
    }

    private void lostProvisioningService(ServiceReference reference) {
        this.unregister(reference, this._provisioningMBeans);
    }

    private void lostUserAdmin(ServiceReference reference) {
        this.unregister(reference, this._userAdminMBeans);
    }

    private void lostConfigAdmin(ServiceReference reference) {
        this.unregister(reference, this._configAdminMBeans);
    }

    private void unregister(ServiceReference reference, ConcurrentMap<Long, ServiceRegistration> mbeans) {
        Long id = (Long)reference.getProperty("service.id");
        ServiceRegistration reg = (ServiceRegistration)mbeans.remove(id);
        if (reg != null) {
            reg.unregister();
        }
    }

    private void lostPermissionAdmin(ServiceReference reference) {
        this.safeUnregister(this._permissionAdminMbean);
    }

    private void lostStartLevel(ServiceReference reference) {
        if (this._startLevel.compareAndSet(reference, null)) {
            this.safeUnregister(this._bundleState);
            this.safeUnregister(this._framework);
        }
    }

    private void lostPackageAdmin(ServiceReference reference) {
        if (this._packageAdmin.compareAndSet(reference, null)) {
            this.safeUnregister(this._bundleState);
            this.safeUnregister(this._framework);
            this.safeUnregister(this._packageStateMbean);
        }
    }

    private void safeUnregister(AtomicReference<ServiceRegistration> atomicRegistration) {
        ServiceRegistration reg = atomicRegistration.getAndSet(null);
        if (reg != null) {
            reg.unregister();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class BaseFactory<T>
    implements Factory<T> {
        private BaseFactory() {
        }

        public abstract T create(PackageAdmin var1, StartLevel var2);

        @Override
        public final T create() {
            ServiceReference paRef;
            StartLevel sl = null;
            PackageAdmin pa = null;
            ServiceReference slRef = (ServiceReference)Activator.this._startLevel.get();
            if (slRef != null) {
                sl = (StartLevel)Activator.this.ctx.getService(slRef);
            }
            if ((paRef = (ServiceReference)Activator.this._packageAdmin.get()) != null) {
                pa = (PackageAdmin)Activator.this.ctx.getService(paRef);
            }
            if (pa == null) {
                Activator.this.ctx.ungetService(slRef);
            }
            if (sl != null && pa != null) {
                return this.create(pa, sl);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Factory<T> {
        public T create();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MBeanServiceProxy<T>
    implements ServiceFactory {
        private Factory<T> objectFactory;
        private AtomicReference<T> result = new AtomicReference();

        private MBeanServiceProxy(Factory<T> factory) {
            this.objectFactory = factory;
        }

        public Object getService(Bundle bundle, ServiceRegistration registration) {
            if (this.result.get() == null) {
                this.result.compareAndSet(null, this.objectFactory.create());
            }
            return this.result.get();
        }

        public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
        }
    }
}

