/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

// Code generated by swaggo/swag. DO NOT EDIT.

package docs

import "github.com/swaggo/swag"

const docTemplate = `{
    "schemes": {{ marshal .Schemes }},
    "swagger": "2.0",
    "info": {
        "description": "{{escape .Description}}",
        "title": "{{.Title}}",
        "contact": {},
        "version": "{{.Version}}"
    },
    "host": "{{.Host}}",
    "basePath": "{{.BasePath}}",
    "paths": {
        "/": {
            "get": {
                "description": "if config file not exist try to redirect to install page",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "installation"
                ],
                "summary": "if config file not exist try to redirect to install page",
                "responses": {}
            }
        },
        "/answer/admin/api/answer/page": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "Status:[available,deleted]",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "admin"
                ],
                "summary": "AdminAnswerPage admin answer page",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "page size",
                        "name": "page",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "page size",
                        "name": "page_size",
                        "in": "query"
                    },
                    {
                        "enum": [
                            "available",
                            "deleted"
                        ],
                        "type": "string",
                        "description": "user status",
                        "name": "status",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "answer id or question title",
                        "name": "query",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "question id",
                        "name": "question_id",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/admin/api/answer/status": {
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "update answer status",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "admin"
                ],
                "summary": "update answer status",
                "parameters": [
                    {
                        "description": "AdminUpdateAnswerStatusReq",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.AdminUpdateAnswerStatusReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/admin/api/dashboard": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "DashboardInfo",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "admin"
                ],
                "summary": "DashboardInfo",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/admin/api/language/options": {
            "get": {
                "description": "Get language options",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Lang"
                ],
                "summary": "Get language options",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/admin/api/plugin/config": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "get plugin config",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "AdminPlugin"
                ],
                "summary": "get plugin config",
                "parameters": [
                    {
                        "type": "string",
                        "description": "plugin_slug_name",
                        "name": "plugin_slug_name",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/schema.GetPluginConfigResp"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "update plugin config",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "AdminPlugin"
                ],
                "summary": "update plugin config",
                "parameters": [
                    {
                        "description": "UpdatePluginConfigReq",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.UpdatePluginConfigReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/admin/api/plugin/status": {
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "update plugin status",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "AdminPlugin"
                ],
                "summary": "update plugin status",
                "parameters": [
                    {
                        "description": "UpdatePluginStatusReq",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.UpdatePluginStatusReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/admin/api/plugins": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "get plugin list",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "AdminPlugin"
                ],
                "summary": "get plugin list",
                "parameters": [
                    {
                        "type": "string",
                        "description": "status: active/inactive",
                        "name": "status",
                        "in": "query"
                    },
                    {
                        "type": "boolean",
                        "description": "have config",
                        "name": "have_config",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/schema.GetPluginListResp"
                                            }
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/answer/admin/api/question/page": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "Status:[available,closed,deleted]",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "admin"
                ],
                "summary": "AdminQuestionPage admin question page",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "page size",
                        "name": "page",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "page size",
                        "name": "page_size",
                        "in": "query"
                    },
                    {
                        "enum": [
                            "available",
                            "closed",
                            "deleted"
                        ],
                        "type": "string",
                        "description": "user status",
                        "name": "status",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "question id or title",
                        "name": "query",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/admin/api/question/status": {
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "update question status",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "admin"
                ],
                "summary": "update question status",
                "parameters": [
                    {
                        "description": "AdminUpdateQuestionStatusReq",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.AdminUpdateQuestionStatusReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/admin/api/reasons": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "get reasons by object type and action",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "reason"
                ],
                "summary": "get reasons by object type and action",
                "parameters": [
                    {
                        "enum": [
                            "question",
                            "answer",
                            "comment",
                            "user"
                        ],
                        "type": "string",
                        "description": "object_type",
                        "name": "object_type",
                        "in": "query",
                        "required": true
                    },
                    {
                        "enum": [
                            "status",
                            "close",
                            "flag",
                            "review"
                        ],
                        "type": "string",
                        "description": "action",
                        "name": "action",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/admin/api/report/": {
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    },
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "handle flag",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "admin"
                ],
                "summary": "handle flag",
                "parameters": [
                    {
                        "description": "flag",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.ReportHandleReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/admin/api/reports/page": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    },
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "list report records",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "admin"
                ],
                "summary": "list report page",
                "parameters": [
                    {
                        "enum": [
                            "pending",
                            "completed"
                        ],
                        "type": "string",
                        "description": "status",
                        "name": "status",
                        "in": "query",
                        "required": true
                    },
                    {
                        "enum": [
                            "all",
                            "question",
                            "answer",
                            "comment"
                        ],
                        "type": "string",
                        "description": "object_type",
                        "name": "object_type",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "page size",
                        "name": "page",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "page size",
                        "name": "page_size",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/admin/api/roles": {
            "get": {
                "description": "get role list",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "admin"
                ],
                "summary": "get role list",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/schema.GetRoleResp"
                                            }
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/answer/admin/api/setting/privileges": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "GetPrivilegesConfig get privileges config",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "admin"
                ],
                "summary": "GetPrivilegesConfig get privileges config",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/schema.GetPrivilegesConfigResp"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "update privileges config",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "admin"
                ],
                "summary": "update privileges config",
                "parameters": [
                    {
                        "description": "config",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.UpdatePrivilegesConfigReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/admin/api/setting/smtp": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "GetSMTPConfig get smtp config",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "admin"
                ],
                "summary": "GetSMTPConfig get smtp config",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/schema.GetSMTPConfigResp"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "update smtp config",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "admin"
                ],
                "summary": "update smtp config",
                "parameters": [
                    {
                        "description": "smtp config",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.UpdateSMTPConfigReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/admin/api/siteinfo/branding": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "get site interface",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "admin"
                ],
                "summary": "get site interface",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/schema.SiteBrandingResp"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "update site info branding",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "admin"
                ],
                "summary": "update site info branding",
                "parameters": [
                    {
                        "description": "branding info",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.SiteBrandingReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/admin/api/siteinfo/custom-css-html": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "get site info custom html css config",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "admin"
                ],
                "summary": "get site info custom html css config",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/schema.SiteCustomCssHTMLResp"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "update site custom css html config",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "admin"
                ],
                "summary": "update site custom css html config",
                "parameters": [
                    {
                        "description": "login info",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.SiteCustomCssHTMLReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/admin/api/siteinfo/general": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "get site general information",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "admin"
                ],
                "summary": "get site general information",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/schema.SiteGeneralResp"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "update site general information",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "admin"
                ],
                "summary": "update site general information",
                "parameters": [
                    {
                        "description": "general",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.SiteGeneralReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/admin/api/siteinfo/interface": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "get site interface",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "admin"
                ],
                "summary": "get site interface",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/schema.SiteInterfaceResp"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "update site info interface",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "admin"
                ],
                "summary": "update site info interface",
                "parameters": [
                    {
                        "description": "general",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.SiteInterfaceReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/admin/api/siteinfo/legal": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "Set the legal information for the site",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "admin"
                ],
                "summary": "Set the legal information for the site",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/schema.SiteLegalResp"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "update site legal info",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "admin"
                ],
                "summary": "update site legal info",
                "parameters": [
                    {
                        "description": "write info",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.SiteLegalReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/admin/api/siteinfo/login": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "get site info login config",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "admin"
                ],
                "summary": "get site info login config",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/schema.SiteLoginResp"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "update site login",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "admin"
                ],
                "summary": "update site login",
                "parameters": [
                    {
                        "description": "login info",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.SiteLoginReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/admin/api/siteinfo/seo": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "get site seo information",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "admin"
                ],
                "summary": "get site seo information",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/schema.SiteSeoResp"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "update site seo information",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "admin"
                ],
                "summary": "update site seo information",
                "parameters": [
                    {
                        "description": "seo",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.SiteSeoReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/admin/api/siteinfo/theme": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "get site info theme config",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "admin"
                ],
                "summary": "get site info theme config",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/schema.SiteThemeResp"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "update site custom css html config",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "admin"
                ],
                "summary": "update site custom css html config",
                "parameters": [
                    {
                        "description": "login info",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.SiteThemeReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/admin/api/siteinfo/users": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "get site user config",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "admin"
                ],
                "summary": "get site user config",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/schema.SiteUsersResp"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "update site info config about users",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "admin"
                ],
                "summary": "update site info config about users",
                "parameters": [
                    {
                        "description": "users info",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.SiteUsersReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/admin/api/siteinfo/write": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "get site interface",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "admin"
                ],
                "summary": "get site interface",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/schema.SiteWriteResp"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "update site write info",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "admin"
                ],
                "summary": "update site write info",
                "parameters": [
                    {
                        "description": "write info",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.SiteWriteReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/admin/api/theme/options": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "Get theme options",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "admin"
                ],
                "summary": "Get theme options",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/admin/api/user": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "add user",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "admin"
                ],
                "summary": "add user",
                "parameters": [
                    {
                        "description": "user",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.AddUserReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/admin/api/user/activation": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "get user activation",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "admin"
                ],
                "summary": "get user activation",
                "parameters": [
                    {
                        "type": "string",
                        "description": "user id",
                        "name": "user_id",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/schema.GetUserActivationResp"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/answer/admin/api/user/password": {
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "update user password",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "admin"
                ],
                "summary": "update user password",
                "parameters": [
                    {
                        "description": "user",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.UpdateUserPasswordReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/admin/api/user/role": {
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "update user role",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "admin"
                ],
                "summary": "update user role",
                "parameters": [
                    {
                        "description": "user",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.UpdateUserRoleReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/admin/api/user/status": {
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "update user",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "admin"
                ],
                "summary": "update user",
                "parameters": [
                    {
                        "description": "user",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.UpdateUserStatusReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/admin/api/users": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "add users",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "admin"
                ],
                "summary": "add users",
                "parameters": [
                    {
                        "description": "user",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.AddUsersReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/admin/api/users/activation": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "send user activation",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "admin"
                ],
                "summary": "send user activation",
                "parameters": [
                    {
                        "description": "SendUserActivationReq",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.SendUserActivationReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/admin/api/users/page": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "get user page",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "admin"
                ],
                "summary": "get user page",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "page size",
                        "name": "page",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "page size",
                        "name": "page_size",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "search query: email, username or id:[id]",
                        "name": "query",
                        "in": "query"
                    },
                    {
                        "type": "boolean",
                        "description": "staff user",
                        "name": "staff",
                        "in": "query"
                    },
                    {
                        "enum": [
                            "suspended",
                            "deleted",
                            "inactive"
                        ],
                        "type": "string",
                        "description": "user status",
                        "name": "status",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "allOf": [
                                                {
                                                    "$ref": "#/definitions/pager.PageModel"
                                                },
                                                {
                                                    "type": "object",
                                                    "properties": {
                                                        "records": {
                                                            "type": "array",
                                                            "items": {
                                                                "$ref": "#/definitions/schema.GetUserPageResp"
                                                            }
                                                        }
                                                    }
                                                }
                                            ]
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/answer/api/v1/activity/timeline": {
            "get": {
                "description": "get object timeline",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Comment"
                ],
                "summary": "get object timeline",
                "parameters": [
                    {
                        "type": "string",
                        "description": "object id",
                        "name": "object_id",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "tag slug name",
                        "name": "tag_slug_name",
                        "in": "query"
                    },
                    {
                        "enum": [
                            "question",
                            "answer",
                            "tag"
                        ],
                        "type": "string",
                        "description": "object type",
                        "name": "object_type",
                        "in": "query"
                    },
                    {
                        "type": "boolean",
                        "description": "is show vote",
                        "name": "show_vote",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/schema.GetObjectTimelineResp"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/answer/api/v1/activity/timeline/detail": {
            "get": {
                "description": "get object timeline detail",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Comment"
                ],
                "summary": "get object timeline detail",
                "parameters": [
                    {
                        "type": "string",
                        "description": "revision id",
                        "name": "revision_id",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/schema.GetObjectTimelineResp"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/answer/api/v1/answer": {
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "Update Answer",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "api-answer"
                ],
                "summary": "Update Answer",
                "parameters": [
                    {
                        "description": "AnswerUpdateReq",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.AnswerUpdateReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "Insert Answer",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "api-answer"
                ],
                "summary": "Insert Answer",
                "parameters": [
                    {
                        "description": "AnswerAddReq",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.AnswerAddReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "delete answer",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "api-answer"
                ],
                "summary": "delete answer",
                "parameters": [
                    {
                        "description": "answer",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.RemoveAnswerReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/answer/acceptance": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "Accepted",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "api-answer"
                ],
                "summary": "Accepted",
                "parameters": [
                    {
                        "description": "AcceptAnswerReq",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.AcceptAnswerReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/answer/info": {
            "get": {
                "description": "Get Answer",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "api-answer"
                ],
                "summary": "Get Answer",
                "parameters": [
                    {
                        "type": "string",
                        "default": "1",
                        "description": "Answer TagID",
                        "name": "id",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/answer/page": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "AnswerList \u003cbr\u003e \u003cb\u003eorder\u003c/b\u003e (default or updated)",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "api-answer"
                ],
                "summary": "AnswerList",
                "parameters": [
                    {
                        "type": "string",
                        "description": "question_id",
                        "name": "question_id",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "order",
                        "name": "order",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "page",
                        "name": "page",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "page_size",
                        "name": "page_size",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/answer/recover": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "recover deleted answer",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Answer"
                ],
                "summary": "recover answer",
                "parameters": [
                    {
                        "description": "answer",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.RecoverAnswerReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/collection/switch": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "add collection",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Collection"
                ],
                "summary": "add collection",
                "parameters": [
                    {
                        "description": "collection",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.CollectionSwitchReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/schema.CollectionSwitchResp"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/answer/api/v1/comment": {
            "get": {
                "description": "get comment by id",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Comment"
                ],
                "summary": "get comment by id",
                "parameters": [
                    {
                        "type": "string",
                        "description": "id",
                        "name": "id",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "allOf": [
                                                {
                                                    "$ref": "#/definitions/pager.PageModel"
                                                },
                                                {
                                                    "type": "object",
                                                    "properties": {
                                                        "list": {
                                                            "type": "array",
                                                            "items": {
                                                                "$ref": "#/definitions/schema.GetCommentResp"
                                                            }
                                                        }
                                                    }
                                                }
                                            ]
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "update comment",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Comment"
                ],
                "summary": "update comment",
                "parameters": [
                    {
                        "description": "comment",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.UpdateCommentReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "add comment",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Comment"
                ],
                "summary": "add comment",
                "parameters": [
                    {
                        "description": "comment",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.AddCommentReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/schema.GetCommentResp"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "remove comment",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Comment"
                ],
                "summary": "remove comment",
                "parameters": [
                    {
                        "description": "comment",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.RemoveCommentReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/comment/page": {
            "get": {
                "description": "get comment page",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Comment"
                ],
                "summary": "get comment page",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "page",
                        "name": "page",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "page size",
                        "name": "page_size",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "object id",
                        "name": "object_id",
                        "in": "query",
                        "required": true
                    },
                    {
                        "enum": [
                            "vote"
                        ],
                        "type": "string",
                        "description": "query condition",
                        "name": "query_cond",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "allOf": [
                                                {
                                                    "$ref": "#/definitions/pager.PageModel"
                                                },
                                                {
                                                    "type": "object",
                                                    "properties": {
                                                        "list": {
                                                            "type": "array",
                                                            "items": {
                                                                "$ref": "#/definitions/schema.GetCommentResp"
                                                            }
                                                        }
                                                    }
                                                }
                                            ]
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/answer/api/v1/connector/binding/email": {
            "post": {
                "description": "external login binding user send email",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "PluginConnector"
                ],
                "summary": "external login binding user send email",
                "parameters": [
                    {
                        "description": "external login binding user send email",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.ExternalLoginBindingUserSendEmailReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/schema.ExternalLoginBindingUserSendEmailResp"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/answer/api/v1/connector/info": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "get all enabled connectors",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "PluginConnector"
                ],
                "summary": "get all enabled connectors",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/schema.ConnectorInfoResp"
                                            }
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/answer/api/v1/connector/user/info": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "get all connectors info about user",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "PluginConnector"
                ],
                "summary": "get all connectors info about user",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/schema.ConnectorUserInfoResp"
                                            }
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/answer/api/v1/connector/user/unbinding": {
            "delete": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "unbind external user login",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "PluginConnector"
                ],
                "summary": "unbind external user login",
                "parameters": [
                    {
                        "description": "ExternalLoginUnbindingReq",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.ExternalLoginUnbindingReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/file": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "upload file",
                "consumes": [
                    "multipart/form-data"
                ],
                "tags": [
                    "Upload"
                ],
                "summary": "upload file",
                "parameters": [
                    {
                        "enum": [
                            "post",
                            "avatar",
                            "branding"
                        ],
                        "type": "string",
                        "description": "identify the source of the file upload",
                        "name": "source",
                        "in": "formData",
                        "required": true
                    },
                    {
                        "type": "file",
                        "description": "file",
                        "name": "file",
                        "in": "formData",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "string"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/answer/api/v1/follow": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "follow object or cancel follow operation",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Activity"
                ],
                "summary": "follow object or cancel follow operation",
                "parameters": [
                    {
                        "description": "follow",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.FollowReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/schema.FollowResp"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/answer/api/v1/follow/tags": {
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "update user follow tags",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Activity"
                ],
                "summary": "update user follow tags",
                "parameters": [
                    {
                        "description": "follow",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.UpdateFollowTagsReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/language/config": {
            "get": {
                "description": "get language config mapping",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Lang"
                ],
                "summary": "get language config mapping",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Accept-Language",
                        "name": "Accept-Language",
                        "in": "header",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/language/options": {
            "get": {
                "description": "Get language options",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Lang"
                ],
                "summary": "Get language options",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/notification/page": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "get notification list",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Notification"
                ],
                "summary": "get notification list",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "page size",
                        "name": "page",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "page size",
                        "name": "page_size",
                        "in": "query"
                    },
                    {
                        "enum": [
                            "inbox",
                            "achievement"
                        ],
                        "type": "string",
                        "description": "type",
                        "name": "type",
                        "in": "query",
                        "required": true
                    },
                    {
                        "enum": [
                            "all",
                            "posts",
                            "invites",
                            "votes"
                        ],
                        "type": "string",
                        "description": "inbox_type",
                        "name": "inbox_type",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/notification/read/state": {
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "ClearUnRead",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Notification"
                ],
                "summary": "ClearUnRead",
                "parameters": [
                    {
                        "description": "NotificationClearIDRequest",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.NotificationClearIDRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/notification/read/state/all": {
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "ClearUnRead",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Notification"
                ],
                "summary": "ClearUnRead",
                "parameters": [
                    {
                        "description": "NotificationClearRequest",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.NotificationClearRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/notification/status": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "GetRedDot",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Notification"
                ],
                "summary": "GetRedDot",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "DelRedDot",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Notification"
                ],
                "summary": "DelRedDot",
                "parameters": [
                    {
                        "description": "NotificationClearRequest",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.NotificationClearRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/permission": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "check user permission",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Permission"
                ],
                "summary": "check user permission",
                "parameters": [
                    {
                        "type": "string",
                        "description": "access-token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "enum": [
                            "question.add",
                            "question.edit",
                            "question.edit_without_review",
                            "question.delete",
                            "question.close",
                            "question.reopen",
                            "question.vote_up",
                            "question.vote_down",
                            "question.pin",
                            "question.unpin",
                            "question.hide",
                            "question.show",
                            "answer.add",
                            "answer.edit",
                            "answer.edit_without_review",
                            "answer.delete",
                            "answer.accept",
                            "answer.vote_up",
                            "answer.vote_down",
                            "answer.invite_someone_to_answer",
                            "comment.add",
                            "comment.edit",
                            "comment.delete",
                            "comment.vote_up",
                            "comment.vote_down",
                            "report.add",
                            "tag.add",
                            "tag.edit",
                            "tag.edit_slug_name",
                            "tag.edit_without_review",
                            "tag.delete",
                            "tag.synonym",
                            "link.url_limit",
                            "vote.detail",
                            "answer.audit",
                            "question.audit",
                            "tag.audit",
                            "tag.use_reserved_tag"
                        ],
                        "type": "string",
                        "description": "permission key",
                        "name": "action",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "object",
                                            "additionalProperties": {
                                                "type": "boolean"
                                            }
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/answer/api/v1/personal/answer/page": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "list personal answers",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Personal"
                ],
                "summary": "list personal answers",
                "parameters": [
                    {
                        "type": "string",
                        "default": "string",
                        "description": "username",
                        "name": "username",
                        "in": "query",
                        "required": true
                    },
                    {
                        "enum": [
                            "newest",
                            "score"
                        ],
                        "type": "string",
                        "description": "order",
                        "name": "order",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "default": "0",
                        "description": "page",
                        "name": "page",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "default": "20",
                        "description": "page_size",
                        "name": "page_size",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/personal/collection/page": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "list personal collections",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Collection"
                ],
                "summary": "list personal collections",
                "parameters": [
                    {
                        "type": "string",
                        "default": "0",
                        "description": "page",
                        "name": "page",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "default": "20",
                        "description": "page_size",
                        "name": "page_size",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/personal/comment/page": {
            "get": {
                "description": "user personal comment list",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Comment"
                ],
                "summary": "user personal comment list",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "page",
                        "name": "page",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "page size",
                        "name": "page_size",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "username",
                        "name": "username",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "allOf": [
                                                {
                                                    "$ref": "#/definitions/pager.PageModel"
                                                },
                                                {
                                                    "type": "object",
                                                    "properties": {
                                                        "list": {
                                                            "type": "array",
                                                            "items": {
                                                                "$ref": "#/definitions/schema.GetCommentPersonalWithPageResp"
                                                            }
                                                        }
                                                    }
                                                }
                                            ]
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/answer/api/v1/personal/qa/top": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "UserTop",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Question"
                ],
                "summary": "UserTop",
                "parameters": [
                    {
                        "type": "string",
                        "default": "string",
                        "description": "username",
                        "name": "username",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/personal/rank/page": {
            "get": {
                "description": "user personal rank list",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Rank"
                ],
                "summary": "user personal rank list",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "page",
                        "name": "page",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "page size",
                        "name": "page_size",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "username",
                        "name": "username",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "allOf": [
                                                {
                                                    "$ref": "#/definitions/pager.PageModel"
                                                },
                                                {
                                                    "type": "object",
                                                    "properties": {
                                                        "list": {
                                                            "type": "array",
                                                            "items": {
                                                                "$ref": "#/definitions/schema.GetRankPersonalPageResp"
                                                            }
                                                        }
                                                    }
                                                }
                                            ]
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/answer/api/v1/personal/user/info": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "GetOtherUserInfoByUsername",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "GetOtherUserInfoByUsername",
                "parameters": [
                    {
                        "type": "string",
                        "description": "username",
                        "name": "username",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/schema.GetOtherUserInfoResp"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/answer/api/v1/personal/vote/page": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "get user personal votes",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Activity"
                ],
                "summary": "get user personal votes",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "page size",
                        "name": "page",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "page size",
                        "name": "page_size",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "allOf": [
                                                {
                                                    "$ref": "#/definitions/pager.PageModel"
                                                },
                                                {
                                                    "type": "object",
                                                    "properties": {
                                                        "list": {
                                                            "type": "array",
                                                            "items": {
                                                                "$ref": "#/definitions/schema.GetVoteWithPageResp"
                                                            }
                                                        }
                                                    }
                                                }
                                            ]
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/answer/api/v1/plugin/status": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "get all plugins status",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Plugin"
                ],
                "summary": "get all plugins status",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/schema.GetPluginListResp"
                                            }
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/answer/api/v1/post/render": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "render post content",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Upload"
                ],
                "summary": "render post content",
                "parameters": [
                    {
                        "description": "PostRenderReq",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.PostRenderReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/question": {
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "update question",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Question"
                ],
                "summary": "update question",
                "parameters": [
                    {
                        "description": "question",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.QuestionUpdate"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "add question",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Question"
                ],
                "summary": "add question",
                "parameters": [
                    {
                        "description": "question",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.QuestionAdd"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "delete question",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Question"
                ],
                "summary": "delete question",
                "parameters": [
                    {
                        "description": "question",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.RemoveQuestionReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/question/answer": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "add question and answer",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Question"
                ],
                "summary": "add question and answer",
                "parameters": [
                    {
                        "description": "question",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.QuestionAddByAnswer"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/question/info": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "get question details",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Question"
                ],
                "summary": "get question details",
                "parameters": [
                    {
                        "type": "string",
                        "default": "1",
                        "description": "Question TagID",
                        "name": "id",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/question/invite": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "get question invite user info",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Question"
                ],
                "summary": "get question invite user info",
                "parameters": [
                    {
                        "type": "string",
                        "default": "1",
                        "description": "Question ID",
                        "name": "id",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "update question invite user",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Question"
                ],
                "summary": "update question invite user",
                "parameters": [
                    {
                        "description": "question",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.QuestionUpdateInviteUser"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/question/operation": {
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "Operation question \\n operation [pin unpin hide show]",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Question"
                ],
                "summary": "Operation question",
                "parameters": [
                    {
                        "description": "question",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.OperationQuestionReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/question/page": {
            "get": {
                "description": "get questions by page",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Question"
                ],
                "summary": "get questions by page",
                "parameters": [
                    {
                        "description": "QuestionPageReq",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.QuestionPageReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "allOf": [
                                                {
                                                    "$ref": "#/definitions/pager.PageModel"
                                                },
                                                {
                                                    "type": "object",
                                                    "properties": {
                                                        "list": {
                                                            "type": "array",
                                                            "items": {
                                                                "$ref": "#/definitions/schema.QuestionPageResp"
                                                            }
                                                        }
                                                    }
                                                }
                                            ]
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/answer/api/v1/question/recover": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "recover deleted question",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Question"
                ],
                "summary": "recover deleted question",
                "parameters": [
                    {
                        "description": "question",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.QuestionRecoverReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/question/reopen": {
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "reopen question",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Question"
                ],
                "summary": "reopen question",
                "parameters": [
                    {
                        "description": "question",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.ReopenQuestionReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/question/similar": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "fuzzy query similar questions based on title",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Question"
                ],
                "summary": "fuzzy query similar questions based on title",
                "parameters": [
                    {
                        "type": "string",
                        "default": "string",
                        "description": "title",
                        "name": "title",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/question/similar/tag": {
            "get": {
                "description": "Search Similar Question",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Question"
                ],
                "summary": "Search Similar Question",
                "parameters": [
                    {
                        "type": "string",
                        "default": "",
                        "description": "question_id",
                        "name": "question_id",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/question/status": {
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "Close question",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Question"
                ],
                "summary": "Close question",
                "parameters": [
                    {
                        "description": "question",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.CloseQuestionReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/question/tags": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "get tag list",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Tag"
                ],
                "summary": "get tag list",
                "parameters": [
                    {
                        "type": "string",
                        "description": "tag",
                        "name": "tag",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/schema.GetTagResp"
                                            }
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/answer/api/v1/reasons": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "get reasons by object type and action",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "reason"
                ],
                "summary": "get reasons by object type and action",
                "parameters": [
                    {
                        "enum": [
                            "question",
                            "answer",
                            "comment",
                            "user"
                        ],
                        "type": "string",
                        "description": "object_type",
                        "name": "object_type",
                        "in": "query",
                        "required": true
                    },
                    {
                        "enum": [
                            "status",
                            "close",
                            "flag",
                            "review"
                        ],
                        "type": "string",
                        "description": "action",
                        "name": "action",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/report": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    },
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "add report \u003cbr\u003e source (question, answer, comment, user)",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Report"
                ],
                "summary": "add report",
                "parameters": [
                    {
                        "description": "report",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.AddReportReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/revisions": {
            "get": {
                "description": "get revision list",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Revision"
                ],
                "summary": "get revision list",
                "parameters": [
                    {
                        "type": "string",
                        "description": "object id",
                        "name": "object_id",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/schema.GetRevisionResp"
                                            }
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/answer/api/v1/revisions/audit": {
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "revision audit operation:approve or reject",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Revision"
                ],
                "summary": "revision audit",
                "parameters": [
                    {
                        "description": "audit",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.RevisionAuditReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/revisions/edit/check": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "check can update revision",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Revision"
                ],
                "summary": "check can update revision",
                "parameters": [
                    {
                        "type": "string",
                        "default": "string",
                        "description": "id",
                        "name": "id",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/revisions/unreviewed": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "get unreviewed revision list",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Revision"
                ],
                "summary": "get unreviewed revision list",
                "parameters": [
                    {
                        "type": "string",
                        "description": "page id",
                        "name": "page",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "allOf": [
                                                {
                                                    "$ref": "#/definitions/pager.PageModel"
                                                },
                                                {
                                                    "type": "object",
                                                    "properties": {
                                                        "list": {
                                                            "type": "array",
                                                            "items": {
                                                                "$ref": "#/definitions/schema.GetUnreviewedRevisionResp"
                                                            }
                                                        }
                                                    }
                                                }
                                            ]
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/answer/api/v1/search": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "search object",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Search"
                ],
                "summary": "search object",
                "parameters": [
                    {
                        "type": "string",
                        "description": "query string",
                        "name": "q",
                        "in": "query",
                        "required": true
                    },
                    {
                        "enum": [
                            "newest",
                            "active",
                            "score",
                            "relevance"
                        ],
                        "type": "string",
                        "description": "order",
                        "name": "order",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/schema.SearchResp"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/answer/api/v1/search/desc": {
            "get": {
                "description": "get search description",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Search"
                ],
                "summary": "get search description",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/schema.SearchResp"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/answer/api/v1/siteinfo": {
            "get": {
                "description": "get site info",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "site"
                ],
                "summary": "get site info",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/schema.SiteInfoResp"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/answer/api/v1/siteinfo/legal": {
            "get": {
                "description": "get site legal info",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "site"
                ],
                "summary": "get site legal info",
                "parameters": [
                    {
                        "enum": [
                            "tos",
                            "privacy"
                        ],
                        "type": "string",
                        "description": "legal information type",
                        "name": "info_type",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/schema.GetSiteLegalInfoResp"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/answer/api/v1/tag": {
            "get": {
                "description": "get tag one",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Tag"
                ],
                "summary": "get tag one",
                "parameters": [
                    {
                        "type": "string",
                        "description": "tag id",
                        "name": "tag_id",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "tag name",
                        "name": "tag_name",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/schema.GetTagResp"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            },
            "put": {
                "description": "update tag",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Tag"
                ],
                "summary": "update tag",
                "parameters": [
                    {
                        "description": "tag",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.UpdateTagReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            },
            "post": {
                "description": "add tag",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Tag"
                ],
                "summary": "add tag",
                "parameters": [
                    {
                        "description": "tag",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.AddTagReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            },
            "delete": {
                "description": "delete tag",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Tag"
                ],
                "summary": "delete tag",
                "parameters": [
                    {
                        "description": "tag",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.RemoveTagReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/tag/recover": {
            "post": {
                "description": "recover delete tag",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Tag"
                ],
                "summary": "recover delete tag",
                "parameters": [
                    {
                        "description": "tag",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.RecoverTagReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/tag/synonym": {
            "put": {
                "description": "update tag",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Tag"
                ],
                "summary": "update tag",
                "parameters": [
                    {
                        "description": "tag",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.UpdateTagSynonymReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/tag/synonyms": {
            "get": {
                "description": "get tag synonyms",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Tag"
                ],
                "summary": "get tag synonyms",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "tag id",
                        "name": "tag_id",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/schema.GetTagSynonymsResp"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/answer/api/v1/tags": {
            "get": {
                "description": "get tags list",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Tag"
                ],
                "summary": "get tags list",
                "parameters": [
                    {
                        "type": "array",
                        "items": {
                            "type": "string"
                        },
                        "collectionFormat": "csv",
                        "description": "string collection",
                        "name": "tags",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/tags/following": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "get following tag list",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Tag"
                ],
                "summary": "get following tag list",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/schema.GetFollowingTagsResp"
                                            }
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/answer/api/v1/tags/page": {
            "get": {
                "description": "get tag page",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Tag"
                ],
                "summary": "get tag page",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "page size",
                        "name": "page",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "page size",
                        "name": "page_size",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "slug_name",
                        "name": "slug_name",
                        "in": "query"
                    },
                    {
                        "enum": [
                            "popular",
                            "name",
                            "newest"
                        ],
                        "type": "string",
                        "description": "query condition",
                        "name": "query_cond",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "allOf": [
                                                {
                                                    "$ref": "#/definitions/pager.PageModel"
                                                },
                                                {
                                                    "type": "object",
                                                    "properties": {
                                                        "list": {
                                                            "type": "array",
                                                            "items": {
                                                                "$ref": "#/definitions/schema.GetTagPageResp"
                                                            }
                                                        }
                                                    }
                                                }
                                            ]
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/answer/api/v1/user/action/record": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "ActionRecord",
                "tags": [
                    "User"
                ],
                "summary": "ActionRecord",
                "parameters": [
                    {
                        "enum": [
                            "login",
                            "e_mail",
                            "find_pass"
                        ],
                        "type": "string",
                        "description": "action",
                        "name": "action",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/schema.ActionRecordResp"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/answer/api/v1/user/email": {
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "user change email verification",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "user change email verification",
                "parameters": [
                    {
                        "description": "UserChangeEmailVerifyReq",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.UserChangeEmailVerifyReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/user/email/change/code": {
            "post": {
                "description": "send email to the user email then change their email",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "send email to the user email then change their email",
                "parameters": [
                    {
                        "description": "UserChangeEmailSendCodeReq",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.UserChangeEmailSendCodeReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/user/email/verification": {
            "post": {
                "description": "UserVerifyEmail",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "UserVerifyEmail",
                "parameters": [
                    {
                        "type": "string",
                        "default": "",
                        "description": "code",
                        "name": "code",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/schema.UserLoginResp"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/answer/api/v1/user/email/verification/send": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "UserVerifyEmailSend",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "UserVerifyEmailSend",
                "parameters": [
                    {
                        "type": "string",
                        "default": "",
                        "description": "captcha_id",
                        "name": "captcha_id",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "default": "",
                        "description": "captcha_code",
                        "name": "captcha_code",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/user/info": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "get user info, if user no login response http code is 200, but user info is null",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "GetUserInfoByUserID",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/schema.GetCurrentLoginUserInfoResp"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "UserUpdateInfo update user info",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "UserUpdateInfo update user info",
                "parameters": [
                    {
                        "type": "string",
                        "description": "access-token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "description": "UpdateInfoRequest",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.UpdateInfoRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/user/info/search": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "SearchUserListByName",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "SearchUserListByName",
                "parameters": [
                    {
                        "type": "string",
                        "description": "username",
                        "name": "username",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/schema.GetOtherUserInfoResp"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/answer/api/v1/user/interface": {
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "UserUpdateInterface update user interface config",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "UserUpdateInterface update user interface config",
                "parameters": [
                    {
                        "type": "string",
                        "description": "access-token",
                        "name": "Authorization",
                        "in": "header",
                        "required": true
                    },
                    {
                        "description": "UpdateInfoRequest",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.UpdateUserInterfaceRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/user/login/email": {
            "post": {
                "description": "UserEmailLogin",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "UserEmailLogin",
                "parameters": [
                    {
                        "description": "UserEmailLogin",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.UserEmailLoginReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/schema.UserLoginResp"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/answer/api/v1/user/logout": {
            "get": {
                "description": "user logout",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "user logout",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/user/notification/config": {
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "update user's notification config",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "update user's notification config",
                "parameters": [
                    {
                        "description": "UpdateUserNotificationConfigReq",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.UpdateUserNotificationConfigReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "get user's notification config",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "get user's notification config",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/schema.GetUserNotificationConfigResp"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/answer/api/v1/user/notification/unsubscribe": {
            "put": {
                "description": "unsubscribe notification",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "unsubscribe notification",
                "parameters": [
                    {
                        "description": "UserUnsubscribeNotificationReq",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.UserUnsubscribeNotificationReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/user/password": {
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "UserModifyPassWord",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "UserModifyPassWord",
                "parameters": [
                    {
                        "description": "UserModifyPasswordReq",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.UserModifyPasswordReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/user/password/replacement": {
            "post": {
                "description": "UseRePassWord",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "UseRePassWord",
                "parameters": [
                    {
                        "description": "UserRePassWordRequest",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.UserRePassWordRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/user/password/reset": {
            "post": {
                "description": "RetrievePassWord",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "RetrievePassWord",
                "parameters": [
                    {
                        "description": "UserRetrievePassWordRequest",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.UserRetrievePassWordRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/user/plugin/config": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "get user plugin config",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "UserPlugin"
                ],
                "summary": "get user plugin config",
                "parameters": [
                    {
                        "type": "string",
                        "description": "plugin_slug_name",
                        "name": "plugin_slug_name",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/schema.GetPluginConfigResp"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "update user plugin config",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "UserPlugin"
                ],
                "summary": "update user plugin config",
                "parameters": [
                    {
                        "description": "UpdatePluginConfigReq",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.UpdateUserPluginConfigReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/answer/api/v1/user/plugin/configs": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "get plugin list that used for user.",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "UserPlugin"
                ],
                "summary": "get plugin list that used for user.",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/schema.GetUserPluginListResp"
                                            }
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/answer/api/v1/user/ranking": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "get user ranking",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "get user ranking",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/schema.UserRankingResp"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/answer/api/v1/user/register/captcha": {
            "get": {
                "description": "UserRegisterCaptcha",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "UserRegisterCaptcha",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/schema.UserLoginResp"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/answer/api/v1/user/register/email": {
            "post": {
                "description": "UserRegisterByEmail",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "User"
                ],
                "summary": "UserRegisterByEmail",
                "parameters": [
                    {
                        "description": "UserRegisterReq",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.UserRegisterReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/schema.UserLoginResp"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/answer/api/v1/vote/down": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "add vote",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Activity"
                ],
                "summary": "vote down",
                "parameters": [
                    {
                        "description": "vote",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.VoteReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/schema.VoteResp"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/answer/api/v1/vote/up": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "add vote",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Activity"
                ],
                "summary": "vote up",
                "parameters": [
                    {
                        "description": "vote",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/schema.VoteReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/schema.VoteResp"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/custom.css": {
            "get": {
                "description": "get site robots information",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "site"
                ],
                "summary": "get site robots information",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/installation/base-info": {
            "post": {
                "description": "init base info",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "installation"
                ],
                "summary": "init base info",
                "parameters": [
                    {
                        "description": "InitBaseInfoReq",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/install.InitBaseInfoReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/installation/config-file/check": {
            "post": {
                "description": "check config file if exist when installation",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "installation"
                ],
                "summary": "check config file if exist when installation",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/install.CheckConfigFileResp"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/installation/db/check": {
            "post": {
                "description": "check database if exist when installation",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "installation"
                ],
                "summary": "check database if exist when installation",
                "parameters": [
                    {
                        "description": "CheckDatabaseReq",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/install.CheckDatabaseReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "$ref": "#/definitions/install.CheckConfigFileResp"
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/installation/init": {
            "post": {
                "description": "init environment",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "installation"
                ],
                "summary": "init environment",
                "parameters": [
                    {
                        "description": "CheckDatabaseReq",
                        "name": "data",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/install.CheckDatabaseReq"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/installation/language/options": {
            "get": {
                "description": "get installation language options",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Lang"
                ],
                "summary": "get installation language options",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "allOf": [
                                {
                                    "$ref": "#/definitions/handler.RespBody"
                                },
                                {
                                    "type": "object",
                                    "properties": {
                                        "data": {
                                            "type": "array",
                                            "items": {
                                                "$ref": "#/definitions/translator.LangOption"
                                            }
                                        }
                                    }
                                }
                            ]
                        }
                    }
                }
            }
        },
        "/personal/question/page": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "list personal questions",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Personal"
                ],
                "summary": "list personal questions",
                "parameters": [
                    {
                        "type": "string",
                        "default": "string",
                        "description": "username",
                        "name": "username",
                        "in": "query",
                        "required": true
                    },
                    {
                        "enum": [
                            "newest",
                            "score"
                        ],
                        "type": "string",
                        "description": "order",
                        "name": "order",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "default": "0",
                        "description": "page",
                        "name": "page",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "default": "20",
                        "description": "page_size",
                        "name": "page_size",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/handler.RespBody"
                        }
                    }
                }
            }
        },
        "/robots.txt": {
            "get": {
                "description": "get site robots information",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "site"
                ],
                "summary": "get site robots information",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        }
    },
    "definitions": {
        "constant.NotificationChannelKey": {
            "type": "string",
            "enum": [
                "email"
            ],
            "x-enum-varnames": [
                "EmailChannel"
            ]
        },
        "constant.Privilege": {
            "type": "object",
            "properties": {
                "key": {
                    "type": "string"
                },
                "label": {
                    "type": "string"
                },
                "value": {
                    "type": "integer"
                }
            }
        },
        "handler.RespBody": {
            "type": "object",
            "properties": {
                "code": {
                    "description": "http code",
                    "type": "integer"
                },
                "data": {
                    "description": "response data"
                },
                "msg": {
                    "description": "response message",
                    "type": "string"
                },
                "reason": {
                    "description": "reason key",
                    "type": "string"
                }
            }
        },
        "install.CheckConfigFileResp": {
            "type": "object",
            "properties": {
                "config_file_exist": {
                    "type": "boolean"
                },
                "db_connection_success": {
                    "type": "boolean"
                },
                "db_table_exist": {
                    "type": "boolean"
                }
            }
        },
        "install.CheckDatabaseReq": {
            "type": "object",
            "required": [
                "db_type"
            ],
            "properties": {
                "db_file": {
                    "type": "string"
                },
                "db_host": {
                    "type": "string"
                },
                "db_name": {
                    "type": "string"
                },
                "db_password": {
                    "type": "string"
                },
                "db_type": {
                    "type": "string",
                    "enum": [
                        "postgres",
                        "sqlite3",
                        "mysql"
                    ]
                },
                "db_username": {
                    "type": "string"
                }
            }
        },
        "install.InitBaseInfoReq": {
            "type": "object",
            "required": [
                "contact_email",
                "email",
                "lang",
                "name",
                "password",
                "site_name",
                "site_url"
            ],
            "properties": {
                "contact_email": {
                    "type": "string",
                    "maxLength": 500
                },
                "email": {
                    "type": "string",
                    "maxLength": 500
                },
                "lang": {
                    "type": "string",
                    "maxLength": 30
                },
                "login_required": {
                    "type": "boolean"
                },
                "name": {
                    "type": "string",
                    "maxLength": 30
                },
                "password": {
                    "type": "string",
                    "maxLength": 32,
                    "minLength": 8
                },
                "site_name": {
                    "type": "string",
                    "maxLength": 30
                },
                "site_url": {
                    "type": "string",
                    "maxLength": 512
                }
            }
        },
        "pager.PageModel": {
            "type": "object",
            "properties": {
                "count": {
                    "type": "integer"
                },
                "list": {}
            }
        },
        "schema.AcceptAnswerReq": {
            "type": "object",
            "required": [
                "question_id"
            ],
            "properties": {
                "answer_id": {
                    "type": "string"
                },
                "question_id": {
                    "type": "string",
                    "maxLength": 30
                }
            }
        },
        "schema.ActObjectInfo": {
            "type": "object",
            "properties": {
                "answer_id": {
                    "type": "string"
                },
                "display_name": {
                    "type": "string"
                },
                "main_tag_slug_name": {
                    "type": "string"
                },
                "object_type": {
                    "type": "string"
                },
                "question_id": {
                    "type": "string"
                },
                "title": {
                    "type": "string"
                },
                "username": {
                    "type": "string"
                }
            }
        },
        "schema.ActObjectTimeline": {
            "type": "object",
            "properties": {
                "activity_id": {
                    "type": "string"
                },
                "activity_type": {
                    "type": "string"
                },
                "cancelled": {
                    "type": "boolean"
                },
                "cancelled_at": {
                    "type": "integer"
                },
                "comment": {
                    "type": "string"
                },
                "created_at": {
                    "type": "integer"
                },
                "object_id": {
                    "type": "string"
                },
                "object_type": {
                    "type": "string"
                },
                "revision_id": {
                    "type": "string"
                },
                "user_info": {
                    "$ref": "#/definitions/schema.UserBasicInfo"
                }
            }
        },
        "schema.ActionRecordResp": {
            "type": "object",
            "properties": {
                "captcha_id": {
                    "type": "string"
                },
                "captcha_img": {
                    "type": "string"
                },
                "verify": {
                    "type": "boolean"
                }
            }
        },
        "schema.AddCommentReq": {
            "type": "object",
            "required": [
                "object_id",
                "original_text"
            ],
            "properties": {
                "captcha_code": {
                    "type": "string"
                },
                "captcha_id": {
                    "description": "captcha_id",
                    "type": "string"
                },
                "mention_username_list": {
                    "description": "@ user id list",
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "object_id": {
                    "description": "object id",
                    "type": "string"
                },
                "original_text": {
                    "description": "original comment content",
                    "type": "string",
                    "maxLength": 600,
                    "minLength": 2
                },
                "reply_comment_id": {
                    "description": "reply comment id",
                    "type": "string"
                }
            }
        },
        "schema.AddReportReq": {
            "type": "object",
            "required": [
                "object_id",
                "report_type"
            ],
            "properties": {
                "captcha_code": {
                    "type": "string"
                },
                "captcha_id": {
                    "description": "captcha_id",
                    "type": "string"
                },
                "content": {
                    "description": "report content",
                    "type": "string",
                    "maxLength": 500
                },
                "object_id": {
                    "description": "object id",
                    "type": "string",
                    "maxLength": 20
                },
                "report_type": {
                    "description": "report type",
                    "type": "integer"
                }
            }
        },
        "schema.AddTagReq": {
            "type": "object",
            "required": [
                "display_name",
                "original_text",
                "slug_name"
            ],
            "properties": {
                "display_name": {
                    "description": "display_name",
                    "type": "string",
                    "maxLength": 35
                },
                "original_text": {
                    "description": "original text",
                    "type": "string",
                    "maxLength": 65536
                },
                "slug_name": {
                    "description": "slug_name",
                    "type": "string",
                    "maxLength": 35
                }
            }
        },
        "schema.AddUserReq": {
            "type": "object",
            "required": [
                "display_name",
                "email",
                "password"
            ],
            "properties": {
                "display_name": {
                    "type": "string",
                    "maxLength": 30,
                    "minLength": 4
                },
                "email": {
                    "type": "string",
                    "maxLength": 500
                },
                "password": {
                    "type": "string",
                    "maxLength": 32,
                    "minLength": 8
                }
            }
        },
        "schema.AddUsersReq": {
            "type": "object",
            "properties": {
                "users": {
                    "description": "users info line by line",
                    "type": "string"
                }
            }
        },
        "schema.AdminUpdateAnswerStatusReq": {
            "type": "object",
            "required": [
                "answer_id",
                "status"
            ],
            "properties": {
                "answer_id": {
                    "type": "string"
                },
                "status": {
                    "type": "string",
                    "enum": [
                        "available",
                        "deleted"
                    ]
                }
            }
        },
        "schema.AdminUpdateQuestionStatusReq": {
            "type": "object",
            "required": [
                "question_id",
                "status"
            ],
            "properties": {
                "question_id": {
                    "type": "string"
                },
                "status": {
                    "type": "string",
                    "enum": [
                        "available",
                        "closed",
                        "deleted"
                    ]
                }
            }
        },
        "schema.AnswerAddReq": {
            "type": "object",
            "required": [
                "content"
            ],
            "properties": {
                "captcha_code": {
                    "type": "string"
                },
                "captcha_id": {
                    "type": "string"
                },
                "content": {
                    "type": "string",
                    "maxLength": 65535,
                    "minLength": 6
                },
                "question_id": {
                    "type": "string"
                }
            }
        },
        "schema.AnswerUpdateReq": {
            "type": "object",
            "required": [
                "content"
            ],
            "properties": {
                "captcha_code": {
                    "type": "string"
                },
                "captcha_id": {
                    "type": "string"
                },
                "content": {
                    "type": "string",
                    "maxLength": 65535,
                    "minLength": 6
                },
                "edit_summary": {
                    "type": "string"
                },
                "id": {
                    "type": "string"
                },
                "question_id": {
                    "type": "string"
                },
                "title": {
                    "type": "string"
                }
            }
        },
        "schema.AvatarInfo": {
            "type": "object",
            "properties": {
                "custom": {
                    "type": "string",
                    "maxLength": 200
                },
                "gravatar": {
                    "type": "string",
                    "maxLength": 200
                },
                "type": {
                    "type": "string",
                    "maxLength": 100
                }
            }
        },
        "schema.CloseQuestionReq": {
            "type": "object",
            "required": [
                "id"
            ],
            "properties": {
                "close_msg": {
                    "description": "close_type",
                    "type": "string"
                },
                "close_type": {
                    "description": "close_type",
                    "type": "integer"
                },
                "id": {
                    "type": "string"
                }
            }
        },
        "schema.CollectionSwitchReq": {
            "type": "object",
            "required": [
                "group_id",
                "object_id"
            ],
            "properties": {
                "bookmark": {
                    "type": "boolean"
                },
                "group_id": {
                    "type": "string"
                },
                "object_id": {
                    "type": "string"
                }
            }
        },
        "schema.CollectionSwitchResp": {
            "type": "object",
            "properties": {
                "object_collection_count": {
                    "type": "integer"
                }
            }
        },
        "schema.ConfigField": {
            "type": "object",
            "properties": {
                "description": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "options": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/schema.ConfigFieldOption"
                    }
                },
                "required": {
                    "type": "boolean"
                },
                "title": {
                    "type": "string"
                },
                "type": {
                    "type": "string"
                },
                "ui_options": {
                    "$ref": "#/definitions/schema.ConfigFieldUIOptions"
                },
                "value": {}
            }
        },
        "schema.ConfigFieldOption": {
            "type": "object",
            "properties": {
                "label": {
                    "type": "string"
                },
                "value": {
                    "type": "string"
                }
            }
        },
        "schema.ConfigFieldUIOptions": {
            "type": "object",
            "properties": {
                "action": {
                    "$ref": "#/definitions/schema.UIOptionAction"
                },
                "input_type": {
                    "type": "string"
                },
                "label": {
                    "type": "string"
                },
                "placeholder": {
                    "type": "string"
                },
                "rows": {
                    "type": "string"
                },
                "text": {
                    "type": "string"
                },
                "variant": {
                    "type": "string"
                }
            }
        },
        "schema.ConnectorInfoResp": {
            "type": "object",
            "properties": {
                "icon": {
                    "type": "string"
                },
                "link": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                }
            }
        },
        "schema.ConnectorUserInfoResp": {
            "type": "object",
            "properties": {
                "binding": {
                    "type": "boolean"
                },
                "external_id": {
                    "type": "string"
                },
                "icon": {
                    "type": "string"
                },
                "link": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                }
            }
        },
        "schema.ExternalLoginBindingUserSendEmailReq": {
            "type": "object",
            "required": [
                "binding_key",
                "email"
            ],
            "properties": {
                "binding_key": {
                    "type": "string",
                    "maxLength": 100
                },
                "email": {
                    "type": "string",
                    "maxLength": 512
                },
                "must": {
                    "description": "If must is true, whatever email if exists, try to bind user.\nIf must is false, when email exist, will only be prompted with a warning.",
                    "type": "boolean"
                }
            }
        },
        "schema.ExternalLoginBindingUserSendEmailResp": {
            "type": "object",
            "properties": {
                "access_token": {
                    "type": "string"
                },
                "email_exist_and_must_be_confirmed": {
                    "type": "boolean"
                }
            }
        },
        "schema.ExternalLoginUnbindingReq": {
            "type": "object",
            "required": [
                "external_id"
            ],
            "properties": {
                "external_id": {
                    "type": "string",
                    "maxLength": 128
                }
            }
        },
        "schema.FollowReq": {
            "type": "object",
            "required": [
                "object_id"
            ],
            "properties": {
                "is_cancel": {
                    "description": "is cancel",
                    "type": "boolean"
                },
                "object_id": {
                    "description": "object id",
                    "type": "string"
                }
            }
        },
        "schema.FollowResp": {
            "type": "object",
            "properties": {
                "follows": {
                    "description": "the followers of object",
                    "type": "integer"
                },
                "is_followed": {
                    "description": "if user is followed object will be true,otherwise false",
                    "type": "boolean"
                }
            }
        },
        "schema.GetCommentPersonalWithPageResp": {
            "type": "object",
            "properties": {
                "answer_id": {
                    "description": "answer id",
                    "type": "string"
                },
                "comment_id": {
                    "description": "comment id",
                    "type": "string"
                },
                "content": {
                    "description": "content",
                    "type": "string"
                },
                "created_at": {
                    "description": "create time",
                    "type": "integer"
                },
                "object_id": {
                    "description": "object id",
                    "type": "string"
                },
                "object_type": {
                    "description": "object type",
                    "type": "string",
                    "enum": [
                        "question",
                        "answer",
                        "tag",
                        "comment"
                    ]
                },
                "question_id": {
                    "description": "question id",
                    "type": "string"
                },
                "title": {
                    "description": "title",
                    "type": "string"
                },
                "url_title": {
                    "description": "url title",
                    "type": "string"
                }
            }
        },
        "schema.GetCommentResp": {
            "type": "object",
            "properties": {
                "comment_id": {
                    "description": "comment id",
                    "type": "string"
                },
                "created_at": {
                    "description": "create time",
                    "type": "integer"
                },
                "is_vote": {
                    "description": "current user if already vote this comment",
                    "type": "boolean"
                },
                "member_actions": {
                    "description": "MemberActions",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/schema.PermissionMemberAction"
                    }
                },
                "object_id": {
                    "description": "object id",
                    "type": "string"
                },
                "original_text": {
                    "description": "original comment content",
                    "type": "string"
                },
                "parsed_text": {
                    "description": "parsed comment content",
                    "type": "string"
                },
                "reply_comment_id": {
                    "description": "reply comment id",
                    "type": "string"
                },
                "reply_user_display_name": {
                    "description": "reply user display name",
                    "type": "string"
                },
                "reply_user_id": {
                    "description": "reply user id",
                    "type": "string"
                },
                "reply_user_status": {
                    "description": "reply user status",
                    "type": "string"
                },
                "reply_username": {
                    "description": "reply user username",
                    "type": "string"
                },
                "user_avatar": {
                    "description": "user avatar",
                    "type": "string"
                },
                "user_display_name": {
                    "description": "user display name",
                    "type": "string"
                },
                "user_id": {
                    "description": "user id",
                    "type": "string"
                },
                "user_status": {
                    "description": "user status",
                    "type": "string"
                },
                "username": {
                    "description": "username",
                    "type": "string"
                },
                "vote_count": {
                    "description": "user vote amount",
                    "type": "integer"
                }
            }
        },
        "schema.GetCurrentLoginUserInfoResp": {
            "type": "object",
            "properties": {
                "access_token": {
                    "description": "access token",
                    "type": "string"
                },
                "answer_count": {
                    "description": "answer count",
                    "type": "integer"
                },
                "authority_group": {
                    "description": "authority group",
                    "type": "integer"
                },
                "avatar": {
                    "$ref": "#/definitions/schema.AvatarInfo"
                },
                "bio": {
                    "description": "bio markdown",
                    "type": "string"
                },
                "bio_html": {
                    "description": "bio html",
                    "type": "string"
                },
                "created_at": {
                    "description": "create time",
                    "type": "integer"
                },
                "display_name": {
                    "description": "display name",
                    "type": "string"
                },
                "e_mail": {
                    "description": "email",
                    "type": "string"
                },
                "follow_count": {
                    "description": "follow count",
                    "type": "integer"
                },
                "have_password": {
                    "description": "user have password",
                    "type": "boolean"
                },
                "id": {
                    "description": "user id",
                    "type": "string"
                },
                "language": {
                    "description": "language",
                    "type": "string"
                },
                "last_login_date": {
                    "description": "last login date",
                    "type": "integer"
                },
                "location": {
                    "description": "location",
                    "type": "string"
                },
                "mail_status": {
                    "description": "mail status(1 pass 2 to be verified)",
                    "type": "integer"
                },
                "mobile": {
                    "description": "mobile",
                    "type": "string"
                },
                "notice_status": {
                    "description": "notice status(1 on 2off)",
                    "type": "integer"
                },
                "question_count": {
                    "description": "question count",
                    "type": "integer"
                },
                "rank": {
                    "description": "rank",
                    "type": "integer"
                },
                "role_id": {
                    "description": "role id",
                    "type": "integer"
                },
                "status": {
                    "description": "user status",
                    "type": "string"
                },
                "username": {
                    "description": "username",
                    "type": "string"
                },
                "visit_token": {
                    "description": "visit token",
                    "type": "string"
                },
                "website": {
                    "description": "website",
                    "type": "string"
                }
            }
        },
        "schema.GetFollowingTagsResp": {
            "type": "object",
            "properties": {
                "display_name": {
                    "description": "display name",
                    "type": "string"
                },
                "main_tag_slug_name": {
                    "description": "if main tag slug name is not empty, this tag is synonymous with the main tag",
                    "type": "string"
                },
                "recommend": {
                    "type": "boolean"
                },
                "reserved": {
                    "type": "boolean"
                },
                "slug_name": {
                    "description": "slug name",
                    "type": "string"
                },
                "tag_id": {
                    "description": "tag id",
                    "type": "string"
                }
            }
        },
        "schema.GetObjectTimelineResp": {
            "type": "object",
            "properties": {
                "object_info": {
                    "$ref": "#/definitions/schema.ActObjectInfo"
                },
                "timeline": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/schema.ActObjectTimeline"
                    }
                }
            }
        },
        "schema.GetOtherUserInfoByUsernameResp": {
            "type": "object",
            "properties": {
                "answer_count": {
                    "description": "answer count",
                    "type": "integer"
                },
                "avatar": {
                    "description": "avatar",
                    "type": "string"
                },
                "bio": {
                    "description": "bio markdown",
                    "type": "string"
                },
                "bio_html": {
                    "description": "bio html",
                    "type": "string"
                },
                "created_at": {
                    "description": "create time",
                    "type": "integer"
                },
                "display_name": {
                    "description": "display name",
                    "type": "string"
                },
                "follow_count": {
                    "description": "email\nfollow count",
                    "type": "integer"
                },
                "id": {
                    "description": "user id",
                    "type": "string"
                },
                "last_login_date": {
                    "description": "last login date",
                    "type": "integer"
                },
                "location": {
                    "description": "location",
                    "type": "string"
                },
                "mobile": {
                    "description": "mobile",
                    "type": "string"
                },
                "question_count": {
                    "description": "question count",
                    "type": "integer"
                },
                "rank": {
                    "description": "rank",
                    "type": "integer"
                },
                "status": {
                    "type": "string"
                },
                "status_msg": {
                    "type": "string"
                },
                "username": {
                    "description": "username",
                    "type": "string"
                },
                "website": {
                    "description": "website",
                    "type": "string"
                }
            }
        },
        "schema.GetOtherUserInfoResp": {
            "type": "object",
            "properties": {
                "info": {
                    "$ref": "#/definitions/schema.GetOtherUserInfoByUsernameResp"
                }
            }
        },
        "schema.GetPluginConfigResp": {
            "type": "object",
            "properties": {
                "config_fields": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/schema.ConfigField"
                    }
                },
                "description": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "slug_name": {
                    "type": "string"
                },
                "version": {
                    "type": "string"
                }
            }
        },
        "schema.GetPluginListResp": {
            "type": "object",
            "properties": {
                "description": {
                    "type": "string"
                },
                "enabled": {
                    "type": "boolean"
                },
                "have_config": {
                    "type": "boolean"
                },
                "link": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "slug_name": {
                    "type": "string"
                },
                "version": {
                    "type": "string"
                }
            }
        },
        "schema.GetPrivilegesConfigResp": {
            "type": "object",
            "properties": {
                "options": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/schema.PrivilegeOption"
                    }
                },
                "selected_level": {
                    "$ref": "#/definitions/schema.PrivilegeLevel"
                }
            }
        },
        "schema.GetRankPersonalPageResp": {
            "type": "object",
            "properties": {
                "answer_id": {
                    "description": "answer id",
                    "type": "string"
                },
                "content": {
                    "description": "content",
                    "type": "string"
                },
                "created_at": {
                    "description": "create time",
                    "type": "integer"
                },
                "object_id": {
                    "description": "object id",
                    "type": "string"
                },
                "object_type": {
                    "description": "object type",
                    "type": "string",
                    "enum": [
                        "question",
                        "answer",
                        "tag",
                        "comment"
                    ]
                },
                "question_id": {
                    "description": "question id",
                    "type": "string"
                },
                "rank_type": {
                    "description": "rank type",
                    "type": "string"
                },
                "reputation": {
                    "description": "reputation",
                    "type": "integer"
                },
                "title": {
                    "description": "title",
                    "type": "string"
                },
                "url_title": {
                    "description": "url title",
                    "type": "string"
                }
            }
        },
        "schema.GetRevisionResp": {
            "type": "object",
            "properties": {
                "content": {
                    "description": "content parsed"
                },
                "create_at": {
                    "type": "integer"
                },
                "id": {
                    "description": "id",
                    "type": "string"
                },
                "object_id": {
                    "description": "object id",
                    "type": "string"
                },
                "reason": {
                    "type": "string"
                },
                "status": {
                    "description": "revision status(normal: 1; delete 2)",
                    "type": "integer"
                },
                "title": {
                    "description": "title",
                    "type": "string"
                },
                "use_id": {
                    "description": "user id",
                    "type": "string"
                },
                "user_info": {
                    "$ref": "#/definitions/schema.UserBasicInfo"
                }
            }
        },
        "schema.GetRoleResp": {
            "type": "object",
            "properties": {
                "description": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "name": {
                    "type": "string"
                }
            }
        },
        "schema.GetSMTPConfigResp": {
            "type": "object",
            "properties": {
                "encryption": {
                    "description": "\"\" SSL",
                    "type": "string"
                },
                "from_email": {
                    "type": "string"
                },
                "from_name": {
                    "type": "string"
                },
                "smtp_authentication": {
                    "type": "boolean"
                },
                "smtp_host": {
                    "type": "string"
                },
                "smtp_password": {
                    "type": "string"
                },
                "smtp_port": {
                    "type": "integer"
                },
                "smtp_username": {
                    "type": "string"
                }
            }
        },
        "schema.GetSiteLegalInfoResp": {
            "type": "object",
            "properties": {
                "privacy_policy_original_text": {
                    "type": "string"
                },
                "privacy_policy_parsed_text": {
                    "type": "string"
                },
                "terms_of_service_original_text": {
                    "type": "string"
                },
                "terms_of_service_parsed_text": {
                    "type": "string"
                }
            }
        },
        "schema.GetTagPageResp": {
            "type": "object",
            "properties": {
                "created_at": {
                    "description": "created time",
                    "type": "integer"
                },
                "description": {
                    "description": "description",
                    "type": "string"
                },
                "display_name": {
                    "description": "display_name",
                    "type": "string"
                },
                "excerpt": {
                    "description": "excerpt",
                    "type": "string"
                },
                "follow_count": {
                    "description": "follower amount",
                    "type": "integer"
                },
                "is_follower": {
                    "description": "is follower",
                    "type": "boolean"
                },
                "original_text": {
                    "description": "original text",
                    "type": "string"
                },
                "parsed_text": {
                    "description": "parsed_text",
                    "type": "string"
                },
                "question_count": {
                    "description": "question amount",
                    "type": "integer"
                },
                "recommend": {
                    "type": "boolean"
                },
                "reserved": {
                    "type": "boolean"
                },
                "slug_name": {
                    "description": "slug_name",
                    "type": "string"
                },
                "tag_id": {
                    "description": "tag_id",
                    "type": "string"
                },
                "updated_at": {
                    "description": "updated time",
                    "type": "integer"
                }
            }
        },
        "schema.GetTagResp": {
            "type": "object",
            "properties": {
                "created_at": {
                    "type": "integer"
                },
                "description": {
                    "type": "string"
                },
                "display_name": {
                    "type": "string"
                },
                "excerpt": {
                    "type": "string"
                },
                "follow_count": {
                    "type": "integer"
                },
                "is_follower": {
                    "type": "boolean"
                },
                "main_tag_slug_name": {
                    "description": "if main tag slug name is not empty, this tag is synonymous with the main tag",
                    "type": "string"
                },
                "member_actions": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/schema.PermissionMemberAction"
                    }
                },
                "original_text": {
                    "type": "string"
                },
                "parsed_text": {
                    "type": "string"
                },
                "question_count": {
                    "type": "integer"
                },
                "recommend": {
                    "type": "boolean"
                },
                "reserved": {
                    "type": "boolean"
                },
                "slug_name": {
                    "type": "string"
                },
                "status": {
                    "type": "string"
                },
                "tag_id": {
                    "type": "string"
                },
                "updated_at": {
                    "type": "integer"
                }
            }
        },
        "schema.GetTagSynonymsResp": {
            "type": "object",
            "properties": {
                "member_actions": {
                    "description": "MemberActions",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/schema.PermissionMemberAction"
                    }
                },
                "synonyms": {
                    "description": "synonyms",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/schema.TagSynonym"
                    }
                }
            }
        },
        "schema.GetUnreviewedRevisionResp": {
            "type": "object",
            "properties": {
                "info": {
                    "$ref": "#/definitions/schema.UnreviewedRevisionInfoInfo"
                },
                "type": {
                    "type": "string"
                },
                "unreviewed_info": {
                    "$ref": "#/definitions/schema.GetRevisionResp"
                }
            }
        },
        "schema.GetUserActivationResp": {
            "type": "object",
            "properties": {
                "activation_url": {
                    "type": "string"
                }
            }
        },
        "schema.GetUserNotificationConfigResp": {
            "type": "object",
            "properties": {
                "all_new_question": {
                    "$ref": "#/definitions/schema.NotificationChannelConfig"
                },
                "all_new_question_for_following_tags": {
                    "$ref": "#/definitions/schema.NotificationChannelConfig"
                },
                "inbox": {
                    "$ref": "#/definitions/schema.NotificationChannelConfig"
                }
            }
        },
        "schema.GetUserPageResp": {
            "type": "object",
            "properties": {
                "avatar": {
                    "description": "avatar",
                    "type": "string"
                },
                "created_at": {
                    "description": "create time",
                    "type": "integer"
                },
                "deleted_at": {
                    "description": "delete time",
                    "type": "integer"
                },
                "display_name": {
                    "description": "display name",
                    "type": "string"
                },
                "e_mail": {
                    "description": "email",
                    "type": "string"
                },
                "rank": {
                    "description": "rank",
                    "type": "integer"
                },
                "role_id": {
                    "description": "role id",
                    "type": "integer"
                },
                "role_name": {
                    "description": "role name",
                    "type": "string"
                },
                "status": {
                    "description": "user status(normal,suspended,deleted,inactive)",
                    "type": "string"
                },
                "suspended_at": {
                    "description": "suspended time",
                    "type": "integer"
                },
                "user_id": {
                    "description": "user id",
                    "type": "string"
                },
                "username": {
                    "description": "username",
                    "type": "string"
                }
            }
        },
        "schema.GetUserPluginListResp": {
            "type": "object",
            "properties": {
                "name": {
                    "type": "string"
                },
                "slug_name": {
                    "type": "string"
                }
            }
        },
        "schema.GetVoteWithPageResp": {
            "type": "object",
            "properties": {
                "answer_id": {
                    "description": "answer id",
                    "type": "string"
                },
                "content": {
                    "description": "content",
                    "type": "string"
                },
                "created_at": {
                    "description": "create time",
                    "type": "integer"
                },
                "object_id": {
                    "description": "object id",
                    "type": "string"
                },
                "object_type": {
                    "description": "object type",
                    "type": "string",
                    "enum": [
                        "question",
                        "answer",
                        "tag",
                        "comment"
                    ]
                },
                "question_id": {
                    "description": "question id",
                    "type": "string"
                },
                "title": {
                    "description": "title",
                    "type": "string"
                },
                "url_title": {
                    "description": "url title",
                    "type": "string"
                },
                "vote_type": {
                    "description": "vote type",
                    "type": "string"
                }
            }
        },
        "schema.LoadingAction": {
            "type": "object",
            "properties": {
                "state": {
                    "type": "string"
                },
                "text": {
                    "type": "string"
                }
            }
        },
        "schema.NotificationChannelConfig": {
            "type": "object",
            "properties": {
                "enable": {
                    "type": "boolean"
                },
                "key": {
                    "$ref": "#/definitions/constant.NotificationChannelKey"
                }
            }
        },
        "schema.NotificationClearIDRequest": {
            "type": "object",
            "properties": {
                "id": {
                    "type": "string"
                }
            }
        },
        "schema.NotificationClearRequest": {
            "type": "object",
            "properties": {
                "type": {
                    "description": "inbox achievement",
                    "type": "string"
                }
            }
        },
        "schema.OnCompleteAction": {
            "type": "object",
            "properties": {
                "refresh_form_config": {
                    "type": "boolean"
                },
                "toast_return_message": {
                    "type": "boolean"
                }
            }
        },
        "schema.OperationQuestionReq": {
            "type": "object",
            "required": [
                "id"
            ],
            "properties": {
                "id": {
                    "type": "string"
                },
                "operation": {
                    "description": "operation [pin unpin hide show]",
                    "type": "string"
                }
            }
        },
        "schema.PermissionMemberAction": {
            "type": "object",
            "properties": {
                "action": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "type": {
                    "type": "string"
                }
            }
        },
        "schema.PostRenderReq": {
            "type": "object",
            "properties": {
                "content": {
                    "type": "string"
                }
            }
        },
        "schema.PrivilegeLevel": {
            "type": "integer",
            "enum": [
                1,
                2,
                3
            ],
            "x-enum-varnames": [
                "PrivilegeLevel1",
                "PrivilegeLevel2",
                "PrivilegeLevel3"
            ]
        },
        "schema.PrivilegeOption": {
            "type": "object",
            "properties": {
                "level": {
                    "$ref": "#/definitions/schema.PrivilegeLevel"
                },
                "level_desc": {
                    "type": "string"
                },
                "privileges": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/constant.Privilege"
                    }
                }
            }
        },
        "schema.QuestionAdd": {
            "type": "object",
            "required": [
                "content",
                "tags",
                "title"
            ],
            "properties": {
                "captcha_code": {
                    "type": "string"
                },
                "captcha_id": {
                    "description": "captcha_id",
                    "type": "string"
                },
                "content": {
                    "description": "content",
                    "type": "string",
                    "maxLength": 65535,
                    "minLength": 6
                },
                "tags": {
                    "description": "tags",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/schema.TagItem"
                    }
                },
                "title": {
                    "description": "question title",
                    "type": "string",
                    "maxLength": 150,
                    "minLength": 6
                }
            }
        },
        "schema.QuestionAddByAnswer": {
            "type": "object",
            "required": [
                "answer_content",
                "content",
                "tags",
                "title"
            ],
            "properties": {
                "answer_content": {
                    "type": "string",
                    "maxLength": 65535,
                    "minLength": 6
                },
                "captcha_code": {
                    "type": "string"
                },
                "captcha_id": {
                    "description": "captcha_id",
                    "type": "string"
                },
                "content": {
                    "description": "content",
                    "type": "string",
                    "maxLength": 65535,
                    "minLength": 6
                },
                "mention_username_list": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "tags": {
                    "description": "tags",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/schema.TagItem"
                    }
                },
                "title": {
                    "description": "question title",
                    "type": "string",
                    "maxLength": 150,
                    "minLength": 6
                }
            }
        },
        "schema.QuestionPageReq": {
            "type": "object",
            "properties": {
                "in_days": {
                    "type": "integer",
                    "minimum": 1
                },
                "order": {
                    "type": "string",
                    "enum": [
                        "newest",
                        "active",
                        "frequent",
                        "score",
                        "unanswered"
                    ]
                },
                "page": {
                    "type": "integer",
                    "minimum": 1
                },
                "page_size": {
                    "type": "integer",
                    "minimum": 1
                },
                "tag": {
                    "type": "string",
                    "maxLength": 100
                },
                "username": {
                    "type": "string",
                    "maxLength": 100
                }
            }
        },
        "schema.QuestionPageResp": {
            "type": "object",
            "properties": {
                "accepted_answer_id": {
                    "description": "answer information",
                    "type": "string"
                },
                "answer_count": {
                    "type": "integer"
                },
                "collection_count": {
                    "type": "integer"
                },
                "created_at": {
                    "type": "integer"
                },
                "description": {
                    "type": "string"
                },
                "follow_count": {
                    "type": "integer"
                },
                "id": {
                    "type": "string"
                },
                "last_answer_id": {
                    "type": "string"
                },
                "operated_at": {
                    "description": "operator information",
                    "type": "integer"
                },
                "operation_type": {
                    "type": "string"
                },
                "operator": {
                    "$ref": "#/definitions/schema.QuestionPageRespOperator"
                },
                "pin": {
                    "description": "1: unpin, 2: pin",
                    "type": "integer"
                },
                "show": {
                    "description": "0: show, 1: hide",
                    "type": "integer"
                },
                "status": {
                    "type": "integer"
                },
                "tags": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/schema.TagResp"
                    }
                },
                "title": {
                    "type": "string"
                },
                "unique_view_count": {
                    "type": "integer"
                },
                "url_title": {
                    "type": "string"
                },
                "view_count": {
                    "description": "question statistical information",
                    "type": "integer"
                },
                "vote_count": {
                    "type": "integer"
                }
            }
        },
        "schema.QuestionPageRespOperator": {
            "type": "object",
            "properties": {
                "display_name": {
                    "type": "string"
                },
                "id": {
                    "type": "string"
                },
                "rank": {
                    "type": "integer"
                },
                "status": {
                    "type": "string"
                },
                "username": {
                    "type": "string"
                }
            }
        },
        "schema.QuestionRecoverReq": {
            "type": "object",
            "required": [
                "question_id"
            ],
            "properties": {
                "question_id": {
                    "type": "string"
                }
            }
        },
        "schema.QuestionUpdate": {
            "type": "object",
            "required": [
                "content",
                "id",
                "tags",
                "title"
            ],
            "properties": {
                "captcha_code": {
                    "type": "string"
                },
                "captcha_id": {
                    "description": "captcha_id",
                    "type": "string"
                },
                "content": {
                    "description": "content",
                    "type": "string",
                    "maxLength": 65535,
                    "minLength": 6
                },
                "edit_summary": {
                    "description": "edit summary",
                    "type": "string"
                },
                "id": {
                    "description": "question id",
                    "type": "string"
                },
                "invite_user": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "tags": {
                    "description": "tags",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/schema.TagItem"
                    }
                },
                "title": {
                    "description": "question title",
                    "type": "string",
                    "maxLength": 150,
                    "minLength": 6
                }
            }
        },
        "schema.QuestionUpdateInviteUser": {
            "type": "object",
            "required": [
                "id"
            ],
            "properties": {
                "captcha_code": {
                    "type": "string"
                },
                "captcha_id": {
                    "description": "captcha_id",
                    "type": "string"
                },
                "id": {
                    "type": "string"
                },
                "invite_user": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                }
            }
        },
        "schema.RecoverAnswerReq": {
            "type": "object",
            "required": [
                "answer_id"
            ],
            "properties": {
                "answer_id": {
                    "type": "string"
                }
            }
        },
        "schema.RecoverTagReq": {
            "type": "object",
            "required": [
                "tag_id"
            ],
            "properties": {
                "tag_id": {
                    "type": "string"
                }
            }
        },
        "schema.RemoveAnswerReq": {
            "type": "object",
            "required": [
                "id"
            ],
            "properties": {
                "captcha_code": {
                    "type": "string"
                },
                "captcha_id": {
                    "type": "string"
                },
                "id": {
                    "type": "string"
                }
            }
        },
        "schema.RemoveCommentReq": {
            "type": "object",
            "required": [
                "comment_id"
            ],
            "properties": {
                "captcha_code": {
                    "type": "string"
                },
                "captcha_id": {
                    "description": "captcha_id",
                    "type": "string"
                },
                "comment_id": {
                    "description": "comment id",
                    "type": "string"
                }
            }
        },
        "schema.RemoveQuestionReq": {
            "type": "object",
            "required": [
                "id"
            ],
            "properties": {
                "captcha_code": {
                    "type": "string"
                },
                "captcha_id": {
                    "description": "captcha_id",
                    "type": "string"
                },
                "id": {
                    "description": "question id",
                    "type": "string"
                }
            }
        },
        "schema.RemoveTagReq": {
            "type": "object",
            "required": [
                "tag_id"
            ],
            "properties": {
                "tag_id": {
                    "description": "tag_id",
                    "type": "string"
                }
            }
        },
        "schema.ReopenQuestionReq": {
            "type": "object",
            "properties": {
                "question_id": {
                    "type": "string"
                }
            }
        },
        "schema.ReportHandleReq": {
            "type": "object",
            "required": [
                "flagged_type",
                "id"
            ],
            "properties": {
                "flagged_content": {
                    "type": "string"
                },
                "flagged_type": {
                    "type": "integer"
                },
                "id": {
                    "type": "string"
                }
            }
        },
        "schema.RevisionAuditReq": {
            "type": "object",
            "required": [
                "id",
                "operation"
            ],
            "properties": {
                "id": {
                    "description": "object id",
                    "type": "string"
                },
                "operation": {
                    "description": "approve or reject",
                    "type": "string"
                }
            }
        },
        "schema.SearchObject": {
            "type": "object",
            "properties": {
                "accepted": {
                    "type": "boolean"
                },
                "answer_count": {
                    "type": "integer"
                },
                "created_at": {
                    "type": "integer"
                },
                "excerpt": {
                    "type": "string"
                },
                "id": {
                    "type": "string"
                },
                "question_id": {
                    "type": "string"
                },
                "status": {
                    "description": "Status",
                    "type": "string"
                },
                "tags": {
                    "description": "tags",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/schema.TagResp"
                    }
                },
                "title": {
                    "type": "string"
                },
                "url_title": {
                    "type": "string"
                },
                "user_info": {
                    "description": "user info",
                    "allOf": [
                        {
                            "$ref": "#/definitions/schema.SearchObjectUser"
                        }
                    ]
                },
                "vote_count": {
                    "type": "integer"
                }
            }
        },
        "schema.SearchObjectUser": {
            "type": "object",
            "properties": {
                "display_name": {
                    "type": "string"
                },
                "id": {
                    "type": "string"
                },
                "rank": {
                    "type": "integer"
                },
                "status": {
                    "type": "string"
                },
                "username": {
                    "type": "string"
                }
            }
        },
        "schema.SearchResp": {
            "type": "object",
            "properties": {
                "count": {
                    "type": "integer"
                },
                "list": {
                    "description": "search response",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/schema.SearchResult"
                    }
                }
            }
        },
        "schema.SearchResult": {
            "type": "object",
            "properties": {
                "object": {
                    "description": "this object",
                    "allOf": [
                        {
                            "$ref": "#/definitions/schema.SearchObject"
                        }
                    ]
                },
                "object_type": {
                    "description": "object_type",
                    "type": "string"
                }
            }
        },
        "schema.SendUserActivationReq": {
            "type": "object",
            "required": [
                "user_id"
            ],
            "properties": {
                "user_id": {
                    "type": "string"
                }
            }
        },
        "schema.SiteBrandingReq": {
            "type": "object",
            "properties": {
                "favicon": {
                    "type": "string",
                    "maxLength": 512
                },
                "logo": {
                    "type": "string",
                    "maxLength": 512
                },
                "mobile_logo": {
                    "type": "string",
                    "maxLength": 512
                },
                "square_icon": {
                    "type": "string",
                    "maxLength": 512
                }
            }
        },
        "schema.SiteBrandingResp": {
            "type": "object",
            "properties": {
                "favicon": {
                    "type": "string",
                    "maxLength": 512
                },
                "logo": {
                    "type": "string",
                    "maxLength": 512
                },
                "mobile_logo": {
                    "type": "string",
                    "maxLength": 512
                },
                "square_icon": {
                    "type": "string",
                    "maxLength": 512
                }
            }
        },
        "schema.SiteCustomCssHTMLReq": {
            "type": "object",
            "properties": {
                "custom_css": {
                    "type": "string",
                    "maxLength": 65536
                },
                "custom_footer": {
                    "type": "string",
                    "maxLength": 65536
                },
                "custom_head": {
                    "type": "string",
                    "maxLength": 65536
                },
                "custom_header": {
                    "type": "string",
                    "maxLength": 65536
                },
                "custom_sidebar": {
                    "type": "string",
                    "maxLength": 65536
                }
            }
        },
        "schema.SiteCustomCssHTMLResp": {
            "type": "object",
            "properties": {
                "custom_css": {
                    "type": "string",
                    "maxLength": 65536
                },
                "custom_footer": {
                    "type": "string",
                    "maxLength": 65536
                },
                "custom_head": {
                    "type": "string",
                    "maxLength": 65536
                },
                "custom_header": {
                    "type": "string",
                    "maxLength": 65536
                },
                "custom_sidebar": {
                    "type": "string",
                    "maxLength": 65536
                }
            }
        },
        "schema.SiteGeneralReq": {
            "type": "object",
            "required": [
                "contact_email",
                "name",
                "site_url"
            ],
            "properties": {
                "contact_email": {
                    "type": "string",
                    "maxLength": 512
                },
                "description": {
                    "type": "string",
                    "maxLength": 2000
                },
                "name": {
                    "type": "string",
                    "maxLength": 128
                },
                "short_description": {
                    "type": "string",
                    "maxLength": 255
                },
                "site_url": {
                    "type": "string",
                    "maxLength": 512
                }
            }
        },
        "schema.SiteGeneralResp": {
            "type": "object",
            "required": [
                "contact_email",
                "name",
                "site_url"
            ],
            "properties": {
                "contact_email": {
                    "type": "string",
                    "maxLength": 512
                },
                "description": {
                    "type": "string",
                    "maxLength": 2000
                },
                "name": {
                    "type": "string",
                    "maxLength": 128
                },
                "short_description": {
                    "type": "string",
                    "maxLength": 255
                },
                "site_url": {
                    "type": "string",
                    "maxLength": 512
                }
            }
        },
        "schema.SiteInfoResp": {
            "type": "object",
            "properties": {
                "branding": {
                    "$ref": "#/definitions/schema.SiteBrandingResp"
                },
                "custom_css_html": {
                    "$ref": "#/definitions/schema.SiteCustomCssHTMLResp"
                },
                "general": {
                    "$ref": "#/definitions/schema.SiteGeneralResp"
                },
                "interface": {
                    "$ref": "#/definitions/schema.SiteInterfaceResp"
                },
                "login": {
                    "$ref": "#/definitions/schema.SiteLoginResp"
                },
                "revision": {
                    "type": "string"
                },
                "site_seo": {
                    "$ref": "#/definitions/schema.SiteSeoResp"
                },
                "site_users": {
                    "$ref": "#/definitions/schema.SiteUsersResp"
                },
                "site_write": {
                    "$ref": "#/definitions/schema.SiteWriteResp"
                },
                "theme": {
                    "$ref": "#/definitions/schema.SiteThemeResp"
                },
                "version": {
                    "type": "string"
                }
            }
        },
        "schema.SiteInterfaceReq": {
            "type": "object",
            "required": [
                "language",
                "time_zone"
            ],
            "properties": {
                "language": {
                    "type": "string",
                    "maxLength": 128
                },
                "time_zone": {
                    "type": "string",
                    "maxLength": 128
                }
            }
        },
        "schema.SiteInterfaceResp": {
            "type": "object",
            "required": [
                "language",
                "time_zone"
            ],
            "properties": {
                "language": {
                    "type": "string",
                    "maxLength": 128
                },
                "time_zone": {
                    "type": "string",
                    "maxLength": 128
                }
            }
        },
        "schema.SiteLegalReq": {
            "type": "object",
            "properties": {
                "privacy_policy_original_text": {
                    "type": "string"
                },
                "privacy_policy_parsed_text": {
                    "type": "string"
                },
                "terms_of_service_original_text": {
                    "type": "string"
                },
                "terms_of_service_parsed_text": {
                    "type": "string"
                }
            }
        },
        "schema.SiteLegalResp": {
            "type": "object",
            "properties": {
                "privacy_policy_original_text": {
                    "type": "string"
                },
                "privacy_policy_parsed_text": {
                    "type": "string"
                },
                "terms_of_service_original_text": {
                    "type": "string"
                },
                "terms_of_service_parsed_text": {
                    "type": "string"
                }
            }
        },
        "schema.SiteLoginReq": {
            "type": "object",
            "properties": {
                "allow_email_domains": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "allow_email_registrations": {
                    "type": "boolean"
                },
                "allow_new_registrations": {
                    "type": "boolean"
                },
                "allow_password_login": {
                    "type": "boolean"
                },
                "login_required": {
                    "type": "boolean"
                }
            }
        },
        "schema.SiteLoginResp": {
            "type": "object",
            "properties": {
                "allow_email_domains": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "allow_email_registrations": {
                    "type": "boolean"
                },
                "allow_new_registrations": {
                    "type": "boolean"
                },
                "allow_password_login": {
                    "type": "boolean"
                },
                "login_required": {
                    "type": "boolean"
                }
            }
        },
        "schema.SiteSeoReq": {
            "type": "object",
            "required": [
                "permalink",
                "robots"
            ],
            "properties": {
                "permalink": {
                    "type": "integer",
                    "maximum": 4,
                    "minimum": 0
                },
                "robots": {
                    "type": "string"
                }
            }
        },
        "schema.SiteSeoResp": {
            "type": "object",
            "required": [
                "permalink",
                "robots"
            ],
            "properties": {
                "permalink": {
                    "type": "integer",
                    "maximum": 4,
                    "minimum": 0
                },
                "robots": {
                    "type": "string"
                }
            }
        },
        "schema.SiteThemeReq": {
            "type": "object",
            "required": [
                "theme"
            ],
            "properties": {
                "theme": {
                    "type": "string",
                    "maxLength": 255
                },
                "theme_config": {
                    "type": "object",
                    "additionalProperties": true
                }
            }
        },
        "schema.SiteThemeResp": {
            "type": "object",
            "properties": {
                "theme": {
                    "type": "string"
                },
                "theme_config": {
                    "type": "object",
                    "additionalProperties": true
                },
                "theme_options": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/schema.ThemeOption"
                    }
                }
            }
        },
        "schema.SiteUsersReq": {
            "type": "object",
            "required": [
                "default_avatar"
            ],
            "properties": {
                "allow_update_avatar": {
                    "type": "boolean"
                },
                "allow_update_bio": {
                    "type": "boolean"
                },
                "allow_update_display_name": {
                    "type": "boolean"
                },
                "allow_update_location": {
                    "type": "boolean"
                },
                "allow_update_username": {
                    "type": "boolean"
                },
                "allow_update_website": {
                    "type": "boolean"
                },
                "default_avatar": {
                    "type": "string",
                    "enum": [
                        "system",
                        "gravatar"
                    ]
                },
                "gravatar_base_url": {
                    "type": "string"
                }
            }
        },
        "schema.SiteUsersResp": {
            "type": "object",
            "required": [
                "default_avatar"
            ],
            "properties": {
                "allow_update_avatar": {
                    "type": "boolean"
                },
                "allow_update_bio": {
                    "type": "boolean"
                },
                "allow_update_display_name": {
                    "type": "boolean"
                },
                "allow_update_location": {
                    "type": "boolean"
                },
                "allow_update_username": {
                    "type": "boolean"
                },
                "allow_update_website": {
                    "type": "boolean"
                },
                "default_avatar": {
                    "type": "string",
                    "enum": [
                        "system",
                        "gravatar"
                    ]
                },
                "gravatar_base_url": {
                    "type": "string"
                }
            }
        },
        "schema.SiteWriteReq": {
            "type": "object",
            "properties": {
                "recommend_tags": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "required_tag": {
                    "type": "boolean"
                },
                "reserved_tags": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "restrict_answer": {
                    "type": "boolean"
                }
            }
        },
        "schema.SiteWriteResp": {
            "type": "object",
            "properties": {
                "recommend_tags": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "required_tag": {
                    "type": "boolean"
                },
                "reserved_tags": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "restrict_answer": {
                    "type": "boolean"
                }
            }
        },
        "schema.TagItem": {
            "type": "object",
            "properties": {
                "display_name": {
                    "description": "display_name",
                    "type": "string",
                    "maxLength": 35
                },
                "original_text": {
                    "description": "original text",
                    "type": "string"
                },
                "slug_name": {
                    "description": "slug_name",
                    "type": "string",
                    "maxLength": 35
                }
            }
        },
        "schema.TagResp": {
            "type": "object",
            "properties": {
                "display_name": {
                    "type": "string"
                },
                "main_tag_slug_name": {
                    "description": "if main tag slug name is not empty, this tag is synonymous with the main tag",
                    "type": "string"
                },
                "recommend": {
                    "type": "boolean"
                },
                "reserved": {
                    "type": "boolean"
                },
                "slug_name": {
                    "type": "string"
                }
            }
        },
        "schema.TagSynonym": {
            "type": "object",
            "properties": {
                "display_name": {
                    "description": "display name",
                    "type": "string"
                },
                "main_tag_slug_name": {
                    "description": "if main tag slug name is not empty, this tag is synonymous with the main tag",
                    "type": "string"
                },
                "slug_name": {
                    "description": "slug name",
                    "type": "string"
                },
                "tag_id": {
                    "description": "tag id",
                    "type": "string"
                }
            }
        },
        "schema.ThemeOption": {
            "type": "object",
            "properties": {
                "label": {
                    "type": "string"
                },
                "value": {
                    "type": "string"
                }
            }
        },
        "schema.UIOptionAction": {
            "type": "object",
            "properties": {
                "loading": {
                    "$ref": "#/definitions/schema.LoadingAction"
                },
                "method": {
                    "type": "string"
                },
                "on_complete": {
                    "$ref": "#/definitions/schema.OnCompleteAction"
                },
                "url": {
                    "type": "string"
                }
            }
        },
        "schema.UnreviewedRevisionInfoInfo": {
            "type": "object",
            "properties": {
                "content": {
                    "type": "string"
                },
                "html": {
                    "type": "string"
                },
                "object_id": {
                    "type": "string"
                },
                "tags": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/schema.TagResp"
                    }
                },
                "title": {
                    "type": "string"
                }
            }
        },
        "schema.UpdateCommentReq": {
            "type": "object",
            "required": [
                "comment_id",
                "original_text"
            ],
            "properties": {
                "captcha_code": {
                    "type": "string"
                },
                "captcha_id": {
                    "description": "whether user can delete it",
                    "type": "string"
                },
                "comment_id": {
                    "description": "comment id",
                    "type": "string"
                },
                "original_text": {
                    "description": "original comment content",
                    "type": "string",
                    "maxLength": 600,
                    "minLength": 2
                }
            }
        },
        "schema.UpdateFollowTagsReq": {
            "type": "object",
            "properties": {
                "slug_name_list": {
                    "description": "tag slug name list",
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                }
            }
        },
        "schema.UpdateInfoRequest": {
            "type": "object",
            "properties": {
                "avatar": {
                    "$ref": "#/definitions/schema.AvatarInfo"
                },
                "bio": {
                    "type": "string",
                    "maxLength": 4096
                },
                "display_name": {
                    "type": "string",
                    "maxLength": 30
                },
                "location": {
                    "type": "string",
                    "maxLength": 100
                },
                "username": {
                    "type": "string",
                    "maxLength": 30
                },
                "website": {
                    "type": "string",
                    "maxLength": 500
                }
            }
        },
        "schema.UpdatePluginConfigReq": {
            "type": "object",
            "required": [
                "plugin_slug_name"
            ],
            "properties": {
                "config_fields": {
                    "type": "object",
                    "additionalProperties": {}
                },
                "plugin_slug_name": {
                    "type": "string",
                    "maxLength": 100
                }
            }
        },
        "schema.UpdatePluginStatusReq": {
            "type": "object",
            "required": [
                "plugin_slug_name"
            ],
            "properties": {
                "enabled": {
                    "type": "boolean"
                },
                "plugin_slug_name": {
                    "type": "string",
                    "maxLength": 100
                }
            }
        },
        "schema.UpdatePrivilegesConfigReq": {
            "type": "object",
            "required": [
                "level"
            ],
            "properties": {
                "level": {
                    "maximum": 3,
                    "minimum": 1,
                    "allOf": [
                        {
                            "$ref": "#/definitions/schema.PrivilegeLevel"
                        }
                    ]
                }
            }
        },
        "schema.UpdateSMTPConfigReq": {
            "type": "object",
            "properties": {
                "encryption": {
                    "description": "\"\" SSL",
                    "type": "string",
                    "enum": [
                        "SSL"
                    ]
                },
                "from_email": {
                    "type": "string",
                    "maxLength": 256
                },
                "from_name": {
                    "type": "string",
                    "maxLength": 256
                },
                "smtp_authentication": {
                    "type": "boolean"
                },
                "smtp_host": {
                    "type": "string",
                    "maxLength": 256
                },
                "smtp_password": {
                    "type": "string",
                    "maxLength": 256
                },
                "smtp_port": {
                    "type": "integer",
                    "maximum": 65535,
                    "minimum": 1
                },
                "smtp_username": {
                    "type": "string",
                    "maxLength": 256
                },
                "test_email_recipient": {
                    "type": "string"
                }
            }
        },
        "schema.UpdateTagReq": {
            "type": "object",
            "required": [
                "tag_id"
            ],
            "properties": {
                "display_name": {
                    "description": "display_name",
                    "type": "string",
                    "maxLength": 35
                },
                "edit_summary": {
                    "description": "edit summary",
                    "type": "string"
                },
                "original_text": {
                    "description": "original text",
                    "type": "string"
                },
                "slug_name": {
                    "description": "slug_name",
                    "type": "string",
                    "maxLength": 35
                },
                "tag_id": {
                    "description": "tag_id",
                    "type": "string"
                }
            }
        },
        "schema.UpdateTagSynonymReq": {
            "type": "object",
            "required": [
                "synonym_tag_list",
                "tag_id"
            ],
            "properties": {
                "synonym_tag_list": {
                    "description": "synonym tag list",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/schema.TagItem"
                    }
                },
                "tag_id": {
                    "description": "tag_id",
                    "type": "string"
                }
            }
        },
        "schema.UpdateUserInterfaceRequest": {
            "type": "object",
            "required": [
                "language"
            ],
            "properties": {
                "language": {
                    "description": "language",
                    "type": "string",
                    "maxLength": 100
                }
            }
        },
        "schema.UpdateUserNotificationConfigReq": {
            "type": "object",
            "properties": {
                "all_new_question": {
                    "$ref": "#/definitions/schema.NotificationChannelConfig"
                },
                "all_new_question_for_following_tags": {
                    "$ref": "#/definitions/schema.NotificationChannelConfig"
                },
                "inbox": {
                    "$ref": "#/definitions/schema.NotificationChannelConfig"
                }
            }
        },
        "schema.UpdateUserPasswordReq": {
            "type": "object",
            "required": [
                "password",
                "user_id"
            ],
            "properties": {
                "password": {
                    "type": "string",
                    "maxLength": 32,
                    "minLength": 8
                },
                "user_id": {
                    "type": "string"
                }
            }
        },
        "schema.UpdateUserPluginConfigReq": {
            "type": "object",
            "required": [
                "plugin_slug_name"
            ],
            "properties": {
                "config_fields": {
                    "type": "object",
                    "additionalProperties": {}
                },
                "plugin_slug_name": {
                    "type": "string",
                    "maxLength": 100
                }
            }
        },
        "schema.UpdateUserRoleReq": {
            "type": "object",
            "required": [
                "role_id",
                "user_id"
            ],
            "properties": {
                "role_id": {
                    "description": "role id",
                    "type": "integer"
                },
                "user_id": {
                    "description": "user id",
                    "type": "string"
                }
            }
        },
        "schema.UpdateUserStatusReq": {
            "type": "object",
            "required": [
                "status",
                "user_id"
            ],
            "properties": {
                "remove_all_content": {
                    "type": "boolean"
                },
                "status": {
                    "type": "string",
                    "enum": [
                        "normal",
                        "suspended",
                        "deleted",
                        "inactive"
                    ]
                },
                "user_id": {
                    "type": "string"
                }
            }
        },
        "schema.UserBasicInfo": {
            "type": "object",
            "properties": {
                "avatar": {
                    "type": "string"
                },
                "display_name": {
                    "type": "string"
                },
                "id": {
                    "type": "string"
                },
                "location": {
                    "type": "string"
                },
                "rank": {
                    "type": "integer"
                },
                "status": {
                    "type": "string"
                },
                "username": {
                    "type": "string"
                },
                "website": {
                    "type": "string"
                }
            }
        },
        "schema.UserChangeEmailSendCodeReq": {
            "type": "object",
            "required": [
                "e_mail"
            ],
            "properties": {
                "captcha_code": {
                    "type": "string",
                    "maxLength": 500
                },
                "captcha_id": {
                    "type": "string",
                    "maxLength": 500
                },
                "e_mail": {
                    "type": "string",
                    "maxLength": 500
                },
                "pass": {
                    "type": "string",
                    "maxLength": 32,
                    "minLength": 8
                }
            }
        },
        "schema.UserChangeEmailVerifyReq": {
            "type": "object",
            "required": [
                "code"
            ],
            "properties": {
                "code": {
                    "type": "string",
                    "maxLength": 500
                }
            }
        },
        "schema.UserEmailLoginReq": {
            "type": "object",
            "required": [
                "e_mail",
                "pass"
            ],
            "properties": {
                "captcha_code": {
                    "type": "string"
                },
                "captcha_id": {
                    "type": "string"
                },
                "e_mail": {
                    "type": "string",
                    "maxLength": 500
                },
                "pass": {
                    "type": "string",
                    "maxLength": 32,
                    "minLength": 8
                }
            }
        },
        "schema.UserLoginResp": {
            "type": "object",
            "properties": {
                "access_token": {
                    "description": "access token",
                    "type": "string"
                },
                "answer_count": {
                    "description": "answer count",
                    "type": "integer"
                },
                "authority_group": {
                    "description": "authority group",
                    "type": "integer"
                },
                "avatar": {
                    "description": "avatar",
                    "type": "string"
                },
                "bio": {
                    "description": "bio markdown",
                    "type": "string"
                },
                "bio_html": {
                    "description": "bio html",
                    "type": "string"
                },
                "created_at": {
                    "description": "create time",
                    "type": "integer"
                },
                "display_name": {
                    "description": "display name",
                    "type": "string"
                },
                "e_mail": {
                    "description": "email",
                    "type": "string"
                },
                "follow_count": {
                    "description": "follow count",
                    "type": "integer"
                },
                "have_password": {
                    "description": "user have password",
                    "type": "boolean"
                },
                "id": {
                    "description": "user id",
                    "type": "string"
                },
                "language": {
                    "description": "language",
                    "type": "string"
                },
                "last_login_date": {
                    "description": "last login date",
                    "type": "integer"
                },
                "location": {
                    "description": "location",
                    "type": "string"
                },
                "mail_status": {
                    "description": "mail status(1 pass 2 to be verified)",
                    "type": "integer"
                },
                "mobile": {
                    "description": "mobile",
                    "type": "string"
                },
                "notice_status": {
                    "description": "notice status(1 on 2off)",
                    "type": "integer"
                },
                "question_count": {
                    "description": "question count",
                    "type": "integer"
                },
                "rank": {
                    "description": "rank",
                    "type": "integer"
                },
                "role_id": {
                    "description": "role id",
                    "type": "integer"
                },
                "status": {
                    "description": "user status",
                    "type": "string"
                },
                "username": {
                    "description": "username",
                    "type": "string"
                },
                "visit_token": {
                    "description": "visit token",
                    "type": "string"
                },
                "website": {
                    "description": "website",
                    "type": "string"
                }
            }
        },
        "schema.UserModifyPasswordReq": {
            "type": "object",
            "required": [
                "pass"
            ],
            "properties": {
                "captcha_code": {
                    "type": "string",
                    "maxLength": 500
                },
                "captcha_id": {
                    "type": "string",
                    "maxLength": 500
                },
                "old_pass": {
                    "type": "string",
                    "maxLength": 32,
                    "minLength": 8
                },
                "pass": {
                    "type": "string",
                    "maxLength": 32,
                    "minLength": 8
                }
            }
        },
        "schema.UserRankingResp": {
            "type": "object",
            "properties": {
                "staffs": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/schema.UserRankingSimpleInfo"
                    }
                },
                "users_with_the_most_reputation": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/schema.UserRankingSimpleInfo"
                    }
                },
                "users_with_the_most_vote": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/schema.UserRankingSimpleInfo"
                    }
                }
            }
        },
        "schema.UserRankingSimpleInfo": {
            "type": "object",
            "properties": {
                "avatar": {
                    "description": "avatar",
                    "type": "string"
                },
                "display_name": {
                    "description": "display name",
                    "type": "string"
                },
                "rank": {
                    "description": "rank",
                    "type": "integer"
                },
                "username": {
                    "description": "username",
                    "type": "string"
                },
                "vote_count": {
                    "description": "vote",
                    "type": "integer"
                }
            }
        },
        "schema.UserRePassWordRequest": {
            "type": "object",
            "required": [
                "code",
                "pass"
            ],
            "properties": {
                "code": {
                    "type": "string",
                    "maxLength": 100
                },
                "pass": {
                    "type": "string",
                    "maxLength": 32
                }
            }
        },
        "schema.UserRegisterReq": {
            "type": "object",
            "required": [
                "e_mail",
                "name",
                "pass"
            ],
            "properties": {
                "captcha_code": {
                    "type": "string"
                },
                "captcha_id": {
                    "type": "string"
                },
                "e_mail": {
                    "type": "string",
                    "maxLength": 500
                },
                "name": {
                    "type": "string",
                    "maxLength": 30
                },
                "pass": {
                    "type": "string",
                    "maxLength": 32,
                    "minLength": 8
                }
            }
        },
        "schema.UserRetrievePassWordRequest": {
            "type": "object",
            "required": [
                "e_mail"
            ],
            "properties": {
                "captcha_code": {
                    "type": "string"
                },
                "captcha_id": {
                    "type": "string"
                },
                "e_mail": {
                    "type": "string",
                    "maxLength": 500
                }
            }
        },
        "schema.UserUnsubscribeNotificationReq": {
            "type": "object",
            "required": [
                "code"
            ],
            "properties": {
                "code": {
                    "type": "string",
                    "maxLength": 500
                }
            }
        },
        "schema.VoteReq": {
            "type": "object",
            "required": [
                "object_id"
            ],
            "properties": {
                "captcha_code": {
                    "type": "string"
                },
                "captcha_id": {
                    "description": "captcha_id",
                    "type": "string"
                },
                "is_cancel": {
                    "description": "is cancel",
                    "type": "boolean"
                },
                "object_id": {
                    "description": "id",
                    "type": "string"
                }
            }
        },
        "schema.VoteResp": {
            "type": "object",
            "properties": {
                "down_votes": {
                    "type": "integer"
                },
                "up_votes": {
                    "type": "integer"
                },
                "vote_status": {
                    "type": "string"
                },
                "votes": {
                    "type": "integer"
                }
            }
        },
        "translator.LangOption": {
            "type": "object",
            "properties": {
                "label": {
                    "type": "string"
                },
                "progress": {
                    "description": "Translation completion percentage",
                    "type": "integer"
                },
                "value": {
                    "type": "string"
                }
            }
        }
    },
    "securityDefinitions": {
        "ApiKeyAuth": {
            "type": "apiKey",
            "name": "Authorization",
            "in": "header"
        }
    }
}`

// SwaggerInfo holds exported Swagger Info so clients can modify it
var SwaggerInfo = &swag.Spec{
	Version:          "",
	Host:             "",
	BasePath:         "",
	Schemes:          []string{},
	Title:            "",
	Description:      "",
	InfoInstanceName: "swagger",
	SwaggerTemplate:  docTemplate,
	LeftDelim:        "{{",
	RightDelim:       "}}",
}

func init() {
	swag.Register(SwaggerInfo.InstanceName(), SwaggerInfo)
}
