/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

define(['require', 'tour'], function (require, TourJs) {
  'use strict';

  var TourJs = {};
  var tour = '';
  TourJs.Start = function () {
    var getTourElement = function () {
      return tour._options.steps[tour._current].element;
    };
    tour = new Tour({
      name: "tour",
      steps: [{
        element: $('[data-id="troubleshoot"]').get(0),
        content: "Welcome to Log Search!  Choose Troubleshooting to display high-level log and usage aggregates for all services and components in your cluster.",
        placement: "right"
      }, {
        element: $('#troubleShootHeader').get(0),
        content: "Choose a Service to display high-level information about that service. Optionally, filter by components and apply a specific diagnostic time frame.",
        placement: "bottom"
      }, {
        element: $('div[data-id="dateRange"] .selectDateRange').get(0),
        content: "Click the Date-Time picker and choose a pre-defined time slot or specify date and time values.",
        placement: "top"
      }, {
        element: $("#showServicelog").get(0),
        content: "Choose Go To Logs to further refine your examination of Service Logs for a selected service.",
        placement: "top"
      }, {
        element: $('[data-id="hierarchy"]').get(0),
        content: "Service Logs displays a high-level history of logs generated by a selected service and allows you to filter logs by component. You control your view of log data per component and host, Choose to view aggregate Service Logs or drill into details of each log message.",
        placement: "right"
      }, {
        element: $("#searchIncludeExclude").get(0),
        content: "This filter allows you to query the log data column wise(log_message, level, host etc). Include Search is basically \"or\" condition and Exclude Search is \"and\" condition between multiple input.",
        placement: "bottom"
      }, {
        element: $("#compInculdeExculde").get(0),
        content: "This filter allows you to filter the log data depending upon the component selection. Include Component is again \"or\" condition and Exclude Component is \"and\" condition between multiple selection.",
        placement: "bottom"
      }, {
        element: $('[data-id="startStop"]').get(0),
        content: "Snapshot helps you quickly see all logs generated while you reproduce an issue. Click start, reproduce your issue, click stop and we'll load all logs that were produced during that time frame.",
        placement: "bottom"
      }, {
        element: $('#r_Histogram').get(0),
        content: "Histogram displays comparative ratios of log severity during the currently defined time filter.",
        placement: "top"
      }, {
        element: document.querySelectorAll('#r_BubbleTable')[1],
        content: "The Log Data default view displays consolidated for all hosts.",
        placement: "top",
      }, {
        element: document.querySelectorAll('#r_BubbleTable')[1],
        content: "Expand the Log Data tree view and choose components to further refine your diagnostics.",
        placement: "top",
      }, {
        element: $(document.querySelectorAll('#r_BubbleTable')[1]).find('.box-content')[1],
        content: "Choose the blue arrow icon to view logs for a specific component on a new tab.",
        placement: "right",
      }, {
        element: document.querySelectorAll('#r_BubbleTable')[1],
        content: "Choose Service Logs to show a column-separated view of actual log entries.",
        placement: "top",
      }, {
        element: $(document.querySelectorAll('#r_BubbleTable')[1]).find('td.logTime:first').get(0),
        content: "The Log Time column lists a consolidated view of filtered log entries for the selected service.",
        placement: "top"
      }, {
        element: $('li[data-id="audit"]').get(0),
        content: "The Access Logs tab displays access information across services and their components. You can create different views and aggregations and apply filters for viewing access log details.",
        placement: "right"
      }, {
        element: $('#r_AuditLine').get(0),
        content: "The Line section shows component access during a specific time frame.",
        placement: "bottom"
      }, {
        element: $('#AuditSearch').get(0),
        content: "This filter allows you to query Access log data column- wise (Access Enforcer, Access type etc). Include Search applies the \"or\" condition and Exclude Search the \"and\" condition between multiple inputs.",
        placement: "top"
      }, {
        element: $('li[data-id="createFilters"]').get(0),
        content: "The Log Feeder Filter feature supports limiting data handled by LogSearch. For example, you can limit logs tracked by LogSearch to only those logs with level ERROR or FATAL.",
        placement: "left"
      }],
      container: "body",
      smartPlacement: true,
      keyboard: true,
      storage: false,
      debug: false,
      backdrop: true,
      backdropContainer: 'body',
      backdropPadding: 0,
      redirect: true,
      orphan: false,
      duration: false,
      delay: false,
      basePath: "",
      template: "<div class='popover tour'>" +
      "<div class='arrow'></div>" +
      "<h3 class='popover-title'></h3>" +
      "<div class='popover-content'></div>" +
      "<div class='popover-navigation'>" +
      "<button class='btn btn-default' data-role='next'>Next »</button>" +
      "<button class='btn btn-default' data-role='end'>Close</button>" +
      "</div>" +
      "</div>",
      afterGetState: function (key, value) {
      },
      afterSetState: function (key, value) {
      },
      afterRemoveState: function (key, value) {
      },
      onShow: function (tour) {
      },
      onShown: function (tour) {
        var stepElement = getTourElement(tour);
        $(stepElement).after($('.tour-step-background'));
        $(stepElement).before($('.tour-backdrop'));

        if (tour._state.current_step == 1) {
          appendFingerAndOverlayDiv(tour._options.showFinger[tour._state.current_step]);
        } else if (tour._state.current_step == 2) {
          appendFingerAndOverlayDiv(tour._options.showFinger[tour._state.current_step]);
        } else if (tour._state.current_step == 3) {
          appendFingerAndOverlayDiv(tour._options.showFinger[tour._state.current_step]);
        } else if (tour._state.current_step == 4) {
        } else if (tour._state.current_step == 5) {
        } else if (tour._state.current_step == 6) {
        } else if (tour._state.current_step == 7) {
          appendFingerAndOverlayDiv(tour._options.showFinger[tour._state.current_step]);
        } else if (tour._state.current_step == 9) {
          appendFingerAndOverlayDiv(tour._options.showFinger[tour._state.current_step]);
        } else if (tour._state.current_step == 10) {
          appendFingerAndOverlayDiv(tour._options.showFinger[tour._state.current_step]);
        } else if (tour._state.current_step == 11) {
          appendFingerAndOverlayDiv(tour._options.showFinger[tour._state.current_step]);
        } else if (tour._state.current_step == 12) {
          appendFingerAndOverlayDiv(tour._options.showFinger[tour._state.current_step]);
        } else if (tour._state.current_step == 13) {
          $('[data-id="r_tableList"]').find('table thead tr').css({'display': '-webkit-box'});
          $('[data-id="r_tableList"]').find('table tbody tr').css({'display': '-webkit-box'});
          $('[data-id="r_tableList"]').find('table thead tr').css({'display': '-moz-box'});
          $('[data-id="r_tableList"]').find('table tbody tr').css({'display': '-moz-box'});
        } else if (tour._state.current_step == 14) {
          console.log("14")
        }

        var count = $('body').find('.finger');
        if (count.length > 1) {
          $('body').find('.finger:first').remove();
        }
      }

    }),
      TourJs.bindEvent(tour),
      tour.start();

    //add all animation and overlay div
    function appendFingerAndOverlayDiv(options) {
      $('.tour-step-backdrop:first').append('<div class="animated infinite finger ' + options.handClass + '"><i class="fa fa-hand-o-' + options.handDirection + ' fa-2x"></i></div>');
      $('.tour-step-backdrop:first').find('.finger').css(options.css);
    };

    var overlay = document.createElement('div');
    overlay.setAttribute('class', 'overlayIntro');
    $('body').append(overlay);
  };

  TourJs.bindEvent = function (tour) {
    var that = this;
    var tourCallBack = tour._options;

    var optionSet = {
      0: {
        css: {
          'top': '0px',
          'left': '98px'
        },
        handDirection: 'down',
        handClass: "up-down"
      },
      1: {
        css: {
          'top': '0px',
          'left': '98px'
        },
        handDirection: 'down',
        handClass: "up-down"
      },
      2: {
        css: {
          'top': '0',
          'right': '95px'
        },
        handDirection: 'left',
        handClass: "left-right"
      },
      3: {
        css: {
          'top': '0',
          'left': '40px'
        },
        handDirection: 'right',
        handClass: "left-right"
      },
      4: {
        css: {
          'top': '0px',
          'left': '98px'
        },
        handDirection: 'down',
        handClass: "up-down"
      },
      5: {
        css: {
          'top': '10px',
          'left': '10px'
        },
        handDirection: 'right',
        handClass: "right-left"
      },
      // 6: {
      //     css: {
      //         'top': '10px',
      //         'left': '10px'
      //     },
      //     handDirection: 'right',
      //     handClass: "right-left"
      // },
      7: {
        css: {
          'top': '5px',
          'left': '100px'
        },
        handDirection: 'down',
        handClass: "up-down"
      },
      8: {
        css: {
          'top': '30px',
          'left': '309px'
        },
        handDirection: 'down',
        handClass: "up-down"
      },
      9: {
        css: {
          'top': '45px',
          'left': '122px'
        },
        handDirection: 'up',
        handClass: "up-down"
      },
      10: {
        css: {
          'top': '45px',
          'left': '100px'
        },
        appendIndex: 0,
        handDirection: 'down',
        handClass: "up-down"
      },
      11: {
        css: {
          'top': '45px',
          'right': '80px'
        },
        appendIndex: 1,
        handDirection: 'right',
        handText: "Components",
        handClass: "left-right"

      },
      12: {
        css: {
          'top': '30px',
          'left': '309px'
        },
        appendIndex: 0,
        handDirection: 'left',
        handClass: "left-right"
      },
      13: {
        css: {
          'top': '50px',
          'left': '0px'
        },
        appendIndex: 0,
        handDirection: 'up',
        handClass: "up-down"
      },
      14: {
        css: {
          'top': '0',
          'left': '0'
        },
        appendIndex: 0,
        handDirection: 'up',
        handClass: "up-down"
      },
      15: {
        css: {
          'top': '0',
          'left': '0'
        },
        handDirection: 'right',
        handClass: "left-right"
      },
      16: {
        css: {
          'top': '0',
          'left': '0'
        },
        handDirection: 'right',
        handClass: "left-right"
      },
      17: {
        css: {
          'top': '0',
          'left': '0'
        },
        handDirection: 'right',
        handClass: "left-right"
      },
      18: {
        css: {
          'top': '0',
          'left': '0'
        },
        handDirection: 'right',
        handClass: "left-right"
      },
      19: {
        css: {
          'top': '0',
          'left': '0'
        },
        handDirection: 'right',
        handClass: "left-right"
      }
    };

    $.extend(tour._options, {"showFinger": optionSet});

    // on tour start
    tourCallBack.onStart = function (tour) {
      $('.ui-dialog').fadeOut();
      $('.ui-widget-overlay').fadeOut();
      $('.compare').fadeOut();
      that.dataAttribute = $('div[role="tabpanel"]').find('.nav-tabs .active').attr('data-id');
      if (that.dataAttribute != "troubleshoot") {
        $('div[role="tabpanel"]').find('.nav-tabs [data-id="troubleshoot"] a').click();
      }
    };

    // on the Next button click
    tourCallBack.onNext = function (tour) {
      if (tour._state.current_step == 0) {
      } else if (tour._state.current_step == 1) {
        removeFingerAndOverlayDiv();
      } else if (tour._state.current_step == 2) {
        $("#showServicelog").css('z-index', '');
        removeFingerAndOverlayDiv();
      } else if (tour._state.current_step == 3) {
        $('div[role="tabpanel"]').find('.nav-tabs [data-id="hierarchy"] a').click();
        $("#showServicelog").css('z-index', 1);
      } else if (tour._state.current_step == 4) {
      } else if (tour._state.current_step == 5) {
        removeFingerAndOverlayDiv();
      } else if (tour._state.current_step == 6) {
        ($('[id="r_Histogram"]').find('.collapse-link').first().find('i').hasClass('fa-chevron-down')) ? $('[id="r_Histogram"]').find('.collapse-link').first().find('i').click() : '';
        removeFingerAndOverlayDiv();
      } else if (tour._state.current_step == 7) {
        ($('#r_BubbleTable a.collapse-link').first().find('i').hasClass('fa-chevron-down')) ? $('#r_BubbleTable a.collapse-link').first().find('i').click() : '';
        $('#r_BubbleTable li[data-parent="true"]').first().find('span[data-state="expand"]').first().click();
        $('#r_BubbleTable input[value="H"]').click();
        removeFingerAndOverlayDiv();
      } else if (tour._state.current_step == 8) {
        removeFingerAndOverlayDiv();
      } else if (tour._state.current_step == 9) {
        $('#r_BubbleTable li[data-parent="true"]').first().find('span[data-state="collapse"]').first().click();
        $('#r_BubbleTable li[data-parent="true"]').first().find('a[data-type="C"]').first().removeClass('hidden');
        removeFingerAndOverlayDiv();
      } else if (tour._state.current_step == 10) {
        $('#r_BubbleTable li[data-parent="true"]').first().find('a[data-type="C"]').first().removeClass('hidden');
        removeFingerAndOverlayDiv();
      } else if (tour._state.current_step == 11) {
        $('#r_BubbleTable input[value="T"]').click();
        removeFingerAndOverlayDiv();
      } else if (tour._state.current_step == 12) {
        setTimeout(function () {
          $('#rLogTable').find('.btn-quickMenu').first().click();
        }, 300);
        removeFingerAndOverlayDiv();
      } else if (tour._state.current_step == 13) {
        $('[data-id="r_tableList"]').find('table thead tr').css({'display': ''});
        $('[data-id="r_tableList"]').find('table tbody tr').css({'display': ''});
        $('div[role="tabpanel"]').find('.nav-tabs [data-id="audit"] a').click();
        removeFingerAndOverlayDiv();
      } else if (tour._state.current_step == 14) {
        ($('#r_AuditLine a.collapse-link').first().find('i').hasClass('fa-chevron-down')) ? $('#r_AuditLine a.collapse-link').first().find('i').click() : '';
        removeFingerAndOverlayDiv();
      } else if (tour._state.current_step == 15) {
        ($('#AuditSearch a.collapse-link').first().find('i').hasClass('fa-chevron-down')) ? $('#AuditSearch a.collapse-link').first().find('i').click() : '';
        removeFingerAndOverlayDiv();
      } else if (tour._state.current_step == 16) {
        removeFingerAndOverlayDiv();
      } else if (tour._state.current_step == 17) {
      }

    };

    // on tour Ends
    tourCallBack.onEnd = function (tour) {
      tabClick();
      $('body').find('.overlayIntro').remove();
      $('.ui-dialog').fadeIn();
      $('.ui-widget-overlay').fadeIn();
      $('.compare').fadeIn();
      removeFingerAndOverlayDiv();
      $('[data-id="r_tableList"]').find('table thead tr').css({'display': ''});
      $('[data-id="r_tableList"]').find('table tbody tr').css({'display': ''});
    };

    function tabClick() {
      if (!that.dataAttribute) {
        $('div[role="tabpanel"]').find('.nav-tabs [data-id="troubleshoot"] a').click();
      } else {
        $('div[role="tabpanel"]').find('.nav-tabs [data-id=' + that.dataAttribute + '] a').click();
      }
      window.scrollTo(0, 0);
    };

    //remove all animation and overlay div
    function removeFingerAndOverlayDiv() {
      $('body').find('.finger').remove();
    };

  }


  return TourJs;
});