/**
* Licensed to the Apache Software Foundation (ASF) under one
* or more contributor license agreements.  See the NOTICE file
* distributed with this work for additional information
* regarding copyright ownership.  The ASF licenses this file
* to you under the Apache License, Version 2.0 (the
* "License"); you may not use this file except in compliance
* with the License.  You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

 define([
	'backbone',
	'communicator'
],
function( Backbone, Communicator ) {
    'use strict';

	var RegionManager = Backbone.Marionette.Controller.extend({

		initialize: function( options ) {
			console.log("Initialize a Region Manager");

			/* internal region manager */
			this._regionManager = new Backbone.Marionette.RegionManager();

			/* event API */
			Communicator.reqres.setHandler("RM:addRegion", this.addRegion, this);
			Communicator.reqres.setHandler("RM:removeRegion", this.removeRegion, this);
			Communicator.reqres.setHandler("RM:getRegion", this.getRegion, this);
		},

		/* add region facade */
		addRegion: function( regionName, regionId ) {
			var region = this.getRegion( regionName );

			if( region ) {
				console.log("REGION ALREADY CREATED TO JUST RETURN REF");
				return region;
			}

			return this._regionManager.addRegion( regionName, regionId );
		},

		/* remove region facade */
		removeRegion: function( regionName ) {
			this._regionManager.removeRegion( regionName );
		},

		/* get region facade */
		getRegion: function( regionName ) {
			return this._regionManager.get( regionName );
		}
	});

	return new RegionManager();
});
