/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.xml.serializer.WriterChain;

public abstract class WriterOptimized
extends Writer
implements WriterChain {
    protected static final int BYTES_MAX = 16384;
    static final int CHARS_MAX = 5461;
    OutputStream m_os;
    protected final byte[] m_outputBytes;
    final char[] m_inputChars;
    protected int count;

    protected WriterOptimized(OutputStream outputStream) {
        this.m_os = outputStream;
        this.m_outputBytes = new byte[16387];
        this.m_inputChars = new char[5463];
        this.count = 0;
    }

    protected WriterOptimized() {
        this.m_inputChars = null;
        this.m_outputBytes = null;
    }

    @Override
    public abstract void write(int var1) throws IOException;

    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        int n3 = 3 * n2;
        if (n3 >= 16384 - this.count) {
            this.flushBuffer();
            if (n3 > 16384) {
                int n4 = this.getNumberOfChunks(n2);
                int n5 = n;
                for (int i = 1; i <= n4; ++i) {
                    int n6 = n5;
                    n5 = this.getEndOfChunk(n, n2, n4, i);
                    char c = cArray[n5 - 1];
                    if (c >= '\ud800' && c <= '\udbff') {
                        n5 = n5 < n + n2 ? ++n5 : --n5;
                    }
                    int n7 = n5 - n6;
                    this.write(cArray, n6, n7);
                }
                return;
            }
        }
        this.writeCharsNoChunking(cArray, n, n2);
    }

    abstract void writeCharsNoChunking(char[] var1, int var2, int var3);

    abstract void writeASCIINoChunking(char[] var1, int var2, int var3);

    private final int getNumberOfChunks(int n) {
        int n2 = n / 5461;
        int n3 = n % 5461 > 0 ? n2 + 1 : n2;
        return n3;
    }

    @Override
    public void write(String string) throws IOException {
        int n = string.length();
        int n2 = 3 * n;
        if (n2 >= 16384 - this.count) {
            this.flushBuffer();
            if (n2 > 16384) {
                int n3 = this.getNumberOfChunks(n);
                int n4 = 0;
                for (int i = 1; i <= n3; ++i) {
                    int n5 = n4;
                    n4 = this.getEndOfChunk(0, n, n3, i);
                    string.getChars(n5, n4, this.m_inputChars, 0);
                    int n6 = n4 - n5;
                    char c = this.m_inputChars[n6 - 1];
                    if (c >= '\ud800' && c <= '\udbff') {
                        --n4;
                        --n6;
                        if (i == n3) {
                            // empty if block
                        }
                    }
                    this.write(this.m_inputChars, 0, n6);
                }
                return;
            }
        }
        string.getChars(0, n, this.m_inputChars, 0);
        char[] cArray = this.m_inputChars;
        this.writeCharsNoChunking(cArray, 0, n);
    }

    void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.m_os.write(this.m_outputBytes, 0, this.count);
            this.count = 0;
        }
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        this.m_os.flush();
    }

    @Override
    public void close() throws IOException {
        this.flushBuffer();
        this.m_os.close();
    }

    @Override
    public OutputStream getOutputStream() {
        return this.m_os;
    }

    @Override
    public Writer getWriter() {
        return null;
    }

    void writeASCII(char[] cArray, int n, int n2) throws IOException {
        int n3 = 3 * n2;
        if (n3 >= 16384 - this.count) {
            this.flushBuffer();
            if (n3 > 16384) {
                int n4 = this.getNumberOfChunks(n2);
                int n5 = n;
                for (int i = 1; i <= n4; ++i) {
                    int n6 = n5;
                    n5 = this.getEndOfChunk(n, n2, n4, i);
                    int n7 = n5 - n6;
                    this.writeASCII(cArray, n6, n7);
                }
                return;
            }
        }
        this.writeASCIINoChunking(cArray, n, n2);
    }

    void writeBytes(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 3 * n2;
        if (n3 >= 16384 - this.count) {
            this.flushBuffer();
            if (n3 > 16384) {
                int n4 = this.getNumberOfChunks(n2);
                int n5 = n;
                for (int i = 1; i <= n4; ++i) {
                    int n6 = n5;
                    n5 = this.getEndOfChunk(n, n2, n4, i);
                    int n7 = n5 - n6;
                    this.writeBytes(byArray, n6, n7);
                }
                return;
            }
        }
        int n8 = n2 + n;
        byte[] byArray2 = this.m_outputBytes;
        int n9 = this.count;
        for (int i = n; i < n8; ++i) {
            byArray2[n9++] = byArray[i];
        }
        this.count = n9;
    }

    private final int getEndOfChunk(int n, int n2, int n3, int n4) {
        return n + (int)((long)n2 * (long)n4 / (long)n3);
    }

    void writeASCII(String string) throws IOException {
        int n = string.length();
        int n2 = 3 * n;
        if (n2 >= 16384 - this.count) {
            this.flushBuffer();
            if (n2 > 16384) {
                int n3 = this.getNumberOfChunks(n);
                int n4 = 0;
                for (int i = 1; i <= n3; ++i) {
                    int n5 = n4;
                    n4 = this.getEndOfChunk(0, n, n3, i);
                    string.getChars(n5, n4, this.m_inputChars, 0);
                    int n6 = n4 - n5;
                    this.writeASCII(this.m_inputChars, 0, n6);
                }
                return;
            }
        }
        string.getChars(0, n, this.m_inputChars, 0);
        char[] cArray = this.m_inputChars;
        this.writeASCIINoChunking(cArray, 0, n);
    }

    void setOuputStream(OutputStream outputStream) {
        this.m_os = outputStream;
        this.count = 0;
    }
}

