/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import javax.xml.transform.SourceLocator;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMAxisIterator;
import org.apache.xml.dtm.DTMAxisTraverser;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.DTMWSFilter;
import org.apache.xml.dtm.ref.ChunkedIntArray;
import org.apache.xml.dtm.ref.DTMStringPool;
import org.apache.xml.dtm.ref.ExpandedNameTable;
import org.apache.xml.dtm.ref.IncrementalSAXSource;
import org.apache.xml.dtm.ref.IncrementalSAXSource_Filter;
import org.apache.xml.utils.FastStringBuffer;
import org.apache.xml.utils.XMLString;
import org.apache.xml.utils.XMLStringFactory;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public class DTMDocumentImpl
implements DTM,
ContentHandler,
LexicalHandler {
    protected static final byte DOCHANDLE_SHIFT = 22;
    protected static final int NODEHANDLE_MASK = 0x7FFFFF;
    protected static final int DOCHANDLE_MASK = -8388608;
    int m_docHandle = -1;
    int m_docElement = -1;
    int currentParent = 0;
    int previousSibling = 0;
    protected int m_currentNode = -1;
    private boolean previousSiblingWasParent = false;
    int[] gotslot = new int[4];
    private boolean done = false;
    boolean m_isError = false;
    private final boolean DEBUG = false;
    protected String m_documentBaseURI;
    private IncrementalSAXSource m_incrSAXSource = null;
    ChunkedIntArray nodes = new ChunkedIntArray(4);
    private FastStringBuffer m_char = new FastStringBuffer();
    private int m_char_current_start = 0;
    private DTMStringPool m_localNames = new DTMStringPool();
    private DTMStringPool m_nsNames = new DTMStringPool();
    private DTMStringPool m_prefixNames = new DTMStringPool();
    private ExpandedNameTable m_expandedNames = new ExpandedNameTable();
    private XMLStringFactory m_xsf;
    private static final String[] fixednames = new String[]{null, null, null, "#text", "#cdata_section", null, null, null, "#comment", "#document", null, "#document-fragment", null};

    public DTMDocumentImpl(DTMManager dTMManager, int n, DTMWSFilter dTMWSFilter, XMLStringFactory xMLStringFactory) {
        this.initDocument(n);
        this.m_xsf = xMLStringFactory;
    }

    public void setIncrementalSAXSource(IncrementalSAXSource incrementalSAXSource) {
        this.m_incrSAXSource = incrementalSAXSource;
        incrementalSAXSource.setContentHandler(this);
        incrementalSAXSource.setLexicalHandler(this);
    }

    private final int appendNode(int n, int n2, int n3, int n4) {
        int n5 = this.nodes.appendSlot(n, n2, n3, n4);
        if (this.previousSiblingWasParent) {
            this.nodes.writeEntry(this.previousSibling, 2, n5);
        }
        this.previousSiblingWasParent = false;
        return n5;
    }

    @Override
    public void setFeature(String string, boolean bl) {
    }

    public void setLocalNameTable(DTMStringPool dTMStringPool) {
        this.m_localNames = dTMStringPool;
    }

    public DTMStringPool getLocalNameTable() {
        return this.m_localNames;
    }

    public void setNsNameTable(DTMStringPool dTMStringPool) {
        this.m_nsNames = dTMStringPool;
    }

    public DTMStringPool getNsNameTable() {
        return this.m_nsNames;
    }

    public void setPrefixNameTable(DTMStringPool dTMStringPool) {
        this.m_prefixNames = dTMStringPool;
    }

    public DTMStringPool getPrefixNameTable() {
        return this.m_prefixNames;
    }

    void setContentBuffer(FastStringBuffer fastStringBuffer) {
        this.m_char = fastStringBuffer;
    }

    FastStringBuffer getContentBuffer() {
        return this.m_char;
    }

    @Override
    public ContentHandler getContentHandler() {
        if (this.m_incrSAXSource instanceof IncrementalSAXSource_Filter) {
            return (ContentHandler)((Object)this.m_incrSAXSource);
        }
        return this;
    }

    @Override
    public LexicalHandler getLexicalHandler() {
        if (this.m_incrSAXSource instanceof IncrementalSAXSource_Filter) {
            return (LexicalHandler)((Object)this.m_incrSAXSource);
        }
        return this;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return null;
    }

    @Override
    public DeclHandler getDeclHandler() {
        return null;
    }

    @Override
    public boolean needsTwoThreads() {
        return null != this.m_incrSAXSource;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.m_char.append(cArray, n, n2);
    }

    private void processAccumulatedText() {
        int n = this.m_char.length();
        if (n != this.m_char_current_start) {
            this.appendTextChild(this.m_char_current_start, n - this.m_char_current_start);
            this.m_char_current_start = n;
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.appendEndDocument();
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        this.processAccumulatedText();
        this.appendEndElement();
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        this.processAccumulatedText();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
        this.processAccumulatedText();
    }

    @Override
    public void startDocument() throws SAXException {
        this.appendStartDocument();
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        int n;
        this.processAccumulatedText();
        String string4 = null;
        int n2 = string3.indexOf(58);
        if (n2 > 0) {
            string4 = string3.substring(0, n2);
        }
        System.out.println("Prefix=" + string4 + " index=" + this.m_prefixNames.stringToIndex(string4));
        this.appendStartElement(this.m_nsNames.stringToIndex(string), this.m_localNames.stringToIndex(string2), this.m_prefixNames.stringToIndex(string4));
        int n3 = attributes == null ? 0 : attributes.getLength();
        for (n = n3 - 1; n >= 0; --n) {
            string3 = attributes.getQName(n);
            if (!string3.startsWith("xmlns:") && !"xmlns".equals(string3)) continue;
            string4 = null;
            n2 = string3.indexOf(58);
            string4 = n2 > 0 ? string3.substring(0, n2) : null;
            this.appendNSDeclaration(this.m_prefixNames.stringToIndex(string4), this.m_nsNames.stringToIndex(attributes.getValue(n)), attributes.getType(n).equalsIgnoreCase("ID"));
        }
        for (n = n3 - 1; n >= 0; --n) {
            string3 = attributes.getQName(n);
            if (string3.startsWith("xmlns:") || "xmlns".equals(string3)) continue;
            string4 = null;
            n2 = string3.indexOf(58);
            if (n2 > 0) {
                string4 = string3.substring(0, n2);
                string2 = string3.substring(n2 + 1);
            } else {
                string4 = "";
                string2 = string3;
            }
            this.m_char.append(attributes.getValue(n));
            int n4 = this.m_char.length();
            if (!"xmlns".equals(string4) && !"xmlns".equals(string3)) {
                this.appendAttribute(this.m_nsNames.stringToIndex(attributes.getURI(n)), this.m_localNames.stringToIndex(string2), this.m_prefixNames.stringToIndex(string4), attributes.getType(n).equalsIgnoreCase("ID"), this.m_char_current_start, n4 - this.m_char_current_start);
            }
            this.m_char_current_start = n4;
        }
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws SAXException {
        this.processAccumulatedText();
        this.m_char.append(cArray, n, n2);
        this.appendComment(this.m_char_current_start, n2);
        this.m_char_current_start += n2;
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void endEntity(String string) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void startDTD(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void startEntity(String string) throws SAXException {
    }

    final void initDocument(int n) {
        this.m_docHandle = n << 22;
        this.nodes.writeSlot(0, 9, -1, -1, 0);
        this.done = false;
    }

    @Override
    public boolean hasChildNodes(int n) {
        return this.getFirstChild(n) != -1;
    }

    @Override
    public int getFirstChild(int n) {
        this.nodes.readSlot(n &= 0x7FFFFF, this.gotslot);
        short s = (short)(this.gotslot[0] & 0xFFFF);
        if (s == 1 || s == 9 || s == 5) {
            int n2 = n + 1;
            this.nodes.readSlot(n2, this.gotslot);
            while (2 == (this.gotslot[0] & 0xFFFF)) {
                n2 = this.gotslot[2];
                if (n2 == -1) {
                    return -1;
                }
                this.nodes.readSlot(n2, this.gotslot);
            }
            if (this.gotslot[1] == n) {
                int n3 = n2 | this.m_docHandle;
                return n3;
            }
        }
        return -1;
    }

    @Override
    public int getLastChild(int n) {
        int n2 = -1;
        int n3 = this.getFirstChild(n &= 0x7FFFFF);
        while (n3 != -1) {
            n2 = n3;
            n3 = this.getNextSibling(n3);
        }
        return n2 | this.m_docHandle;
    }

    @Override
    public int getAttributeNode(int n, String string, String string2) {
        int n2 = this.m_nsNames.stringToIndex(string);
        int n3 = this.m_localNames.stringToIndex(string2);
        this.nodes.readSlot(n &= 0x7FFFFF, this.gotslot);
        short s = (short)(this.gotslot[0] & 0xFFFF);
        if (s == 1) {
            ++n;
        }
        while (s == 2) {
            if (n2 == this.gotslot[0] << 16 && this.gotslot[3] == n3) {
                return n | this.m_docHandle;
            }
            n = this.gotslot[2];
            this.nodes.readSlot(n, this.gotslot);
        }
        return -1;
    }

    @Override
    public int getFirstAttribute(int n) {
        if (1 != (this.nodes.readEntry(n &= 0x7FFFFF, 0) & 0xFFFF)) {
            return -1;
        }
        return 2 == (this.nodes.readEntry(++n, 0) & 0xFFFF) ? n | this.m_docHandle : -1;
    }

    @Override
    public int getFirstNamespaceNode(int n, boolean bl) {
        return -1;
    }

    @Override
    public int getNextSibling(int n) {
        int n2;
        if ((n &= 0x7FFFFF) == 0) {
            return -1;
        }
        short s = (short)(this.nodes.readEntry(n, 0) & 0xFFFF);
        if (s == 1 || s == 2 || s == 5) {
            n2 = this.nodes.readEntry(n, 2);
            if (n2 == -1) {
                return -1;
            }
            if (n2 != 0) {
                return this.m_docHandle | n2;
            }
        }
        n2 = this.nodes.readEntry(n, 1);
        if (this.nodes.readEntry(++n, 1) == n2) {
            return this.m_docHandle | n;
        }
        return -1;
    }

    @Override
    public int getPreviousSibling(int n) {
        if ((n &= 0x7FFFFF) == 0) {
            return -1;
        }
        int n2 = this.nodes.readEntry(n, 1);
        int n3 = -1;
        int n4 = this.getFirstChild(n2);
        while (n4 != n) {
            n3 = n4;
            n4 = this.getNextSibling(n4);
        }
        return n3 | this.m_docHandle;
    }

    @Override
    public int getNextAttribute(int n) {
        this.nodes.readSlot(n &= 0x7FFFFF, this.gotslot);
        short s = (short)(this.gotslot[0] & 0xFFFF);
        if (s == 1) {
            return this.getFirstAttribute(n);
        }
        if (s == 2 && this.gotslot[2] != -1) {
            return this.m_docHandle | this.gotslot[2];
        }
        return -1;
    }

    @Override
    public int getNextNamespaceNode(int n, int n2, boolean bl) {
        return -1;
    }

    public int getNextDescendant(int n, int n2) {
        n &= 0x7FFFFF;
        if ((n2 &= 0x7FFFFF) == 0) {
            return -1;
        }
        while (!(this.m_isError || this.done && n2 > this.nodes.slotsUsed())) {
            if (n2 > n) {
                this.nodes.readSlot(n2 + 1, this.gotslot);
                if (this.gotslot[2] != 0) {
                    short s = (short)(this.gotslot[0] & 0xFFFF);
                    if (s == 2) {
                        n2 += 2;
                        continue;
                    }
                    int n3 = this.gotslot[1];
                    if (n3 < n) break;
                    return this.m_docHandle | n2 + 1;
                }
                if (this.done) break;
                continue;
            }
            ++n2;
        }
        return -1;
    }

    public int getNextFollowing(int n, int n2) {
        return -1;
    }

    public int getNextPreceding(int n, int n2) {
        n2 &= 0x7FFFFF;
        while (n2 > 1) {
            if (2 == (this.nodes.readEntry(--n2, 0) & 0xFFFF)) continue;
            return this.m_docHandle | this.nodes.specialFind(n, n2);
        }
        return -1;
    }

    @Override
    public int getParent(int n) {
        return this.m_docHandle | this.nodes.readEntry(n, 1);
    }

    public int getDocumentRoot() {
        return this.m_docHandle | this.m_docElement;
    }

    @Override
    public int getDocument() {
        return this.m_docHandle;
    }

    @Override
    public int getOwnerDocument(int n) {
        if ((n & 0x7FFFFF) == 0) {
            return -1;
        }
        return n & 0xFF800000;
    }

    @Override
    public int getDocumentRoot(int n) {
        if ((n & 0x7FFFFF) == 0) {
            return -1;
        }
        return n & 0xFF800000;
    }

    @Override
    public XMLString getStringValue(int n) {
        this.nodes.readSlot(n, this.gotslot);
        int n2 = this.gotslot[0] & 0xFF;
        String string = null;
        switch (n2) {
            case 3: 
            case 4: 
            case 8: {
                string = this.m_char.getString(this.gotslot[2], this.gotslot[3]);
                break;
            }
        }
        return this.m_xsf.newstr(string);
    }

    @Override
    public int getStringValueChunkCount(int n) {
        return 0;
    }

    @Override
    public char[] getStringValueChunk(int n, int n2, int[] nArray) {
        return new char[0];
    }

    @Override
    public int getExpandedTypeID(int n) {
        this.nodes.readSlot(n, this.gotslot);
        String string = this.m_localNames.indexToString(this.gotslot[3]);
        int n2 = string.indexOf(":");
        String string2 = string.substring(n2 + 1);
        String string3 = this.m_nsNames.indexToString(this.gotslot[0] << 16);
        String string4 = string3 + ":" + string2;
        int n3 = this.m_nsNames.stringToIndex(string4);
        return n3;
    }

    @Override
    public int getExpandedTypeID(String string, String string2, int n) {
        String string3 = string + ":" + string2;
        int n2 = this.m_nsNames.stringToIndex(string3);
        return n2;
    }

    @Override
    public String getLocalNameFromExpandedNameID(int n) {
        String string = this.m_localNames.indexToString(n);
        int n2 = string.indexOf(":");
        String string2 = string.substring(n2 + 1);
        return string2;
    }

    @Override
    public String getNamespaceFromExpandedNameID(int n) {
        String string = this.m_localNames.indexToString(n);
        int n2 = string.indexOf(":");
        String string2 = string.substring(0, n2);
        return string2;
    }

    @Override
    public String getNodeName(int n) {
        this.nodes.readSlot(n, this.gotslot);
        short s = (short)(this.gotslot[0] & 0xFFFF);
        String string = fixednames[s];
        if (null == string) {
            int n2 = this.gotslot[3];
            System.out.println("got i=" + n2 + " " + (n2 >> 16) + "/" + (n2 & 0xFFFF));
            string = this.m_localNames.indexToString(n2 & 0xFFFF);
            String string2 = this.m_prefixNames.indexToString(n2 >> 16);
            if (string2 != null && string2.length() > 0) {
                string = string2 + ":" + string;
            }
        }
        return string;
    }

    @Override
    public String getNodeNameX(int n) {
        return null;
    }

    @Override
    public String getLocalName(int n) {
        int n2;
        this.nodes.readSlot(n, this.gotslot);
        short s = (short)(this.gotslot[0] & 0xFFFF);
        String string = "";
        if ((s == 1 || s == 2) && (string = this.m_localNames.indexToString((n2 = this.gotslot[3]) & 0xFFFF)) == null) {
            string = "";
        }
        return string;
    }

    @Override
    public String getPrefix(int n) {
        int n2;
        this.nodes.readSlot(n, this.gotslot);
        short s = (short)(this.gotslot[0] & 0xFFFF);
        String string = "";
        if ((s == 1 || s == 2) && (string = this.m_prefixNames.indexToString((n2 = this.gotslot[3]) >> 16)) == null) {
            string = "";
        }
        return string;
    }

    @Override
    public String getNamespaceURI(int n) {
        return null;
    }

    @Override
    public String getNodeValue(int n) {
        this.nodes.readSlot(n, this.gotslot);
        int n2 = this.gotslot[0] & 0xFF;
        String string = null;
        switch (n2) {
            case 2: {
                this.nodes.readSlot(n + 1, this.gotslot);
            }
            case 3: 
            case 4: 
            case 8: {
                string = this.m_char.getString(this.gotslot[2], this.gotslot[3]);
                break;
            }
        }
        return string;
    }

    @Override
    public short getNodeType(int n) {
        return (short)(this.nodes.readEntry(n, 0) & 0xFFFF);
    }

    @Override
    public short getLevel(int n) {
        short s = 0;
        while (n != 0) {
            s = (short)(s + 1);
            n = this.nodes.readEntry(n, 1);
        }
        return s;
    }

    @Override
    public boolean isSupported(String string, String string2) {
        return false;
    }

    @Override
    public String getDocumentBaseURI() {
        return this.m_documentBaseURI;
    }

    @Override
    public void setDocumentBaseURI(String string) {
        this.m_documentBaseURI = string;
    }

    @Override
    public String getDocumentSystemIdentifier(int n) {
        return null;
    }

    @Override
    public String getDocumentEncoding(int n) {
        return null;
    }

    @Override
    public String getDocumentStandalone(int n) {
        return null;
    }

    @Override
    public String getDocumentVersion(int n) {
        return null;
    }

    @Override
    public boolean getDocumentAllDeclarationsProcessed() {
        return false;
    }

    @Override
    public String getDocumentTypeDeclarationSystemIdentifier() {
        return null;
    }

    @Override
    public String getDocumentTypeDeclarationPublicIdentifier() {
        return null;
    }

    @Override
    public int getElementById(String string) {
        return 0;
    }

    @Override
    public String getUnparsedEntityURI(String string) {
        return null;
    }

    @Override
    public boolean supportsPreStripping() {
        return false;
    }

    @Override
    public boolean isNodeAfter(int n, int n2) {
        return false;
    }

    @Override
    public boolean isCharacterElementContentWhitespace(int n) {
        return false;
    }

    @Override
    public boolean isDocumentAllDeclarationsProcessed(int n) {
        return false;
    }

    @Override
    public boolean isAttributeSpecified(int n) {
        return false;
    }

    @Override
    public void dispatchCharactersEvents(int n, ContentHandler contentHandler, boolean bl) throws SAXException {
    }

    @Override
    public void dispatchToEvents(int n, ContentHandler contentHandler) throws SAXException {
    }

    @Override
    public Node getNode(int n) {
        return null;
    }

    @Override
    public void appendChild(int n, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = (n & 0xFF800000) == this.m_docHandle;
        if (bl || !bl3) {
            // empty if block
        }
    }

    @Override
    public void appendTextChild(String string) {
    }

    void appendTextChild(int n, int n2) {
        int n3;
        int n4 = 3;
        int n5 = this.currentParent;
        int n6 = n;
        int n7 = n2;
        this.previousSibling = n3 = this.appendNode(n4, n5, n6, n7);
    }

    void appendComment(int n, int n2) {
        int n3;
        int n4 = 8;
        int n5 = this.currentParent;
        int n6 = n;
        int n7 = n2;
        this.previousSibling = n3 = this.appendNode(n4, n5, n6, n7);
    }

    void appendStartElement(int n, int n2, int n3) {
        int n4;
        int n5 = n << 16 | 1;
        int n6 = this.currentParent;
        int n7 = 0;
        int n8 = n2 | n3 << 16;
        System.out.println("set w3=" + n8 + " " + (n8 >> 16) + "/" + (n8 & 0xFFFF));
        this.currentParent = n4 = this.appendNode(n5, n6, n7, n8);
        this.previousSibling = 0;
        if (this.m_docElement == -1) {
            this.m_docElement = n4;
        }
    }

    void appendNSDeclaration(int n, int n2, boolean bl) {
        int n3;
        int n4 = this.m_nsNames.stringToIndex("http://www.w3.org/2000/xmlns/");
        int n5 = 0xD | this.m_nsNames.stringToIndex("http://www.w3.org/2000/xmlns/") << 16;
        int n6 = this.currentParent;
        int n7 = 0;
        int n8 = n2;
        this.previousSibling = n3 = this.appendNode(n5, n6, n7, n8);
        this.previousSiblingWasParent = false;
    }

    void appendAttribute(int n, int n2, int n3, boolean bl, int n4, int n5) {
        int n6;
        int n7 = 2 | n << 16;
        int n8 = this.currentParent;
        int n9 = 0;
        int n10 = n2 | n3 << 16;
        System.out.println("set w3=" + n10 + " " + (n10 >> 16) + "/" + (n10 & 0xFFFF));
        this.previousSibling = n6 = this.appendNode(n7, n8, n9, n10);
        n7 = 3;
        n8 = n6;
        n9 = n4;
        n10 = n5;
        this.appendNode(n7, n8, n9, n10);
        this.previousSiblingWasParent = true;
    }

    @Override
    public DTMAxisTraverser getAxisTraverser(int n) {
        return null;
    }

    @Override
    public DTMAxisIterator getAxisIterator(int n) {
        return null;
    }

    @Override
    public DTMAxisIterator getTypedAxisIterator(int n, int n2) {
        return null;
    }

    void appendEndElement() {
        if (this.previousSiblingWasParent) {
            this.nodes.writeEntry(this.previousSibling, 2, -1);
        }
        this.previousSibling = this.currentParent;
        this.nodes.readSlot(this.currentParent, this.gotslot);
        this.currentParent = this.gotslot[1] & 0xFFFF;
        this.previousSiblingWasParent = true;
    }

    void appendStartDocument() {
        this.m_docElement = -1;
        this.initDocument(0);
    }

    void appendEndDocument() {
        this.done = true;
    }

    @Override
    public void setProperty(String string, Object object) {
    }

    @Override
    public SourceLocator getSourceLocatorFor(int n) {
        return null;
    }

    @Override
    public void documentRegistration() {
    }

    @Override
    public void documentRelease() {
    }

    @Override
    public void migrateTo(DTMManager dTMManager) {
    }
}

