/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.stax;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Vector;

public class StAXLogger {
    public static final int GET_PROPERTY = 0;
    public static final int NEXT = 1;
    public static final int REQUIRE = 2;
    public static final int GET_ELEMENT_TEXT = 3;
    public static final int NEXT_TAG = 4;
    public static final int HAS_NEXT = 5;
    public static final int CLOSE = 6;
    public static final int GET_NAMESPACE_URI_STRING = 7;
    public static final int IS_START_ELEMENT = 8;
    public static final int IS_END_ELEMENT = 9;
    public static final int IS_CHARACTERS = 10;
    public static final int IS_WHITESPACE = 11;
    public static final int GET_ATTRIBUTE_VALUE_STRING_STRING = 12;
    public static final int GET_ATTRIBUTE_COUNT = 13;
    public static final int GET_ATTRIBUTE_NAME = 14;
    public static final int GET_ATTRIBUTE_NAMESPACE = 15;
    public static final int GET_ATTRIBUTE_LOCALNAME = 16;
    public static final int GET_ATTRIBUTE_PREFIX = 17;
    public static final int GET_ATTRIBUTE_TYPE = 18;
    public static final int GET_ATTRIBUTE_VALUE_INT = 19;
    public static final int IS_ATTRIBUTE_SPECIFIED = 20;
    public static final int GET_NAMESPACE_COUNT = 21;
    public static final int GET_NAMESPACE_PREFIX = 22;
    public static final int GET_NAMESPACE_URI_INT = 23;
    public static final int GET_EVENT_TYPE = 24;
    public static final int GET_NAMESPACE_CONTEXT = 25;
    public static final int GET_TEXT = 26;
    public static final int GET_TEXT_CHARACTERS = 27;
    public static final int GET_TEXT_CHARACTERS_ARGS = 28;
    public static final int GET_TEXT_START = 29;
    public static final int GET_TEXT_LENGTH = 30;
    public static final int GET_ENCODING = 31;
    public static final int HAS_TEXT = 32;
    public static final int GET_LOCATION = 33;
    public static final int GET_NAME = 34;
    public static final int GET_LOCAL_NAME = 35;
    public static final int HAS_NAME = 36;
    public static final int GET_NAMESPACE_URI = 37;
    public static final int GET_PREFIX = 38;
    public static final int GET_VERSION = 39;
    public static final int IS_STANDALONE = 40;
    public static final int STANDALONE_SET = 41;
    public static final int GET_CHARACTER_ENCODING_SCHEME = 42;
    public static final int GET_PI_TARGET = 43;
    public static final int GET_PI_DATA = 44;
    public static final int WRITE_START_ELEMENT = 101;
    public static final int WRITE_EMPTY_ELEMENT = 102;
    public static final int WRITE_END_ELEMENT = 103;
    public static final int WRITE_START_DOCUMENT = 104;
    public static final int WRITE_END_DOCUMENT = 105;
    public static final int WRITE_ATTRIBUTE = 106;
    public static final int WRITE_NAMESPACE = 107;
    public static final int WRITE_DEFAULT_NAMESPACE = 108;
    public static final int WRITE_PROCESSING_INSTRUCTION = 109;
    public static final int WRITE_CDATA = 110;
    public static final int WRITE_COMMENT = 111;
    public static final int WRITE_DTD = 112;
    public static final int WRITE_ENTITY_REF = 113;
    public static final int WRITE_CHARACTERS = 114;
    public static final int FLUSH = 115;
    public static final int SET_PREFIX = 116;
    public static final int SET_DEFAULT_NAMESPACE = 117;
    public static final int SET_NAMESPACE_CONTEXT = 118;
    private static final boolean INCREMENTALLY_PRINT = true;
    private Vector methodCalls = new Vector();
    private MethodCall lastCall;

    public static String translateToMethodName(int n) {
        switch (n) {
            case 0: {
                return "getProperty";
            }
            case 1: {
                return "next";
            }
            case 2: {
                return "require";
            }
            case 3: {
                return "getElementText";
            }
            case 4: {
                return "nextTag";
            }
            case 5: {
                return "hasNext";
            }
            case 6: {
                return "close";
            }
            case 8: {
                return "isStartElement";
            }
            case 9: {
                return "isEndElement";
            }
            case 10: {
                return "isCharacters";
            }
            case 11: {
                return "isWhitespace";
            }
            case 13: {
                return "getAttributeCount";
            }
            case 14: {
                return "getAttributeName";
            }
            case 15: {
                return "getAttributeNamespace";
            }
            case 16: {
                return "getAttributeLocalname";
            }
            case 17: {
                return "getAttributePrefix";
            }
            case 18: {
                return "getAttributeType";
            }
            case 12: 
            case 19: {
                return "getAttributeValue";
            }
            case 20: {
                return "isAttributeSpecified";
            }
            case 21: {
                return "getNamespaceCount";
            }
            case 22: {
                return "getNamespacePrefix";
            }
            case 24: {
                return "getEventType";
            }
            case 25: {
                return "getNamespaceContext";
            }
            case 26: {
                return "getText";
            }
            case 27: 
            case 28: {
                return "getTextCharacters";
            }
            case 29: {
                return "getTextStart";
            }
            case 30: {
                return "getTextLength";
            }
            case 31: {
                return "getEncoding";
            }
            case 32: {
                return "hasNext";
            }
            case 33: {
                return "getLocation";
            }
            case 34: {
                return "getName";
            }
            case 35: {
                return "getLocalName";
            }
            case 36: {
                return "hasName";
            }
            case 7: 
            case 23: 
            case 37: {
                return "getNamespaceURI";
            }
            case 38: {
                return "getPrefix";
            }
            case 39: {
                return "getVersion";
            }
            case 40: {
                return "isStandalone";
            }
            case 41: {
                return "standaloneSet";
            }
            case 42: {
                return "getCharacterEncodingScheme";
            }
            case 43: {
                return "getPITarget";
            }
            case 44: {
                return "getPIData";
            }
            case 101: {
                return "writeStartElement";
            }
            case 102: {
                return "writeEmptyElement";
            }
            case 103: {
                return "writeEndElement";
            }
            case 104: {
                return "writeStartDocument";
            }
            case 105: {
                return "writeEndDocument";
            }
            case 106: {
                return "writeAttribute";
            }
            case 107: {
                return "writeNamespace";
            }
            case 108: {
                return "writeDefaultNamespace";
            }
            case 109: {
                return "writeProcessingInstruction";
            }
            case 110: {
                return "writeCData";
            }
            case 111: {
                return "writeComment";
            }
            case 112: {
                return "writeDTD";
            }
            case 113: {
                return "writeEnittyRef";
            }
            case 114: {
                return "writeCharacters";
            }
            case 115: {
                return "flush";
            }
            case 116: {
                return "setPrefix";
            }
            case 117: {
                return "setDefaultNamespace";
            }
            case 118: {
                return "setNamespaceContext";
            }
        }
        return null;
    }

    public static String translateToCodeString(int n) {
        switch (n) {
            case 0: {
                return "GET_PROPERTY";
            }
            case 1: {
                return "NEXT";
            }
            case 2: {
                return "REQUIRE";
            }
            case 3: {
                return "GET_ELEMENT_TEXT";
            }
            case 4: {
                return "NEXT_TAG";
            }
            case 5: {
                return "HAS_NEXT";
            }
            case 6: {
                return "CLOSE";
            }
            case 7: {
                return "GET_NAMESPACE_URI_STRING";
            }
            case 8: {
                return "IS_START_ELEMENT";
            }
            case 9: {
                return "IS_END_ELEMENT";
            }
            case 10: {
                return "IS_CHARACTERS";
            }
            case 11: {
                return "IS_WHITESPACE";
            }
            case 12: {
                return "GET_ATTRIBUTE_VALUE_STRING_STRING";
            }
            case 13: {
                return "GET_ATTRIBUTE_COUNT";
            }
            case 14: {
                return "GET_ATTRIBUTE_NAME";
            }
            case 15: {
                return "GET_ATTRIBUTE_NAMESPACE";
            }
            case 16: {
                return "GET_ATTRIBUTE_LOCALNAME";
            }
            case 17: {
                return "GET_ATTRIBUTE_PREFIX";
            }
            case 18: {
                return "GET_ATTRIBUTE_TYPE";
            }
            case 19: {
                return "GET_ATTRIBUTE_VALUE_INT";
            }
            case 20: {
                return "IS_ATTRIBUTE_SPECIFIED";
            }
            case 21: {
                return "GET_NAMESPACE_COUNT";
            }
            case 22: {
                return "GET_NAMESPACE_PREFIX";
            }
            case 23: {
                return "GET_NAMESPACE_URI_INT";
            }
            case 24: {
                return "GET_EVENT_TYPE";
            }
            case 25: {
                return "GET_NAMESPACE_CONTEXT";
            }
            case 26: {
                return "GET_TEXT";
            }
            case 27: {
                return "GET_TEXT_CHARACTERS";
            }
            case 28: {
                return "GET_TEXT_CHARACTERS_ARGS";
            }
            case 29: {
                return "GET_TEXT_START";
            }
            case 30: {
                return "GET_TEXT_LENGTH";
            }
            case 31: {
                return "GET_ENCODING";
            }
            case 32: {
                return "HAS_TEXT";
            }
            case 33: {
                return "GET_LOCATION";
            }
            case 34: {
                return "GET_NAME";
            }
            case 35: {
                return "GET_LOCAL_NAME";
            }
            case 36: {
                return "HAS_NAME";
            }
            case 37: {
                return "GET_NAMESPACE_URI";
            }
            case 38: {
                return "GET_PREFIX";
            }
            case 39: {
                return "GET_VERSION";
            }
            case 40: {
                return "IS_STANDALONE";
            }
            case 41: {
                return "STANDALONE_SET";
            }
            case 42: {
                return "GET_CHARACTER_ENCODING_SCHEME";
            }
            case 43: {
                return "GET_PI_TARGET";
            }
            case 44: {
                return "GET_PI_DATA";
            }
            case 101: {
                return "WRITE_START_ELEMENT";
            }
            case 102: {
                return "WRITE_EMPTY_ELEMENT";
            }
            case 103: {
                return "WRITE_END_ELEMENT";
            }
            case 104: {
                return "WRITE_START_DOCUMENT";
            }
            case 105: {
                return "WRITE_END_DOCUMENT";
            }
            case 106: {
                return "WRITE_ATTRIBUTE";
            }
            case 107: {
                return "WRITE_NAMESPACE";
            }
            case 108: {
                return "WRITE_DEFAULT_NAMESPACE";
            }
            case 109: {
                return "WRITE_PROCESSING_INSTRUCTION";
            }
            case 110: {
                return "WRITE_CDATA";
            }
            case 111: {
                return "WRITE_COMMENT";
            }
            case 112: {
                return "WRITE_DTD";
            }
            case 113: {
                return "WRITE_ENTITY_REF";
            }
            case 114: {
                return "WRITE_CHARACTERS";
            }
            case 115: {
                return "FLUSH";
            }
            case 116: {
                return "SET_PREFIX";
            }
            case 117: {
                return "SET_DEFAULT_NAMESPACE";
            }
            case 118: {
                return "SET_NAMESPACE_CONTEXT";
            }
        }
        return null;
    }

    public void log(int n) {
        this.lastCall = new MethodCall(n);
        this.methodCalls.add(this.lastCall);
    }

    public void log(int n, int n2) {
        this.lastCall = new MethodCallInt(n, n2);
        this.methodCalls.add(this.lastCall);
    }

    public void log(int n, String string) {
        this.lastCall = new MethodCallString(n, string);
        this.methodCalls.add(this.lastCall);
    }

    public void log(int n, String string, String string2) {
        this.lastCall = new MethodCallObjects(n, new Object[]{string, string2});
        this.methodCalls.add(this.lastCall);
    }

    public void log(int n, String string, String string2, String string3) {
        this.lastCall = new MethodCallObjects(n, new Object[]{string, string2, string3});
        this.methodCalls.add(this.lastCall);
    }

    public void log(int n, Object[] objectArray) {
        this.lastCall = new MethodCallObjects(n, objectArray);
        this.methodCalls.add(this.lastCall);
    }

    public void logReturn() {
        this.printLastCall();
    }

    public void logReturn(int n) {
        this.lastCall.addReturn(new Integer(n));
        this.printLastCall();
    }

    public void logReturn(boolean bl) {
        this.lastCall.addReturn(new Boolean(bl));
        this.printLastCall();
    }

    public void logReturn(Object object) {
        this.lastCall.addReturn(object == null ? "null" : object);
        this.printLastCall();
    }

    public void logException(Exception exception) {
        this.printLastCall();
        this.printException(exception);
    }

    private void printLastCall() {
        System.err.println("[" + this.hashCode() + "] " + this.lastCall);
    }

    private void printException(Exception exception) {
        System.err.println("[" + this.hashCode() + "] Exception thrown from previous call: " + exception);
    }

    public void writeReadableProfile(String string) {
        PrintStream printStream = System.out;
        if (string != null) {
            try {
                printStream = new PrintStream(new FileOutputStream(string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("Couldn't open file: " + string);
            }
        }
        int n = 0;
        while (n < this.methodCalls.size()) {
            printStream.println(this.methodCalls.elementAt(n));
            ++n;
        }
    }

    public void writeStAXProfile(String string) {
        MethodCall methodCall;
        PrintStream printStream = System.out;
        if (string != null) {
            try {
                printStream = new PrintStream(new FileOutputStream(string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("Couldn't open file: " + string);
            }
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        printStream.println(this.methodCalls.size());
        int n4 = 0;
        while (n4 < this.methodCalls.size()) {
            MethodCall methodCall2 = (MethodCall)this.methodCalls.elementAt(n4);
            printStream.println(methodCall2.fCode);
            if (methodCall2.fReturnVal instanceof String) {
                ++n2;
            }
            if (methodCall2.fReturnVal instanceof Integer) {
                ++n3;
            }
            if (methodCall2.fReturnVal instanceof Boolean) {
                ++n;
            }
            ++n4;
        }
        printStream.println(n2);
        int n5 = 0;
        while (n5 < this.methodCalls.size()) {
            MethodCall methodCall3 = (MethodCall)this.methodCalls.elementAt(n5);
            if (methodCall3.fReturnVal instanceof String) {
                printStream.println(methodCall3.fReturnVal);
            }
            ++n5;
        }
        printStream.println(n3);
        int n6 = 0;
        while (n6 < this.methodCalls.size()) {
            MethodCall methodCall4 = (MethodCall)this.methodCalls.elementAt(n6);
            if (methodCall4.fReturnVal instanceof Integer) {
                printStream.println(methodCall4.fReturnVal);
            }
            ++n6;
        }
        printStream.println(n);
        int n7 = 0;
        while (n7 < this.methodCalls.size()) {
            MethodCall methodCall5 = (MethodCall)this.methodCalls.elementAt(n7);
            if (methodCall5.fReturnVal instanceof Boolean) {
                printStream.println(methodCall5.fReturnVal);
            }
            ++n7;
        }
        int n8 = 0;
        int n9 = 0;
        while (n9 < this.methodCalls.size()) {
            MethodCall methodCall6 = (MethodCall)this.methodCalls.elementAt(n9);
            if (methodCall6 instanceof MethodCallInt) {
                ++n8;
            }
            if (methodCall6 instanceof MethodCallObjects) {
                methodCall = (MethodCallObjects)methodCall6;
                int n10 = 0;
                while (n10 < ((MethodCallObjects)methodCall).fArgs.length) {
                    if (((MethodCallObjects)methodCall).fArgs[n10] instanceof Integer) {
                        ++n8;
                    }
                    ++n10;
                }
            }
            ++n9;
        }
        printStream.println(n8);
        int n11 = 0;
        while (n11 < this.methodCalls.size()) {
            methodCall = (MethodCall)this.methodCalls.elementAt(n11);
            if (methodCall instanceof MethodCallInt) {
                MethodCallInt methodCallInt = (MethodCallInt)methodCall;
                printStream.println(methodCallInt.fArg);
            }
            if (methodCall instanceof MethodCallObjects) {
                MethodCall methodCall7 = methodCall;
                int n12 = 0;
                while (n12 < ((MethodCallObjects)methodCall7).fArgs.length) {
                    if (((MethodCallObjects)methodCall7).fArgs[n12] instanceof Integer) {
                        printStream.print(((MethodCallObjects)methodCall7).fArgs[n12]);
                    }
                    ++n12;
                }
            }
            ++n11;
        }
        n8 = 0;
        int n13 = 0;
        while (n13 < this.methodCalls.size()) {
            MethodCall methodCall8 = (MethodCall)this.methodCalls.elementAt(n13);
            if (methodCall8 instanceof MethodCallString) {
                ++n8;
            }
            if (methodCall8 instanceof MethodCallObjects) {
                MethodCallObjects methodCallObjects = (MethodCallObjects)methodCall8;
                int n14 = 0;
                while (n14 < methodCallObjects.fArgs.length) {
                    if (methodCallObjects.fArgs[n14] instanceof String) {
                        ++n8;
                    }
                    ++n14;
                }
            }
            ++n13;
        }
        printStream.println(n8);
        int n15 = 0;
        while (n15 < this.methodCalls.size()) {
            MethodCall methodCall9 = (MethodCall)this.methodCalls.elementAt(n15);
            if (methodCall9 instanceof MethodCallString) {
                MethodCallString methodCallString = (MethodCallString)methodCall9;
                printStream.println(methodCallString.fArg);
            }
            if (methodCall9 instanceof MethodCallObjects) {
                MethodCallObjects methodCallObjects = (MethodCallObjects)methodCall9;
                int n16 = 0;
                while (n16 < methodCallObjects.fArgs.length) {
                    if (methodCallObjects.fArgs[n16] instanceof String) {
                        printStream.println(methodCallObjects.fArgs[n16]);
                    }
                    ++n16;
                }
            }
            ++n15;
        }
    }

    private static class MethodCallObjects
    extends MethodCall {
        private Object[] fArgs;

        public MethodCallObjects(int n, Object[] objectArray) {
            super(n);
            this.fArgs = objectArray;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            int n = 0;
            while (n < this.fArgs.length) {
                if (!bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = false;
                }
                if (this.fArgs[n] instanceof String) {
                    stringBuffer.append("\"");
                    stringBuffer.append(this.fArgs[n]);
                    stringBuffer.append("\"");
                } else {
                    stringBuffer.append(this.fArgs[n]);
                }
                ++n;
            }
            return StAXLogger.translateToMethodName(this.fCode) + "(" + stringBuffer + ")" + this.returnString();
        }
    }

    private static class MethodCallString
    extends MethodCall {
        private String fArg;

        public MethodCallString(int n, String string) {
            super(n);
            this.fArg = string;
        }

        public String toString() {
            return StAXLogger.translateToMethodName(this.fCode) + "(\"" + this.fArg + "\")" + this.returnString();
        }
    }

    private static class MethodCallInt
    extends MethodCall {
        private int fArg;

        public MethodCallInt(int n, int n2) {
            super(n);
            this.fArg = n2;
        }

        public String toString() {
            return StAXLogger.translateToMethodName(this.fCode) + "(" + this.fArg + ")" + this.returnString();
        }
    }

    private static class MethodCall {
        protected int fCode;
        protected Object fReturnVal;

        public MethodCall(int n) {
            this.fCode = n;
        }

        public void addReturn(Object object) {
            if (this.fReturnVal != null) {
                throw new IllegalStateException("Already have a return value.");
            }
            this.fReturnVal = object;
        }

        public String toString() {
            return StAXLogger.translateToMethodName(this.fCode) + "()" + this.returnString();
        }

        protected String returnString() {
            if (this.fReturnVal != null) {
                return " : " + this.fReturnVal;
            }
            return "";
        }
    }
}

